/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.manager.tableOps.tableImport.PopulateMetadataTable;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapImportFileNames
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(MapImportFileNames.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MapImportFileNames(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            Path path = new Path(dm.importDir, "mappings.txt");
            BufferedWriter mappingsWriter = null;
            try {
                VolumeManager fs = environment.getVolumeManager();
                fs.mkdirs(new Path(dm.importDir));
                FileStatus[] files = fs.listStatus(new Path(dm.exportDir));
                UniqueNameAllocator namer = environment.getContext().getUniqueNameAllocator();
                mappingsWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path), StandardCharsets.UTF_8));
                for (FileStatus fileStatus : files) {
                    String fileName = fileStatus.getPath().getName();
                    log.info("filename " + fileStatus.getPath());
                    String[] sa = fileName.split("\\.");
                    String extension = "";
                    if (sa.length <= 1) continue;
                    extension = sa[sa.length - 1];
                    if (!FileOperations.getValidExtensions().contains(extension)) continue;
                    String newName = "I" + namer.getNextName() + "." + extension;
                    mappingsWriter.append(fileName);
                    mappingsWriter.append(':');
                    mappingsWriter.append(newName);
                    mappingsWriter.newLine();
                }
                mappingsWriter.close();
                mappingsWriter = null;
            }
            catch (IOException ioe) {
                log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
                throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error writing mapping file " + path + " " + ioe.getMessage());
            }
            finally {
                if (mappingsWriter == null) continue;
                try {
                    mappingsWriter.close();
                }
                catch (IOException ioe) {
                    log.warn("Failed to close " + path, (Throwable)ioe);
                }
            }
        }
        return new PopulateMetadataTable(this.tableInfo);
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            env.getVolumeManager().deleteRecursively(new Path(dm.importDir));
        }
    }
}

