/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.create;

import java.util.Map;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.namespace.create.NamespaceInfo;
import org.apache.accumulo.manager.tableOps.namespace.create.SetupNamespacePermissions;

public class CreateNamespace
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo = new NamespaceInfo();

    public CreateNamespace(String user, String namespaceName, Map<String, String> props) {
        this.namespaceInfo.namespaceName = namespaceName;
        this.namespaceInfo.user = user;
        this.namespaceInfo.props = props;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Utils.getIdLock().lock();
        try {
            this.namespaceInfo.namespaceId = Utils.getNextId(this.namespaceInfo.namespaceName, manager.getContext(), NamespaceId::of);
            SetupNamespacePermissions setupNamespacePermissions = new SetupNamespacePermissions(this.namespaceInfo);
            return setupNamespacePermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Manager env) {
    }
}

