/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.auto.service.AutoService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionKind;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.compaction.RunningCompaction;
import org.apache.accumulo.core.util.compaction.RunningCompactionInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class ECAdmin
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(ECAdmin.class);

    public static void main(String[] args) {
        new ECAdmin().execute(args);
    }

    public String keyword() {
        return "ec-admin";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Executes administrative commands for external compactions";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit okay for CLI tool")
    public void execute(String[] args) {
        ServerUtilOpts opts = new ServerUtilOpts();
        JCommander cl = new JCommander((Object)opts);
        cl.setProgramName("accumulo ec-admin");
        CancelCommand cancelOps = new CancelCommand();
        cl.addCommand("cancel", (Object)cancelOps);
        ListCompactorsCommand listCompactorsOpts = new ListCompactorsCommand();
        cl.addCommand("listCompactors", (Object)listCompactorsOpts);
        RunningCommand runningOpts = new RunningCommand();
        cl.addCommand("running", (Object)runningOpts);
        cl.parse(args);
        if (opts.help || cl.getParsedCommand() == null) {
            cl.usage();
            return;
        }
        ServerContext context = opts.getServerContext();
        try {
            if (cl.getParsedCommand().equals("listCompactors")) {
                this.listCompactorsByQueue(context);
            } else if (cl.getParsedCommand().equals("cancel")) {
                this.cancelCompaction(context, cancelOps.ecid);
            } else if (cl.getParsedCommand().equals("running")) {
                List<RunningCompactionSummary> compactions = this.runningCompactions(context, runningOpts.details);
                if (runningOpts.jsonOutput) {
                    try {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        System.out.println(gson.toJson(compactions));
                    }
                    catch (Exception e) {
                        log.error("Error generating JSON output", (Throwable)e);
                    }
                } else {
                    compactions.forEach(c -> c.print(System.out));
                }
            } else {
                log.error("Unknown command {}", (Object)cl.getParsedCommand());
                cl.usage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
        finally {
            SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.CLOSED);
        }
    }

    protected void cancelCompaction(ServerContext context, String ecid) {
        CompactionCoordinatorService.Client coordinatorClient = null;
        ecid = ExternalCompactionId.from((String)ecid).canonical();
        try {
            coordinatorClient = this.getCoordinatorClient(context);
            coordinatorClient.cancel(TraceUtil.traceInfo(), context.rpcCreds(), ecid);
            System.out.println("Cancel sent to coordinator for " + ecid);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception calling cancel compaction for " + ecid, e);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)context);
        }
    }

    protected void listCompactorsByQueue(ServerContext context) {
        Map queueToCompactorsMap = ExternalCompactionUtil.getCompactorAddrs((ClientContext)context);
        if (queueToCompactorsMap.isEmpty()) {
            System.out.println("No Compactors found.");
        } else {
            queueToCompactorsMap.forEach((q, compactors) -> System.out.println(q + ": " + String.valueOf(compactors)));
        }
    }

    protected List<RunningCompactionSummary> runningCompactions(ServerContext context, boolean details) {
        CompactionCoordinatorService.Client coordinatorClient = null;
        try {
            coordinatorClient = this.getCoordinatorClient(context);
            TExternalCompactionList running = coordinatorClient.getRunningCompactions(TraceUtil.traceInfo(), context.rpcCreds());
            ArrayList<RunningCompactionSummary> results = new ArrayList<RunningCompactionSummary>();
            if (running == null || running.getCompactions() == null || running.getCompactions().isEmpty()) {
                System.out.println("No running compactions found.");
                ArrayList<RunningCompactionSummary> arrayList = results;
                return arrayList;
            }
            for (Map.Entry entry : running.getCompactions().entrySet()) {
                TExternalCompaction ec = (TExternalCompaction)entry.getValue();
                if (ec == null) continue;
                RunningCompactionSummary summary = new RunningCompactionSummary(new RunningCompaction(ec), details ? new RunningCompactionInfo(ec) : null);
                results.add(summary);
            }
            ArrayList<RunningCompactionSummary> arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get running compactions.", e);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)context);
        }
    }

    private CompactionCoordinatorService.Client getCoordinatorClient(ServerContext context) {
        CompactionCoordinatorService.Client coordinatorClient;
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
        if (coordinatorHost.isEmpty()) {
            throw new IllegalStateException("Unable to find coordinator. Check that it is running.");
        }
        HostAndPort address = (HostAndPort)coordinatorHost.orElseThrow();
        try {
            coordinatorClient = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)address, (ClientContext)context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get Compaction coordinator at " + String.valueOf(address), e);
        }
        System.out.println("Connected to coordinator at " + String.valueOf(address));
        return coordinatorClient;
    }

    @Parameters(commandDescription="cancel the external compaction with given ECID")
    static class CancelCommand {
        @Parameter(names={"-ecid"}, description="<ecid>", required=true)
        String ecid;

        CancelCommand() {
        }
    }

    @Parameters(commandDescription="list all compactors in zookeeper")
    static class ListCompactorsCommand {
        ListCompactorsCommand() {
        }
    }

    @Parameters(commandDescription="list the running compactions")
    static class RunningCommand {
        @Parameter(names={"-d", "--details"}, description="display details about the running compactions")
        boolean details = false;
        @Parameter(names={"-j", "--json"}, description="format the output as json")
        boolean jsonOutput = false;

        RunningCommand() {
        }
    }

    public static class RunningCompactionSummary {
        private final String ecid;
        private final String addr;
        private final TCompactionKind kind;
        private final String queueName;
        private final String ke;
        private final String tableId;
        private String status = "";
        private long lastUpdate = 0L;
        private long duration = 0L;
        private int numFiles = 0;
        private double progress = 0.0;

        public RunningCompactionSummary(RunningCompaction runningCompaction, RunningCompactionInfo runningCompactionInfo) {
            this.ecid = runningCompaction.getJob().getExternalCompactionId();
            this.addr = runningCompaction.getCompactorAddress();
            this.kind = runningCompaction.getJob().kind;
            this.queueName = runningCompaction.getQueueName();
            KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)runningCompaction.getJob().extent);
            this.ke = extent.obscured();
            this.tableId = extent.tableId().canonical();
            if (runningCompactionInfo != null) {
                this.status = runningCompactionInfo.status;
                this.lastUpdate = runningCompactionInfo.lastUpdate;
                this.duration = runningCompactionInfo.duration;
                this.numFiles = runningCompactionInfo.numFiles;
                this.progress = runningCompactionInfo.progress;
            }
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public void setNumFiles(int numFiles) {
            this.numFiles = numFiles;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setProgress(double progress) {
            this.progress = progress;
        }

        public String getEcid() {
            return this.ecid;
        }

        public String getAddr() {
            return this.addr;
        }

        public TCompactionKind getKind() {
            return this.kind;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public String getKe() {
            return this.ke;
        }

        public String getTableId() {
            return this.tableId;
        }

        public void print(PrintStream out) {
            out.format("%s %s %s %s TableId: %s\n", this.ecid, this.addr, this.kind, this.queueName, this.tableId);
            out.format("  %s Last Update: %dms Duration: %dms Files: %d Progress: %.2f%%\n", this.status, this.lastUpdate, this.duration, this.numFiles, this.progress);
        }
    }
}

