/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.lexicoder.AbstractEncoder;
import org.apache.accumulo.core.client.lexicoder.Encoder;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.TypedValueCombiner;
import org.apache.accumulo.core.iterators.ValueFormatException;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StatusCombiner
extends TypedValueCombiner<Replication.Status> {
    private static final Logger log = LoggerFactory.getLogger(StatusCombiner.class);

    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("StatusCombiner");
        io.setDescription("Combiner that joins multiple Status protobufs to track replication metadata");
        return io;
    }

    public boolean validateOptions(Map<String, String> options) {
        return super.validateOptions(options);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.setEncoder((Encoder)new StatusEncoder());
    }

    public Replication.Status typedReduce(Key key, Iterator<Replication.Status> iter) {
        Replication.Status.Builder combined = null;
        while (iter.hasNext()) {
            Replication.Status status = iter.next();
            if (combined == null) {
                if (iter.hasNext()) {
                    combined = Replication.Status.newBuilder();
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("Returned single value: {} {}", (Object)key.toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)status));
                    }
                    return status;
                }
            }
            this.combine(combined, status);
        }
        if (log.isTraceEnabled()) {
            log.trace("Combined: {} {}", (Object)key.toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)combined.build()));
        }
        return combined.build();
    }

    public void combine(Replication.Status.Builder combined, Replication.Status status) {
        if (log.isTraceEnabled()) {
            log.trace("Combining {} into {}", (Object)status.toString().replace("\n", ", "), (Object)this.builderToString(combined));
        }
        combined.setBegin(Math.max(combined.getBegin(), status.getBegin()));
        combined.setEnd(Math.max(combined.getEnd(), status.getEnd()));
        combined.setClosed(combined.getClosed() | status.getClosed());
        combined.setInfiniteEnd(combined.getInfiniteEnd() | status.getInfiniteEnd());
        if (status.hasCreatedTime()) {
            if (combined.hasCreatedTime()) {
                combined.setCreatedTime(Math.min(combined.getCreatedTime(), status.getCreatedTime()));
            } else {
                combined.setCreatedTime(status.getCreatedTime());
            }
        }
    }

    private String builderToString(Replication.Status.Builder builder) {
        return "begin: " + builder.getBegin() + ", end: " + builder.getEnd() + ", infiniteEnd: " + builder.getInfiniteEnd() + ", closed: " + builder.getClosed() + ", createdTime: " + builder.getCreatedTime();
    }

    @Deprecated
    public static class StatusEncoder
    extends AbstractEncoder<Replication.Status> {
        private static final Logger log = LoggerFactory.getLogger(StatusEncoder.class);

        public byte[] encode(Replication.Status v) {
            return v.toByteArray();
        }

        public Replication.Status decode(byte[] b) {
            Objects.requireNonNull(b, "cannot decode null byte array");
            try {
                return Replication.Status.parseFrom(b);
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Failed to parse Status protocol buffer", (Throwable)e);
                throw new ValueFormatException((Exception)((Object)e));
            }
        }

        protected Replication.Status decodeUnchecked(byte[] b, int offset, int len) throws ValueFormatException {
            try {
                byte[] boundedArr = new byte[len];
                System.arraycopy(b, offset, boundedArr, 0, len);
                return Replication.Status.parseFrom(boundedArr);
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Failed to parse Status protocol buffer", (Throwable)e);
                throw new ValueFormatException((Exception)((Object)e));
            }
        }
    }
}

