/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientServiceEnvironmentImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;

public class ClientIteratorEnvironment
implements IteratorEnvironment {
    public static final IteratorEnvironment DEFAULT = new Builder().build();
    private final Optional<IteratorUtil.IteratorScope> scope;
    private final boolean isFullMajorCompaction;
    private final Optional<Authorizations> auths;
    private final boolean isUserCompaction;
    private final Optional<TableId> tableId;
    protected Optional<SamplerConfiguration> samplerConfig;
    private final boolean samplingEnabled;
    private final Optional<ServiceEnvironment> env;

    protected ClientIteratorEnvironment(Builder builder) {
        this.scope = builder.scope;
        this.isFullMajorCompaction = builder.isFullMajorCompaction;
        this.auths = builder.auths;
        this.isUserCompaction = builder.isUserCompaction;
        this.tableId = builder.tableId;
        this.samplerConfig = builder.samplerConfig;
        this.env = builder.env;
        this.samplingEnabled = builder.samplingEnabled;
    }

    protected ClientIteratorEnvironment(ClientIteratorEnvironment copy) {
        this.scope = copy.scope;
        this.isFullMajorCompaction = copy.isFullMajorCompaction;
        this.auths = copy.auths;
        this.isUserCompaction = copy.isUserCompaction;
        this.tableId = copy.tableId;
        this.samplerConfig = copy.samplerConfig;
        this.env = copy.env;
        this.samplingEnabled = true;
    }

    @Override
    @Deprecated(since="2.0.0")
    public SortedKeyValueIterator<Key, Value> reserveMapFileReader(String mapFileName) throws IOException {
        throw new UnsupportedOperationException("Feature not supported");
    }

    @Override
    public IteratorUtil.IteratorScope getIteratorScope() {
        return this.scope.orElseThrow();
    }

    @Override
    public boolean isFullMajorCompaction() {
        if (this.getIteratorScope() != IteratorUtil.IteratorScope.majc) {
            throw new IllegalStateException("Iterator scope is not majc");
        }
        return this.isFullMajorCompaction;
    }

    @Override
    @Deprecated(since="2.0.0")
    public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
        throw new UnsupportedOperationException("Feature not supported");
    }

    @Override
    public Authorizations getAuthorizations() {
        if (this.getIteratorScope() != IteratorUtil.IteratorScope.scan) {
            throw new UnsupportedOperationException("Iterator scope is not scan");
        }
        return this.auths.orElseThrow();
    }

    @Override
    public IteratorEnvironment cloneWithSamplingEnabled() {
        if (this.samplerConfig.isEmpty()) {
            throw new SampleNotPresentException();
        }
        return new ClientIteratorEnvironment(this);
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.samplingEnabled;
    }

    @Override
    public SamplerConfiguration getSamplerConfiguration() {
        if (!this.isSamplingEnabled()) {
            return null;
        }
        return this.samplerConfig.orElseThrow();
    }

    @Override
    public boolean isUserCompaction() {
        if (this.getIteratorScope() == IteratorUtil.IteratorScope.scan) {
            throw new IllegalStateException("scan iterator scope is incompatible with a possible user compaction");
        }
        if (this.getIteratorScope() != IteratorUtil.IteratorScope.majc) {
            throw new IllegalStateException("Asked about user initiated compaction type when scope is " + String.valueOf((Object)this.getIteratorScope()));
        }
        return this.isUserCompaction;
    }

    @Override
    @Deprecated(since="2.1.0")
    public ServiceEnvironment getServiceEnv() {
        return this.env.orElseThrow();
    }

    @Override
    public PluginEnvironment getPluginEnv() {
        return this.env.orElseThrow();
    }

    @Override
    public TableId getTableId() {
        return this.tableId.orElse(null);
    }

    public static class Builder {
        private Optional<IteratorUtil.IteratorScope> scope = Optional.empty();
        private boolean isFullMajorCompaction = false;
        private Optional<Authorizations> auths = Optional.empty();
        private boolean isUserCompaction = false;
        protected Optional<TableId> tableId = Optional.empty();
        protected Optional<SamplerConfiguration> samplerConfig = Optional.empty();
        private boolean samplingEnabled = false;
        protected Optional<ServiceEnvironment> env = Optional.empty();

        public Builder withScope(IteratorUtil.IteratorScope scope) {
            Preconditions.checkState((boolean)this.scope.isEmpty(), (Object)"Scope has already been set");
            this.scope = Optional.of(scope);
            return this;
        }

        public Builder isFullMajorCompaction() {
            this.isFullMajorCompaction = true;
            return this;
        }

        public Builder withAuthorizations(Authorizations auths) {
            Preconditions.checkState((boolean)this.auths.isEmpty(), (Object)"Authorizations have already been set");
            this.auths = Optional.of(auths);
            return this;
        }

        public Builder isUserCompaction() {
            this.isUserCompaction = true;
            return this;
        }

        public Builder withTableId(TableId tableId) {
            Preconditions.checkState((boolean)this.tableId.isEmpty(), (Object)"TableId has already been set");
            this.tableId = Optional.ofNullable(tableId);
            return this;
        }

        public Builder withSamplingEnabled() {
            this.samplingEnabled = true;
            return this;
        }

        public Builder withSamplerConfiguration(SamplerConfiguration sc) {
            Preconditions.checkState((boolean)this.samplerConfig.isEmpty(), (Object)"SamplerConfiguration has already been set");
            this.samplerConfig = Optional.ofNullable(sc);
            return this;
        }

        public Builder withEnvironment(ClientServiceEnvironmentImpl env) {
            Preconditions.checkState((boolean)this.env.isEmpty(), (Object)"ClientServiceEnvironmentImpl has already been set");
            this.env = Optional.of(env);
            return this;
        }

        public Builder withClient(AccumuloClient client) {
            Preconditions.checkState((boolean)this.env.isEmpty(), (Object)"ClientServiceEnvironmentImpl has already been set");
            this.env = Optional.of(new ClientServiceEnvironmentImpl((ClientContext)client));
            return this;
        }

        public ClientIteratorEnvironment build() {
            return new ClientIteratorEnvironment(this);
        }
    }
}

