/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.manager.thrift.FateOperation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditedSecurityOperation
extends SecurityOperation {
    public static final String AUDITLOG = "org.apache.accumulo.audit";
    public static final Logger audit = LoggerFactory.getLogger((String)"org.apache.accumulo.audit");
    public static final String CAN_SCAN_AUDIT_TEMPLATE = "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;";
    private static final int MAX_ELEMENTS_TO_LOG = 10;
    public static final String CAN_SCAN_BATCH_AUDIT_TEMPLATE = "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;";
    public static final String CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE = "action: changeAuthorizations; targetUser: %s; authorizations: %s";
    public static final String CHANGE_PASSWORD_AUDIT_TEMPLATE = "action: changePassword; targetUser: %s;";
    public static final String CREATE_USER_AUDIT_TEMPLATE = "action: createUser; targetUser: %s; Authorizations: %s;";
    public static final String CAN_CREATE_TABLE_AUDIT_TEMPLATE = "action: createTable; targetTable: %s;";
    public static final String CAN_DELETE_TABLE_AUDIT_TEMPLATE = "action: deleteTable; targetTable: %s:%s";
    public static final String CAN_RENAME_TABLE_AUDIT_TEMPLATE = "action: renameTable; targetTable: %s; newTableName: %s;";
    public static final String CAN_SPLIT_TABLE_AUDIT_TEMPLATE = "action: splitTable; targetTable: %s; targetNamespace: %s;";
    public static final String CAN_PERFORM_SYSTEM_ACTION_AUDIT_TEMPLATE = "action: performSystemAction; principal: %s;";
    public static final String CAN_FLUSH_TABLE_AUDIT_TEMPLATE = "action: flushTable; targetTable: %s; targetNamespace: %s;";
    public static final String CAN_ALTER_TABLE_AUDIT_TEMPLATE = "action: alterTable; targetTable: %s; targetNamespace: %s;";
    public static final String CAN_CLONE_TABLE_AUDIT_TEMPLATE = "action: cloneTable; targetTable: %s; newTableName: %s";
    public static final String CAN_DELETE_RANGE_AUDIT_TEMPLATE = "action: deleteData; targetTable: %s; startRange: %s; endRange: %s;";
    public static final String CAN_BULK_IMPORT_AUDIT_TEMPLATE = "action: bulkImport; targetTable: %s; dataDir: %s; failDir: %s;";
    public static final String CAN_COMPACT_TABLE_AUDIT_TEMPLATE = "action: compactTable; targetTable: %s; targetNamespace: %s;";
    public static final String CAN_CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE = "action: changeAuthorizations; targetUser: %s;";
    public static final String CAN_CHANGE_PASSWORD_AUDIT_TEMPLATE = "action: changePassword; targetUser: %s;";
    public static final String CAN_CREATE_USER_AUDIT_TEMPLATE = "action: createUser; targetUser: %s;";
    public static final String CAN_DROP_USER_AUDIT_TEMPLATE = "action: dropUser; targetUser: %s;";
    public static final String CAN_GRANT_SYSTEM_AUDIT_TEMPLATE = "action: grantSystem; targetUser: %s; targetPermission: %s;";
    public static final String CAN_GRANT_TABLE_AUDIT_TEMPLATE = "action: grantTable; targetUser: %s; targetTable: %s; targetNamespace: %s;";
    public static final String CAN_REVOKE_SYSTEM_AUDIT_TEMPLATE = "action: revokeSystem; targetUser: %s;, targetPermission: %s;";
    public static final String CAN_REVOKE_TABLE_AUDIT_TEMPLATE = "action: revokeTable; targetUser: %s; targetTable %s; targetNamespace: %s;";
    public static final String CAN_IMPORT_AUDIT_TEMPLATE = "action: import; targetTable: %s; dataDir: %s;";
    public static final String CAN_EXPORT_AUDIT_TEMPLATE = "action: export; targetTable: %s; dataDir: %s;";
    public static final String DROP_USER_AUDIT_TEMPLATE = "action: dropUser; targetUser: %s;";
    public static final String GRANT_SYSTEM_PERMISSION_AUDIT_TEMPLATE = "action: grantSystemPermission; permission: %s; targetUser: %s;";
    public static final String GRANT_TABLE_PERMISSION_AUDIT_TEMPLATE = "action: grantTablePermission; permission: %s; targetTable: %s; targetUser: %s;";
    public static final String REVOKE_SYSTEM_PERMISSION_AUDIT_TEMPLATE = "action: revokeSystemPermission; permission: %s; targetUser: %s;";
    public static final String REVOKE_TABLE_PERMISSION_AUDIT_TEMPLATE = "action: revokeTablePermission; permission: %s; targetTable: %s; targetUser: %s;";
    public static final String HAS_SYSTEM_PERMISSION_AUDIT_TEMPLATE = "action: hasSystemPermission; permission: %s; targetUser: %s;";
    public static final String CAN_ONLINE_OFFLINE_TABLE_AUDIT_TEMPLATE = "action: %s; targetTable: %s:%s";
    public static final String CAN_MERGE_TABLE_AUDIT_TEMPLATE = "action: mergeTable; targetTable: %s; targetNamespace: %s;";
    public static final String AUTHENICATE_AUDIT_TEMPLATE = "action: authenticate;";
    public static final String DELEGATION_TOKEN_AUDIT_TEMPLATE = "requested delegation token";

    public AuditedSecurityOperation(ServerContext context, Authorizor author, Authenticator authent, PermissionHandler pm) {
        super(context, author, authent, pm);
    }

    private String getTableName(TableId tableId) {
        try {
            return this.context.getTableName(tableId);
        }
        catch (TableNotFoundException e) {
            return "Unknown Table with ID " + tableId;
        }
    }

    public static StringBuilder getAuthString(List<ByteBuffer> authorizations) {
        StringBuilder auths = new StringBuilder();
        for (ByteBuffer bb : authorizations) {
            auths.append(ByteBufferUtil.toString((ByteBuffer)bb)).append(",");
        }
        return auths;
    }

    private boolean shouldAudit(TCredentials credentials, TableId tableId) {
        return (audit.isInfoEnabled() || audit.isWarnEnabled()) && !tableId.equals((Object)MetadataTable.ID) && this.shouldAudit(credentials);
    }

    private boolean shouldAudit(TCredentials credentials) {
        return !this.context.getCredentials().getToken().getClass().getName().equals(credentials.getTokenClassName());
    }

    private void audit(TCredentials credentials, ThriftSecurityException ex, String template, Object ... args) {
        audit.warn("operation: failed; user: {}; {}; exception: {}", new Object[]{credentials.getPrincipal(), String.format(template, args), ex.toString()});
    }

    private void audit(TCredentials credentials, String template, Object ... args) {
        if (audit.isInfoEnabled() && this.shouldAudit(credentials)) {
            audit.info("operation: success; user: {}: {}", (Object)credentials.getPrincipal(), (Object)String.format(template, args));
        }
    }

    private void audit(TCredentials credentials, boolean permitted, String template, Object ... args) {
        if (audit.isInfoEnabled() && this.shouldAudit(credentials)) {
            String prefix = permitted ? "permitted" : "denied";
            audit.info("operation: {}; user: {}; client: {}; {}", new Object[]{prefix, credentials.getPrincipal(), TServerUtils.clientAddress.get(), String.format(template, args)});
        }
    }

    private static List<String> truncate(Collection<?> list) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        for (Object obj : list) {
            if (i++ > 10) {
                result.add(" and " + (list.size() - 10) + " more ");
                break;
            }
            result.add(obj.toString());
        }
        return result;
    }

    @Override
    public boolean canScan(TCredentials credentials, TableId tableId, NamespaceId namespaceId, TRange range, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        if (this.shouldAudit(credentials, tableId)) {
            Range convertedRange = new Range(range);
            List<String> convertedColumns = AuditedSecurityOperation.truncate(columns.stream().map(Column::new).collect(Collectors.toList()));
            String tableName = this.getTableName(tableId);
            try {
                boolean canScan = super.canScan(credentials, tableId, namespaceId);
                this.audit(credentials, canScan, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", tableName, AuditedSecurityOperation.getAuthString(authorizations), convertedRange, convertedColumns, ssiList, ssio);
                return canScan;
            }
            catch (ThriftSecurityException ex) {
                this.audit(credentials, ex, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", AuditedSecurityOperation.getAuthString(authorizations), tableId, convertedRange, convertedColumns, ssiList, ssio);
                throw ex;
            }
        }
        return super.canScan(credentials, tableId, namespaceId);
    }

    @Override
    public boolean canScan(TCredentials credentials, TableId tableId, NamespaceId namespaceId, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        if (this.shouldAudit(credentials, tableId)) {
            Map<KeyExtent, List> truncated = tbatch.entrySet().stream().collect(Collectors.toMap(entry -> KeyExtent.fromThrift((TKeyExtent)((TKeyExtent)entry.getKey())), entry -> AuditedSecurityOperation.truncate(((List)entry.getValue()).stream().map(Range::new).collect(Collectors.toList()))));
            List convertedColumns = tcolumns.stream().map(Column::new).collect(Collectors.toList());
            String tableName = this.getTableName(tableId);
            try {
                boolean canScan = super.canScan(credentials, tableId, namespaceId);
                this.audit(credentials, canScan, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", tableName, AuditedSecurityOperation.getAuthString(authorizations), truncated, convertedColumns, ssiList, ssio);
                return canScan;
            }
            catch (ThriftSecurityException ex) {
                this.audit(credentials, ex, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", AuditedSecurityOperation.getAuthString(authorizations), tableId, truncated, convertedColumns, ssiList, ssio);
                throw ex;
            }
        }
        return super.canScan(credentials, tableId, namespaceId);
    }

    @Override
    public void changeAuthorizations(TCredentials credentials, String user, Authorizations authorizations) throws ThriftSecurityException {
        try {
            super.changeAuthorizations(credentials, user, authorizations);
            this.audit(credentials, CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE, user, authorizations);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE, user, authorizations);
            throw ex;
        }
    }

    @Override
    public void changePassword(TCredentials credentials, Credentials newInfo) throws ThriftSecurityException {
        try {
            super.changePassword(credentials, newInfo);
            this.audit(credentials, "action: changePassword; targetUser: %s;", newInfo.getPrincipal());
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "action: changePassword; targetUser: %s;", newInfo.getPrincipal());
            throw ex;
        }
    }

    @Override
    public void createUser(TCredentials credentials, Credentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        try {
            super.createUser(credentials, newUser, authorizations);
            this.audit(credentials, CREATE_USER_AUDIT_TEMPLATE, newUser.getPrincipal(), authorizations);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CREATE_USER_AUDIT_TEMPLATE, newUser.getPrincipal(), authorizations);
            throw ex;
        }
    }

    @Override
    public boolean canCreateTable(TCredentials c, String tableName, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canCreateTable(c, tableName, namespaceId);
            this.audit(c, result, CAN_CREATE_TABLE_AUDIT_TEMPLATE, tableName);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_CREATE_TABLE_AUDIT_TEMPLATE, tableName);
            throw ex;
        }
    }

    @Override
    public boolean canDeleteTable(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        String tableName = this.getTableName(tableId);
        try {
            boolean result = super.canDeleteTable(c, tableId, namespaceId);
            this.audit(c, result, CAN_DELETE_TABLE_AUDIT_TEMPLATE, tableName, tableId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_DELETE_TABLE_AUDIT_TEMPLATE, tableName, tableId);
            throw ex;
        }
    }

    @Override
    public boolean canRenameTable(TCredentials c, TableId tableId, String oldTableName, String newTableName, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canRenameTable(c, tableId, oldTableName, newTableName, namespaceId);
            this.audit(c, result, CAN_RENAME_TABLE_AUDIT_TEMPLATE, oldTableName, newTableName);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_RENAME_TABLE_AUDIT_TEMPLATE, oldTableName, newTableName);
            throw ex;
        }
    }

    @Override
    public boolean canSplitTablet(TCredentials credentials, TableId table, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canSplitTablet(credentials, table, namespaceId);
            this.audit(credentials, result, CAN_SPLIT_TABLE_AUDIT_TEMPLATE, table, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "split tablet on table %s denied", table);
            throw ex;
        }
    }

    @Override
    public boolean canPerformSystemActions(TCredentials credentials) throws ThriftSecurityException {
        try {
            boolean result = super.canPerformSystemActions(credentials);
            this.audit(credentials, result, CAN_PERFORM_SYSTEM_ACTION_AUDIT_TEMPLATE, credentials.getPrincipal());
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "system action denied", new Object[0]);
            throw ex;
        }
    }

    @Override
    public boolean canFlush(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canFlush(c, tableId, namespaceId);
            this.audit(c, result, CAN_FLUSH_TABLE_AUDIT_TEMPLATE, tableId, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "flush on tableId %s denied", tableId);
            throw ex;
        }
    }

    @Override
    public boolean canAlterTable(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canAlterTable(c, tableId, namespaceId);
            this.audit(c, result, CAN_ALTER_TABLE_AUDIT_TEMPLATE, tableId, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "alter table on tableId %s denied", tableId);
            throw ex;
        }
    }

    @Override
    public boolean canCloneTable(TCredentials c, TableId tableId, String tableName, NamespaceId destinationNamespaceId, NamespaceId sourceNamespaceId) throws ThriftSecurityException {
        String oldTableName = this.getTableName(tableId);
        try {
            boolean result = super.canCloneTable(c, tableId, tableName, destinationNamespaceId, sourceNamespaceId);
            this.audit(c, result, CAN_CLONE_TABLE_AUDIT_TEMPLATE, oldTableName, tableName);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_CLONE_TABLE_AUDIT_TEMPLATE, oldTableName, tableName);
            throw ex;
        }
    }

    @Override
    public boolean canDeleteRange(TCredentials c, TableId tableId, String tableName, Text startRow, Text endRow, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canDeleteRange(c, tableId, tableName, startRow, endRow, namespaceId);
            this.audit(c, result, CAN_DELETE_RANGE_AUDIT_TEMPLATE, tableName, startRow.toString(), endRow.toString());
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_DELETE_RANGE_AUDIT_TEMPLATE, tableName, startRow.toString(), endRow.toString());
            throw ex;
        }
    }

    @Override
    public boolean canBulkImport(TCredentials c, TableId tableId, String tableName, String dir, String failDir, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canBulkImport(c, tableId, tableName, dir, failDir, namespaceId);
            this.audit(c, result, CAN_BULK_IMPORT_AUDIT_TEMPLATE, tableName, dir, failDir);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_BULK_IMPORT_AUDIT_TEMPLATE, tableName, dir, failDir);
            throw ex;
        }
    }

    @Override
    public boolean canCompact(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canCompact(c, tableId, namespaceId);
            this.audit(c, result, CAN_COMPACT_TABLE_AUDIT_TEMPLATE, tableId, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "compact on tableId %s denied", tableId);
            throw ex;
        }
    }

    @Override
    public boolean canChangeAuthorizations(TCredentials c, String user) throws ThriftSecurityException {
        try {
            boolean result = super.canChangeAuthorizations(c, user);
            this.audit(c, result, CAN_CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE, user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "change authorizations on user %s denied", user);
            throw ex;
        }
    }

    @Override
    public boolean canChangePassword(TCredentials c, String user) throws ThriftSecurityException {
        try {
            boolean result = super.canChangePassword(c, user);
            this.audit(c, result, "action: changePassword; targetUser: %s;", user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "change password on user %s denied", user);
            throw ex;
        }
    }

    @Override
    public boolean canCreateUser(TCredentials c, String user) throws ThriftSecurityException {
        try {
            boolean result = super.canCreateUser(c, user);
            this.audit(c, result, CAN_CREATE_USER_AUDIT_TEMPLATE, user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "create user on user %s denied", user);
            throw ex;
        }
    }

    @Override
    public boolean canDropUser(TCredentials c, String user) throws ThriftSecurityException {
        try {
            boolean result = super.canDropUser(c, user);
            this.audit(c, result, "action: dropUser; targetUser: %s;", user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "drop user on user %s denied", user);
            throw ex;
        }
    }

    @Override
    public boolean canGrantSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        try {
            boolean result = super.canGrantSystem(c, user, sysPerm);
            this.audit(c, result, CAN_GRANT_SYSTEM_AUDIT_TEMPLATE, user, sysPerm);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "grant system permission %s for user %s denied", sysPerm, user);
            throw ex;
        }
    }

    @Override
    public boolean canGrantTable(TCredentials c, String user, TableId table, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canGrantTable(c, user, table, namespaceId);
            this.audit(c, result, CAN_GRANT_TABLE_AUDIT_TEMPLATE, user, table, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "grant table on table %s for user %s denied", table, user);
            throw ex;
        }
    }

    @Override
    public boolean canRevokeSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        try {
            boolean result = super.canRevokeSystem(c, user, sysPerm);
            this.audit(c, result, CAN_REVOKE_SYSTEM_AUDIT_TEMPLATE, user, sysPerm);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "revoke system permission %s for user %s denied", sysPerm, user);
            throw ex;
        }
    }

    @Override
    public boolean canRevokeTable(TCredentials c, String user, TableId table, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canRevokeTable(c, user, table, namespaceId);
            this.audit(c, result, CAN_REVOKE_TABLE_AUDIT_TEMPLATE, user, table, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "revoke table on table %s for user %s denied", table, user);
            throw ex;
        }
    }

    @Override
    public boolean canImport(TCredentials credentials, String tableName, Set<String> importDirs, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canImport(credentials, tableName, importDirs, namespaceId);
            this.audit(credentials, result, CAN_IMPORT_AUDIT_TEMPLATE, tableName, importDirs);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CAN_IMPORT_AUDIT_TEMPLATE, tableName, importDirs);
            throw ex;
        }
    }

    @Override
    public boolean canExport(TCredentials credentials, TableId tableId, String tableName, String exportDir, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canExport(credentials, tableId, tableName, exportDir, namespaceId);
            this.audit(credentials, result, CAN_EXPORT_AUDIT_TEMPLATE, tableName, exportDir);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CAN_EXPORT_AUDIT_TEMPLATE, tableName, exportDir);
            throw ex;
        }
    }

    @Override
    public void dropUser(TCredentials credentials, String user) throws ThriftSecurityException {
        try {
            super.dropUser(credentials, user);
            this.audit(credentials, "action: dropUser; targetUser: %s;", user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "action: dropUser; targetUser: %s;", user);
            throw ex;
        }
    }

    @Override
    public void grantSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            super.grantSystemPermission(credentials, user, permission);
            this.audit(credentials, GRANT_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, GRANT_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
            throw ex;
        }
    }

    @Override
    public void grantTablePermission(TCredentials credentials, String user, TableId tableId, String tableName, TablePermission permission, NamespaceId namespaceId) throws ThriftSecurityException, TableNotFoundException {
        try {
            super.grantTablePermission(credentials, user, tableId, tableName, permission, namespaceId);
            this.audit(credentials, GRANT_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, GRANT_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
            throw ex;
        }
    }

    @Override
    public void revokeSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            super.revokeSystemPermission(credentials, user, permission);
            this.audit(credentials, REVOKE_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, REVOKE_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
            throw ex;
        }
    }

    @Override
    public void revokeTablePermission(TCredentials credentials, String user, TableId tableId, TablePermission permission, NamespaceId namespaceId) throws ThriftSecurityException {
        String tableName = this.getTableName(tableId);
        try {
            super.revokeTablePermission(credentials, user, tableId, permission, namespaceId);
            this.audit(credentials, REVOKE_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, REVOKE_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
            throw ex;
        }
    }

    @Override
    public boolean hasSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            boolean result = super.hasSystemPermission(credentials, user, permission);
            this.audit(credentials, result, HAS_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "checking permission %s on %s denied", permission, user);
            throw ex;
        }
    }

    @Override
    public boolean canOnlineOfflineTable(TCredentials credentials, TableId tableId, FateOperation op, NamespaceId namespaceId) throws ThriftSecurityException {
        String tableName = this.getTableName(tableId);
        String operation = null;
        if (op == FateOperation.TABLE_ONLINE) {
            operation = "onlineTable";
        }
        if (op == FateOperation.TABLE_OFFLINE) {
            operation = "offlineTable";
        }
        try {
            boolean result = super.canOnlineOfflineTable(credentials, tableId, op, namespaceId);
            this.audit(credentials, result, CAN_ONLINE_OFFLINE_TABLE_AUDIT_TEMPLATE, operation, tableName, tableId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CAN_ONLINE_OFFLINE_TABLE_AUDIT_TEMPLATE, operation, tableName, tableId);
            throw ex;
        }
    }

    @Override
    public boolean canMerge(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canMerge(c, tableId, namespaceId);
            this.audit(c, result, CAN_MERGE_TABLE_AUDIT_TEMPLATE, tableId, namespaceId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, "merge table on tableId %s denied", tableId);
            throw ex;
        }
    }

    @Override
    protected void authenticate(TCredentials credentials) throws ThriftSecurityException {
        try {
            super.authenticate(credentials);
            this.audit(credentials, true, AUTHENICATE_AUDIT_TEMPLATE, new Object[0]);
        }
        catch (ThriftSecurityException e) {
            this.audit(credentials, false, AUTHENICATE_AUDIT_TEMPLATE, new Object[0]);
            throw e;
        }
    }

    @Override
    public boolean canObtainDelegationToken(TCredentials credentials) throws ThriftSecurityException {
        try {
            boolean result = super.canObtainDelegationToken(credentials);
            this.audit(credentials, result, DELEGATION_TOKEN_AUDIT_TEMPLATE, new Object[0]);
            return result;
        }
        catch (ThriftSecurityException e) {
            this.audit(credentials, false, DELEGATION_TOKEN_AUDIT_TEMPLATE, new Object[0]);
            throw e;
        }
    }
}

