/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.constraints;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.constraints.SystemEnvironment;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataConstraints
implements Constraint {
    private static final Logger log = LoggerFactory.getLogger(MetadataConstraints.class);
    private ZooCache zooCache = null;
    private String zooRoot = null;
    private static final boolean[] validTableNameChars = new boolean[256];
    private static final Set<ColumnFQ> validColumnQuals;
    private static final Set<Text> validColumnFams;

    private static boolean isValidColumn(ColumnUpdate cu) {
        if (validColumnFams.contains(new Text(cu.getColumnFamily()))) {
            return true;
        }
        return validColumnQuals.contains(new ColumnFQ(cu));
    }

    private static ArrayList<Short> addViolation(ArrayList<Short> lst, int violation) {
        if (lst == null) {
            lst = new ArrayList();
        }
        lst.add((short)violation);
        return lst;
    }

    private static ArrayList<Short> addIfNotPresent(ArrayList<Short> lst, int intViolation) {
        if (lst == null) {
            return MetadataConstraints.addViolation(null, intViolation);
        }
        short violation = (short)intViolation;
        if (!lst.contains(violation)) {
            return MetadataConstraints.addViolation(lst, intViolation);
        }
        return lst;
    }

    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        ServerContext context = ((SystemEnvironment)env).getServerContext();
        ArrayList<Short> violations = null;
        List colUpdates = mutation.getUpdates();
        boolean containsSemiC = false;
        byte[] row = mutation.getRow();
        if (row.length > 0 && row[0] == 126) {
            return null;
        }
        if (row.length > 2 && row[0] == 33 && row[1] == 33 && row[2] == 126) {
            return null;
        }
        for (byte b : row) {
            if (b == 59) {
                containsSemiC = true;
            }
            if (b == 59 || b == 60) break;
            if (validTableNameChars[0xFF & b]) continue;
            violations = MetadataConstraints.addIfNotPresent(violations, 4);
        }
        if (containsSemiC) {
            if (row.length == 0) {
                violations = MetadataConstraints.addIfNotPresent(violations, 4);
            }
        } else if (row.length == 0 || row[row.length - 1] != 60) {
            violations = MetadataConstraints.addIfNotPresent(violations, 4);
        }
        if (row.length > 0 && row[0] == 33 && (row.length < 3 || row[1] != 48 || row[2] != 60 && row[2] != 59)) {
            violations = MetadataConstraints.addIfNotPresent(violations, 4);
        }
        if (new Text(row).compareTo((BinaryComparable)new Text(MetadataTable.ID.canonical())) < 0) {
            violations = MetadataConstraints.addViolation(violations, 5);
        }
        boolean checkedBulk = false;
        for (ColumnUpdate columnUpdate : colUpdates) {
            Text columnFamily = new Text(columnUpdate.getColumnFamily());
            if (columnUpdate.isDeleted()) {
                if (MetadataConstraints.isValidColumn(columnUpdate)) continue;
                violations = MetadataConstraints.addViolation(violations, 2);
                continue;
            }
            if (columnUpdate.getValue().length == 0 && !columnFamily.equals((Object)MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME)) {
                violations = MetadataConstraints.addViolation(violations, 6);
            }
            if (columnFamily.equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                try {
                    DataFileValue dfv = new DataFileValue(columnUpdate.getValue());
                    if (dfv.getSize() >= 0L && dfv.getNumEntries() >= 0L) continue;
                    violations = MetadataConstraints.addViolation(violations, 1);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException nfe) {
                    violations = MetadataConstraints.addViolation(violations, 1);
                }
                continue;
            }
            if (columnFamily.equals((Object)MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME)) continue;
            if (columnFamily.equals((Object)MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME)) {
                if (columnUpdate.isDeleted() || checkedBulk) continue;
                boolean isSplitMutation = false;
                boolean isLocationMutation = false;
                HashSet<Text> dataFiles = new HashSet<Text>();
                HashSet<Text> loadedFiles = new HashSet<Text>();
                String tidString = new String(columnUpdate.getValue(), StandardCharsets.UTF_8);
                int otherTidCount = 0;
                for (ColumnUpdate update : mutation.getUpdates()) {
                    if (new ColumnFQ(update).equals((Object)MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN)) {
                        isSplitMutation = true;
                        continue;
                    }
                    if (new Text(update.getColumnFamily()).equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                        isLocationMutation = true;
                        continue;
                    }
                    if (new Text(update.getColumnFamily()).equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        dataFiles.add(new Text(update.getColumnQualifier()));
                        continue;
                    }
                    if (!new Text(update.getColumnFamily()).equals((Object)MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME)) continue;
                    loadedFiles.add(new Text(update.getColumnQualifier()));
                    if (new String(update.getValue(), StandardCharsets.UTF_8).equals(tidString)) continue;
                    ++otherTidCount;
                }
                if (!(isSplitMutation || isLocationMutation || otherTidCount <= 0 && dataFiles.equals(loadedFiles))) {
                    violations = MetadataConstraints.addViolation(violations, 8);
                }
                checkedBulk = true;
                continue;
            }
            if (!MetadataConstraints.isValidColumn(columnUpdate)) {
                violations = MetadataConstraints.addViolation(violations, 2);
                continue;
            }
            if (new ColumnFQ(columnUpdate).equals((Object)MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN) && columnUpdate.getValue().length > 0 && (violations == null || !violations.contains((short)4))) {
                KeyExtent ke = KeyExtent.fromMetaRow((Text)new Text(mutation.getRow()));
                Text per = MetadataSchema.TabletsSection.TabletColumnFamily.decodePrevEndRow((Value)new Value(columnUpdate.getValue()));
                boolean prevEndRowLessThanEndRow = per == null || ke.endRow() == null || per.compareTo((BinaryComparable)ke.endRow()) < 0;
                if (prevEndRowLessThanEndRow) continue;
                violations = MetadataConstraints.addViolation(violations, 3);
                continue;
            }
            if (!new ColumnFQ(columnUpdate).equals((Object)MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN)) continue;
            if (this.zooCache == null) {
                this.zooCache = new ZooCache(context.getZooReader(), null);
                CleanerUtil.zooCacheClearer((Object)this, (ZooCache)this.zooCache);
            }
            if (this.zooRoot == null) {
                this.zooRoot = context.getZooKeeperRoot();
            }
            boolean lockHeld = false;
            String lockId = new String(columnUpdate.getValue(), StandardCharsets.UTF_8);
            try {
                lockHeld = ServiceLock.isLockHeld((ZooCache)this.zooCache, (ZooUtil.LockID)new ZooUtil.LockID(this.zooRoot, lockId));
            }
            catch (Exception e) {
                log.debug("Failed to verify lock was held {} {}", (Object)lockId, (Object)e.getMessage());
            }
            if (lockHeld) continue;
            violations = MetadataConstraints.addViolation(violations, 7);
        }
        if (violations != null) {
            log.debug("violating metadata mutation : {}", (Object)new String(mutation.getRow(), StandardCharsets.UTF_8));
            for (ColumnUpdate update : mutation.getUpdates()) {
                log.debug(" update: {}:{} value {}", new Object[]{new String(update.getColumnFamily(), StandardCharsets.UTF_8), new String(update.getColumnQualifier(), StandardCharsets.UTF_8), update.isDeleted() ? "[delete]" : new String(update.getValue(), StandardCharsets.UTF_8)});
            }
        }
        return violations;
    }

    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return "data file size must be a non-negative integer";
            }
            case 2: {
                return "Invalid column name given.";
            }
            case 3: {
                return "Prev end row is greater than or equal to end row.";
            }
            case 4: {
                return "Invalid metadata row format";
            }
            case 5: {
                return "Row can not be less than " + MetadataTable.ID;
            }
            case 6: {
                return "Empty values are not allowed for any " + MetadataTable.NAME + " column";
            }
            case 7: {
                return "Lock not held in zookeeper by writer";
            }
            case 8: {
                return "Bulk load mutation contains either inconsistent files or multiple fateTX ids";
            }
        }
        return null;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MetadataConstraints.validTableNameChars[i] = i >= 97 && i <= 122 || i >= 48 && i <= 57 || i == 33 || i == 43;
        }
        validColumnQuals = Set.of(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN, MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN);
        validColumnFams = Set.of(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, MetadataSchema.TabletsSection.LogColumnFamily.NAME, MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME, MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, MetadataSchema.TabletsSection.ChoppedColumnFamily.NAME, MetadataSchema.TabletsSection.ClonedColumnFamily.NAME, MetadataSchema.TabletsSection.ExternalCompactionColumnFamily.NAME);
    }
}

