/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformToken {
    public static final String TRANSFORM_TOKEN = "/transform_token";
    private static final Logger log = LoggerFactory.getLogger(TransformToken.class);
    private final TokenUUID tokenUUID = new TokenUUID();
    private final String path;
    private final ZooReaderWriter zrw;
    private boolean haveToken = false;

    private TransformToken(@NonNull String basePath, ZooReaderWriter zrw) {
        this.path = basePath + TRANSFORM_TOKEN;
        this.zrw = zrw;
        boolean t = this.getTokenOwnership();
        log.trace("created token - token held: {}", (Object)t);
    }

    public static TransformToken createToken(@NonNull String path, ZooReaderWriter zrw) {
        return new TransformToken(path, zrw);
    }

    public boolean getTokenOwnership() {
        if (this.haveToken) {
            return true;
        }
        try {
            if (this.zrw.exists(this.path)) {
                return false;
            }
            this.zrw.putEphemeralData(this.path, this.tokenUUID.asBytes());
            log.trace("wrote property transform token: {} - {}", (Object)this.path, (Object)this.tokenUUID);
            this.haveToken = true;
            return true;
        }
        catch (KeeperException ex) {
            log.debug("Failed to write transform token for " + this.path + " another process may have created one", (Throwable)ex);
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted getting transform token", ex);
        }
    }

    public boolean haveTokenOwnership() {
        return this.haveToken;
    }

    public boolean validateToken() {
        try {
            byte[] readId = this.zrw.getData(this.path);
            log.trace("validate token: read: {} - expected: {}", (Object)readId, (Object)this.tokenUUID);
            return Arrays.equals(readId, this.tokenUUID.asBytes());
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed to validate token", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while validating token", ex);
        }
    }

    public void releaseToken() {
        try {
            Stat stat;
            byte[] readId;
            if (log.isTraceEnabled()) {
                log.trace("releaseToken called - {} - exists in ZooKeeper: {}", (Object)this.path, (Object)this.zrw.exists(this.path));
            }
            if (!Arrays.equals(readId = this.zrw.getData(this.path, stat = new Stat()), this.tokenUUID.asBytes())) {
                throw new IllegalStateException("tried to release a token that was not held by current thread");
            }
            if (log.isTraceEnabled()) {
                log.trace("releaseToken read id: {} - exists: {}", (Object)readId, (Object)this.zrw.exists(this.path));
            }
            this.zrw.deleteStrict(this.path, stat.getVersion());
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed to release transform lock for " + this.path, ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted getting transform token", ex);
        }
        this.haveToken = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformToken that = (TransformToken)o;
        return this.path.equals(that.path) && Arrays.equals(this.tokenUUID.asBytes(), that.tokenUUID.asBytes());
    }

    public int hashCode() {
        return Objects.hash(this.path, Arrays.hashCode(this.tokenUUID.asBytes()));
    }

    public String toString() {
        return "TransformLock{ path='" + this.path + "', locked='" + this.haveToken + "' id=" + this.tokenUUID + "'}'";
    }

    private static class TokenUUID {
        private final String id = UUID.randomUUID().toString();
        private final byte[] idBytes = this.id.getBytes(StandardCharsets.UTF_8);

        private TokenUUID() {
        }

        public byte[] asBytes() {
            return this.idBytes;
        }

        public String toString() {
            return "TransformToken{id='" + this.id + "}";
        }
    }
}

