/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropCache;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.impl.ZooPropLoader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropCacheCaffeineImpl
implements PropCache {
    public static final TimeUnit BASE_TIME_UNITS = TimeUnit.MINUTES;
    public static final int EXPIRE_MIN = 60;
    private static final Logger log = LoggerFactory.getLogger(PropCacheCaffeineImpl.class);
    private static final Executor executor = ThreadPools.getServerThreadPools().getPoolBuilder("caffeine.prop.cache.tasks").numCoreThreads(1).numMaxThreads(20).withTimeOut(60L, TimeUnit.SECONDS).build();
    private final LoadingCache<PropStoreKey<?>, VersionedProperties> cache;

    private PropCacheCaffeineImpl(CacheLoader<PropStoreKey<?>, VersionedProperties> cacheLoader, Ticker ticker, boolean runTasksInline) {
        Caffeine builder = Caffeine.newBuilder().expireAfterAccess(60L, BASE_TIME_UNITS).evictionListener(this::evictionNotifier);
        if (runTasksInline) {
            builder.executor(Runnable::run);
        } else {
            builder.executor(executor);
        }
        if (ticker != null) {
            builder.ticker(ticker);
        }
        this.cache = builder.build(cacheLoader);
    }

    void evictionNotifier(PropStoreKey<?> propStoreKey, VersionedProperties value, RemovalCause cause) {
        log.trace("Evicted: ID: {} was evicted from cache. Reason: {}", propStoreKey, (Object)cause);
    }

    @Override
    public @Nullable VersionedProperties get(PropStoreKey<?> propStoreKey) {
        log.trace("Called get() for {}", propStoreKey);
        try {
            return (VersionedProperties)this.cache.get(propStoreKey);
        }
        catch (Exception ex) {
            log.info("Cache failed to retrieve properties for: " + propStoreKey, (Throwable)ex);
            return null;
        }
    }

    @Override
    public void remove(PropStoreKey<?> propStoreKey) {
        log.trace("clear {} from cache", propStoreKey);
        this.cache.invalidate(propStoreKey);
    }

    @Override
    public void removeAll() {
        this.cache.invalidateAll();
    }

    public @Nullable VersionedProperties getIfCached(PropStoreKey<?> propStoreKey) {
        return (VersionedProperties)this.cache.getIfPresent(propStoreKey);
    }

    public static class Builder {
        private final ZooPropLoader zooPropLoader;
        private Ticker ticker = null;
        private boolean runTasksInline = false;

        public Builder(ZooPropLoader zooPropLoader) {
            Objects.requireNonNull(zooPropLoader, "A PropStoreChangeMonitor must be provided");
            this.zooPropLoader = zooPropLoader;
        }

        public PropCacheCaffeineImpl build() {
            return new PropCacheCaffeineImpl(this.zooPropLoader, this.ticker, this.runTasksInline);
        }

        public Builder forTests(Ticker ticker) {
            this.ticker = ticker;
            this.runTasksInline = true;
            return this;
        }
    }
}

