/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.compaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionReason;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionType;
import org.apache.accumulo.server.compaction.FileCompactor;

public class CompactionInfo {
    private final FileCompactor compactor;
    private final String localityGroup;
    private final long entriesRead;
    private final long entriesWritten;
    private final TCompactionReason reason;

    CompactionInfo(FileCompactor compactor) {
        this.localityGroup = compactor.getCurrentLocalityGroup();
        this.entriesRead = compactor.getEntriesRead();
        this.entriesWritten = compactor.getEntriesWritten();
        this.reason = compactor.getReason();
        this.compactor = compactor;
    }

    public long getID() {
        return this.compactor.getCompactorID();
    }

    public KeyExtent getExtent() {
        return this.compactor.getExtent();
    }

    public long getEntriesRead() {
        return this.entriesRead;
    }

    public long getEntriesWritten() {
        return this.entriesWritten;
    }

    public Thread getThread() {
        return this.compactor.thread;
    }

    public String getOutputFile() {
        return this.compactor.getOutputFile();
    }

    public ActiveCompaction toThrift() {
        TCompactionType type = this.compactor.hasIMM() ? (!this.compactor.getFilesToCompact().isEmpty() ? TCompactionType.MERGE : TCompactionType.MINOR) : (!this.compactor.willPropagateDeletes() ? TCompactionType.FULL : TCompactionType.MAJOR);
        ArrayList<IterInfo> iiList = new ArrayList<IterInfo>();
        HashMap<String, Map> iterOptions = new HashMap<String, Map>();
        for (IteratorSetting iterSetting : this.compactor.getIterators()) {
            iiList.add(new IterInfo(iterSetting.getPriority(), iterSetting.getIteratorClass(), iterSetting.getName()));
            iterOptions.put(iterSetting.getName(), iterSetting.getOptions());
        }
        List files = this.compactor.getFilesToCompact().stream().map(TabletFile::getPathStr).collect(Collectors.toList());
        return new ActiveCompaction(this.compactor.extent.toThrift(), this.compactor.getAge().toMillis(), files, this.compactor.getOutputFile(), type, this.reason, this.localityGroup, this.entriesRead, this.entriesWritten, iiList, iterOptions);
    }
}

