/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.RootTabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.compaction.SimpleCompactionDispatcher;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.manager.upgrade.Upgrader;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.util.ConfigPropertyUpgrader;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.gc.AllVolumesDirectory;
import org.apache.accumulo.server.metadata.RootGcCandidates;
import org.apache.accumulo.server.metadata.TabletMutatorBase;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.PropUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upgrader9to10
implements Upgrader {
    private static final Logger log = LoggerFactory.getLogger(Upgrader9to10.class);
    public static final String ZROOT_TABLET_LOCATION = "/root_tablet/location";
    public static final String ZROOT_TABLET_FUTURE_LOCATION = "/root_tablet/future_location";
    public static final String ZROOT_TABLET_LAST_LOCATION = "/root_tablet/lastlocation";
    public static final String ZROOT_TABLET_WALOGS = "/root_tablet/walogs";
    public static final String ZROOT_TABLET_CURRENT_LOGS = "/root_tablet/current_logs";
    public static final String ZROOT_TABLET_PATH = "/root_tablet/dir";
    public static final Value UPGRADED = MetadataSchema.DeletesSection.SkewedKeyValue.NAME;
    public static final String OLD_DELETE_PREFIX = "~del";
    public static final long CANDIDATE_BATCH_SIZE = 4000000L;

    @Override
    public void upgradeZookeeper(ServerContext context) {
        this.validateACLs(context);
        this.upgradePropertyStorage(context);
        this.setMetaTableProps(context);
        this.upgradeRootTabletMetadata(context);
        this.createExternalCompactionNodes(context);
        Upgrader9to10.dropSortedMapWALFiles(context);
        this.createScanServerNodes(context);
    }

    private static String extractAuthName(ACL acl) {
        Objects.requireNonNull(acl, "provided ACL cannot be null");
        try {
            return acl.getId().getId().trim().split(":")[0];
        }
        catch (Exception ex) {
            log.debug("Invalid ACL passed, cannot parse id from '{}'", (Object)acl);
            return "";
        }
    }

    private static boolean hasAllPermissions(Set<String> users, List<ACL> acls) {
        return acls.stream().anyMatch(a -> users.contains(Upgrader9to10.extractAuthName(a)) && a.getPerms() == 31);
    }

    private void validateACLs(ServerContext context) {
        AtomicBoolean aclErrorOccurred = new AtomicBoolean(false);
        ZooReaderWriter zrw = context.getZooReaderWriter();
        ZooKeeper zk = zrw.getZooKeeper();
        String rootPath = context.getZooKeeperRoot();
        Set<String> users = Set.of("accumulo", "anyone");
        try {
            ZKUtil.visitSubTreeDFS((ZooKeeper)zk, (String)rootPath, (boolean)false, (rc, path, ctx, name) -> {
                try {
                    List acls = zk.getACL(path, new Stat());
                    if (!Upgrader9to10.hasAllPermissions(users, acls)) {
                        log.error("ZNode at {} does not have an ACL that allows accumulo to write to it. ZNode ACL will need to be modified. Current ACLs: {}", (Object)path, (Object)acls);
                        aclErrorOccurred.set(true);
                    }
                }
                catch (InterruptedException | KeeperException e) {
                    log.error("Error getting ACL for path: {}", (Object)path, (Object)e);
                    aclErrorOccurred.set(true);
                }
            });
            if (aclErrorOccurred.get()) {
                throw new RuntimeException("Upgrade precondition failed! ACLs will need to be modified for some ZooKeeper nodes. Check the log for specific failed paths, check ZooKeeper troubleshooting in user documentation for instructions on how to fix.");
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Upgrade Failed! Error validating nodes under " + rootPath, e);
        }
    }

    @Override
    public void upgradeRoot(ServerContext context) {
        Upgrader9to10.upgradeRelativePaths(context, Ample.DataLevel.METADATA);
        this.upgradeDirColumns(context, Ample.DataLevel.METADATA);
        this.upgradeFileDeletes(context, Ample.DataLevel.METADATA);
    }

    @Override
    public void upgradeMetadata(ServerContext context) {
        Upgrader9to10.upgradeRelativePaths(context, Ample.DataLevel.USER);
        this.upgradeDirColumns(context, Ample.DataLevel.USER);
        this.upgradeFileDeletes(context, Ample.DataLevel.USER);
    }

    private void upgradePropertyStorage(ServerContext context) {
        log.info("Starting property conversion");
        ConfigPropertyUpgrader configUpgrader = new ConfigPropertyUpgrader();
        configUpgrader.doUpgrade(context.getInstanceID(), context.getZooReaderWriter());
        log.info("Completed property conversion");
    }

    private void setMetaTableProps(ServerContext context) {
        try {
            BiConsumer<TableId, String> setDispatcherProps = (tableId, dispatcherService) -> {
                Map<CallSite, String> dispatcherPropsMap = Map.of(Property.TABLE_COMPACTION_DISPATCHER.getKey(), SimpleCompactionDispatcher.class.getName(), Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", dispatcherService);
                PropUtil.setProperties((ServerContext)context, (PropStoreKey)TablePropKey.of((ServerContext)context, (TableId)tableId), dispatcherPropsMap);
            };
            setDispatcherProps.accept(RootTable.ID, "root");
            setDispatcherProps.accept(MetadataTable.ID, "meta");
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException("Unable to set system table properties", ex);
        }
    }

    private void createScanServerNodes(ServerContext context) {
        byte[] EMPTY_BYTE_ARRAY = new byte[]{};
        try {
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/sservers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Unable to create scan server paths", e);
        }
    }

    private void createExternalCompactionNodes(ServerContext context) {
        byte[] EMPTY_BYTE_ARRAY = new byte[]{};
        try {
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/coordinators", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.SKIP);
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/coordinators/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.SKIP);
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/compactors", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Unable to create external compaction paths", e);
        }
    }

    private void upgradeRootTabletMetadata(ServerContext context) {
        String rootMetaSer = this.getFromZK(context, "/root_tablet");
        if (rootMetaSer == null || rootMetaSer.isEmpty()) {
            String dir = this.getFromZK(context, ZROOT_TABLET_PATH);
            List<LogEntry> logs = Upgrader9to10.getRootLogEntries(context);
            TServerInstance last = this.getLocation(context, ZROOT_TABLET_LAST_LOCATION);
            TServerInstance future = this.getLocation(context, ZROOT_TABLET_FUTURE_LOCATION);
            TServerInstance current = this.getLocation(context, ZROOT_TABLET_LOCATION);
            UpgradeMutator tabletMutator = new UpgradeMutator(context);
            tabletMutator.putPrevEndRow(RootTable.EXTENT.prevEndRow());
            tabletMutator.putDirName(Upgrader9to10.upgradeDirColumn(dir));
            if (last != null) {
                tabletMutator.putLocation(TabletMetadata.Location.last((TServerInstance)last));
            }
            if (future != null) {
                tabletMutator.putLocation(TabletMetadata.Location.future((TServerInstance)future));
            }
            if (current != null) {
                tabletMutator.putLocation(TabletMetadata.Location.current((TServerInstance)current));
            }
            logs.forEach(arg_0 -> ((UpgradeMutator)tabletMutator).putWal(arg_0));
            Map<String, DataFileValue> files = Upgrader9to10.cleanupRootTabletFiles(context.getVolumeManager(), dir);
            files.forEach((path, dfv) -> tabletMutator.putFile(new TabletFile(new Path(path)), (DataFileValue)dfv));
            tabletMutator.putTime(this.computeRootTabletTime(context, files.keySet()));
            tabletMutator.mutate();
        }
        try {
            context.getZooReaderWriter().putPersistentData(context.getZooKeeperRoot() + "/root_tablet/gc_candidates", new RootGcCandidates().toJson().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
        this.delete(context, ZROOT_TABLET_CURRENT_LOGS);
        this.delete(context, ZROOT_TABLET_FUTURE_LOCATION);
        this.delete(context, ZROOT_TABLET_LAST_LOCATION);
        this.delete(context, ZROOT_TABLET_LOCATION);
        this.delete(context, ZROOT_TABLET_WALOGS);
        this.delete(context, ZROOT_TABLET_PATH);
    }

    protected TServerInstance getLocation(ServerContext context, String relpath) {
        String str = this.getFromZK(context, relpath);
        if (str == null) {
            return null;
        }
        String[] parts = str.split("[|]", 2);
        HostAndPort address = HostAndPort.fromString((String)parts[0]);
        if (parts.length > 1 && parts[1] != null && !parts[1].isEmpty()) {
            return new TServerInstance(address, parts[1]);
        }
        return null;
    }

    static List<LogEntry> getRootLogEntries(ServerContext context) {
        try {
            ArrayList<LogEntry> result = new ArrayList<LogEntry>();
            ZooReaderWriter zoo = context.getZooReaderWriter();
            String root = context.getZooKeeperRoot() + ZROOT_TABLET_WALOGS;
            block4: while (true) {
                result.clear();
                for (String child : zoo.getChildren(root)) {
                    try {
                        LogEntry e = LogEntry.fromBytes((byte[])zoo.getData(root + "/" + child));
                        e = new LogEntry(RootTable.EXTENT, 0L, e.filename);
                        result.add(e);
                    }
                    catch (KeeperException.NoNodeException ex) {
                        continue block4;
                    }
                }
                break;
            }
            return result;
        }
        catch (IOException | InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFromZK(ServerContext context, String relpath) {
        try {
            byte[] data = context.getZooReaderWriter().getData(context.getZooKeeperRoot() + relpath);
            if (data == null) {
                return null;
            }
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    private void delete(ServerContext context, String relpath) {
        try {
            context.getZooReaderWriter().recursiveDelete(context.getZooKeeperRoot() + relpath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    MetadataTime computeRootTabletTime(ServerContext context, Collection<String> goodPaths) {
        try {
            long rtime = Long.MIN_VALUE;
            for (String good : goodPaths) {
                Path path = new Path(good);
                FileSystem ns = context.getVolumeManager().getFileSystemByPath(path);
                TableConfiguration tableConf = context.getTableConfiguration(RootTable.ID);
                long maxTime = -1L;
                try (FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(path.toString(), ns, ns.getConf(), NoCryptoServiceFactory.NONE).withTableConfiguration((AccumuloConfiguration)tableConf).seekToBeginning().build();){
                    while (reader.hasTop()) {
                        maxTime = Math.max(maxTime, ((Key)reader.getTopKey()).getTimestamp());
                        reader.next();
                    }
                }
                if (maxTime <= rtime) continue;
                rtime = maxTime;
            }
            if (rtime < 0L) {
                throw new IllegalStateException("Unexpected root tablet logical time " + rtime);
            }
            return new MetadataTime(rtime, TimeType.LOGICAL);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Map<String, DataFileValue> cleanupRootTabletFiles(VolumeManager fs, String dir) {
        try {
            FileStatus[] files = fs.listStatus(new Path(dir));
            HashMap<String, DataFileValue> goodFiles = new HashMap<String, DataFileValue>(files.length);
            for (FileStatus file : files) {
                Object path = file.getPath().toString();
                if (file.getPath().toUri().getScheme() == null) {
                    throw new IllegalArgumentException("Require fully qualified paths " + file.getPath());
                }
                String filename = file.getPath().getName();
                if (filename.startsWith("delete+")) {
                    Path dst;
                    String expectedCompactedFile = ((String)path).substring(0, ((String)path).lastIndexOf("/delete+")) + "/" + filename.split("\\+")[1];
                    if (fs.exists(new Path(expectedCompactedFile))) {
                        if (fs.deleteRecursively(file.getPath())) continue;
                        log.warn("Delete of file: {} return false", (Object)file.getPath());
                        continue;
                    }
                    filename = filename.split("\\+", 3)[2];
                    path = ((String)path).substring(0, ((String)path).lastIndexOf("/delete+")) + "/" + filename;
                    Path src = file.getPath();
                    if (!fs.rename(src, dst = new Path((String)path))) {
                        throw new IOException("Rename " + src + " to " + dst + " returned false ");
                    }
                }
                if (filename.endsWith("_tmp")) {
                    log.warn("cleaning up old tmp file: {}", path);
                    if (fs.deleteRecursively(file.getPath())) continue;
                    log.warn("Delete of tmp file: {} return false", (Object)file.getPath());
                    continue;
                }
                if (!filename.startsWith("map_") && !FileOperations.getValidExtensions().contains(filename.split("\\.")[1])) {
                    log.error("unknown file in tablet: {}", path);
                    continue;
                }
                goodFiles.put((String)path, new DataFileValue(file.getLen(), 0L));
            }
            return goodFiles;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void upgradeFileDeletes(ServerContext context, Ample.DataLevel level) {
        String tableName = level.metaTable();
        Ample ample = context.getAmple();
        try (BatchWriter writer = context.createBatchWriter(tableName);){
            log.info("looking for candidates in table {}", (Object)tableName);
            Iterator<String> oldCandidates = this.getOldCandidates(context, tableName);
            String upgradeProp = context.getConfiguration().get(Property.INSTANCE_VOLUMES_UPGRADE_RELATIVE);
            while (oldCandidates.hasNext()) {
                List<String> deletes = this.readCandidatesInBatch(oldCandidates);
                log.info("found {} deletes to upgrade", (Object)deletes.size());
                for (String olddelete : deletes) {
                    log.trace("upgrading delete entry for {}", (Object)olddelete);
                    Path absolutePath = Upgrader9to10.resolveRelativeDelete(olddelete, upgradeProp);
                    ReferenceFile updatedDel = Upgrader9to10.switchToAllVolumes(absolutePath);
                    writer.addMutation(ample.createDeleteMutation(updatedDel));
                }
                writer.flush();
                log.info("upgrade processing completed so delete old entries");
                for (String olddelete : deletes) {
                    log.trace("deleting old entry for {}", (Object)olddelete);
                    writer.addMutation(this.deleteOldDeleteMutation(olddelete));
                }
                writer.flush();
            }
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static ReferenceFile switchToAllVolumes(Path olddelete) {
        Path pathNoVolume = Objects.requireNonNull(VolumeManager.FileType.TABLE.removeVolume(olddelete), "Invalid delete marker. No volume in path: " + olddelete);
        if (pathNoVolume.depth() == 3) {
            String tabletDir = pathNoVolume.getName();
            TableId tableId = TableId.of((String)pathNoVolume.getParent().getName());
            if (pathNoVolume.getName().startsWith("b-")) {
                return ReferenceFile.forFile((TableId)tableId, (String)olddelete.toString());
            }
            return new AllVolumesDirectory(tableId, tabletDir);
        }
        if (pathNoVolume.depth() == 4) {
            Path tabletDirPath = pathNoVolume.getParent();
            TableId tableId = TableId.of((String)tabletDirPath.getParent().getName());
            return ReferenceFile.forFile((TableId)tableId, (String)olddelete.toString());
        }
        throw new IllegalStateException("Invalid delete marker: " + olddelete);
    }

    private Iterator<String> getOldCandidates(ServerContext context, String tableName) throws TableNotFoundException {
        Range range = MetadataSchema.DeletesSection.getRange();
        Scanner scanner = context.createScanner(tableName, Authorizations.EMPTY);
        scanner.setRange(range);
        return scanner.stream().filter(entry -> !((Value)entry.getValue()).equals((Object)UPGRADED)).map(entry -> ((Key)entry.getKey()).getRow().toString().substring(OLD_DELETE_PREFIX.length())).iterator();
    }

    private List<String> readCandidatesInBatch(Iterator<String> candidates) {
        long candidateLength = 0L;
        ArrayList<String> result = new ArrayList<String>();
        while (candidates.hasNext()) {
            String candidate = candidates.next();
            result.add(candidate);
            if ((candidateLength += (long)candidate.length()) <= 4000000L) continue;
            log.trace("List of delete candidates has exceeded the batch size threshold. Attempting to delete what has been gathered so far.");
            break;
        }
        return result;
    }

    private Mutation deleteOldDeleteMutation(String delete) {
        Mutation m = new Mutation((CharSequence)(OLD_DELETE_PREFIX + delete));
        m.putDelete(MetadataTableUtil.EMPTY_TEXT, MetadataTableUtil.EMPTY_TEXT);
        return m;
    }

    public void upgradeDirColumns(ServerContext context, Ample.DataLevel level) {
        String tableName = level.metaTable();
        try (Scanner scanner = context.createScanner(tableName, Authorizations.EMPTY);
             BatchWriter writer = context.createBatchWriter(tableName);){
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
            for (Map.Entry entry : scanner) {
                Mutation m = new Mutation(((Key)entry.getKey()).getRow());
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value((CharSequence)Upgrader9to10.upgradeDirColumn(((Value)entry.getValue()).toString())));
                writer.addMutation(m);
            }
        }
        catch (AccumuloException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String upgradeDirColumn(String dir) {
        return new Path(dir).getName();
    }

    public static void upgradeRelativePaths(ServerContext context, Ample.DataLevel level) {
        String upgradeProp;
        String tableName = level.metaTable();
        VolumeManager fs = context.getVolumeManager();
        if (!Upgrader9to10.checkForRelativePaths((AccumuloClient)context, fs, tableName, upgradeProp = context.getConfiguration().get(Property.INSTANCE_VOLUMES_UPGRADE_RELATIVE))) {
            log.info("No relative paths found in {} during upgrade.", (Object)tableName);
            return;
        }
        log.info("Relative Tablet File paths exist in {}, replacing with absolute using {}", (Object)tableName, (Object)upgradeProp);
        Upgrader9to10.replaceRelativePaths((AccumuloClient)context, fs, tableName, upgradeProp);
    }

    public static void replaceRelativePaths(AccumuloClient c, VolumeManager fs, String tableName, String upgradeProperty) {
        try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);
             BatchWriter writer = c.createBatchWriter(tableName);){
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                Key key = (Key)entry.getKey();
                String metaEntry = key.getColumnQualifier().toString();
                if (metaEntry.contains(":")) continue;
                if (upgradeProperty == null || upgradeProperty.isBlank()) {
                    throw new IllegalArgumentException("Missing required property " + Property.INSTANCE_VOLUMES_UPGRADE_RELATIVE.getKey());
                }
                Path relPath = Upgrader9to10.resolveRelativePath(metaEntry, key);
                Path absPath = new Path(upgradeProperty, relPath);
                if (fs.exists(absPath)) {
                    log.debug("Changing Tablet File path from {} to {}", (Object)metaEntry, (Object)absPath);
                    Mutation m = new Mutation(key.getRow());
                    m.at().family(key.getColumnFamily()).qualifier((CharSequence)absPath.toString()).visibility(key.getColumnVisibility()).put((Value)entry.getValue());
                    m.at().family(key.getColumnFamily()).qualifier(key.getColumnQualifierData().toArray()).visibility(key.getColumnVisibility()).delete();
                    writer.addMutation(m);
                    continue;
                }
                throw new IllegalArgumentException("Relative Tablet file " + relPath + " not found at " + absPath);
            }
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static boolean checkForRelativePaths(AccumuloClient client, VolumeManager fs, String tableName, String upgradeProperty) {
        boolean hasRelatives = false;
        try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
            log.info("Looking for relative paths in {}", (Object)tableName);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                Key key = (Key)entry.getKey();
                String metaEntry = key.getColumnQualifier().toString();
                if (metaEntry.contains(":")) continue;
                hasRelatives = true;
                if (upgradeProperty == null || upgradeProperty.isBlank()) {
                    throw new IllegalArgumentException("Missing required property " + Property.INSTANCE_VOLUMES_UPGRADE_RELATIVE.getKey());
                }
                Path relPath = Upgrader9to10.resolveRelativePath(metaEntry, key);
                Path absPath = new Path(upgradeProperty, relPath);
                if (fs.exists(absPath)) continue;
                throw new IllegalArgumentException("Tablet file " + relPath + " not found at " + absPath + " using volume: " + upgradeProperty);
            }
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return hasRelatives;
    }

    private static Path resolveRelativePath(String metadataEntry, Key key) {
        String prefix = VolumeManager.FileType.TABLE.getDirectory() + "/";
        if (metadataEntry.startsWith("../")) {
            return new Path(prefix + metadataEntry.substring(3));
        }
        TableId tableId = KeyExtent.fromMetaRow((Text)key.getRow()).tableId();
        return new Path(prefix + tableId.canonical() + metadataEntry);
    }

    static Path resolveRelativeDelete(String oldDelete, String upgradeProperty) {
        Path pathNoVolume = VolumeManager.FileType.TABLE.removeVolume(new Path(oldDelete));
        Path pathToCheck = new Path(oldDelete);
        if (pathNoVolume != null) {
            return pathToCheck;
        }
        Preconditions.checkState((oldDelete.startsWith("/") && (pathToCheck.depth() == 2 || pathToCheck.depth() == 3) ? 1 : 0) != 0, (String)"Unrecognized relative delete marker (%s)", (Object)oldDelete);
        if (upgradeProperty == null || upgradeProperty.isBlank()) {
            throw new IllegalArgumentException("Missing required property " + Property.INSTANCE_VOLUMES_UPGRADE_RELATIVE.getKey());
        }
        return new Path(upgradeProperty, VolumeManager.FileType.TABLE.getDirectory() + oldDelete);
    }

    static void dropSortedMapWALFiles(ServerContext context) {
        VolumeManager vm = context.getVolumeManager();
        for (String recoveryDir : context.getRecoveryDirs()) {
            Path recoveryDirPath = new Path(recoveryDir);
            try {
                if (!vm.exists(recoveryDirPath)) {
                    log.info("There are no recovery files in {}", (Object)recoveryDir);
                    continue;
                }
                ArrayList<Path> directoriesToDrop = new ArrayList<Path>();
                block3: for (FileStatus walDir : vm.listStatus(recoveryDirPath)) {
                    Path walDirPath = walDir.getPath();
                    for (FileStatus dirOrFile : vm.listStatus(walDirPath)) {
                        if (!dirOrFile.isDirectory()) continue;
                        directoriesToDrop.add(walDirPath);
                        continue block3;
                    }
                }
                if (directoriesToDrop.isEmpty()) continue;
                log.info("Found {} old sorted map directories to delete.", (Object)directoriesToDrop.size());
                for (Path dir : directoriesToDrop) {
                    log.info("Deleting everything in old sorted map directory: {}", (Object)dir);
                    vm.deleteRecursively(dir);
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }

    private static class UpgradeMutator
    extends TabletMutatorBase {
        private final ServerContext context;

        UpgradeMutator(ServerContext context) {
            super(context, RootTable.EXTENT);
            this.context = context;
        }

        public void mutate() {
            Mutation mutation = this.getMutation();
            try {
                this.context.getZooReaderWriter().mutateOrCreate(this.context.getZooKeeperRoot() + "/root_tablet", new byte[0], currVal -> {
                    Preconditions.checkState((currVal.length == 0 ? 1 : 0) != 0, (Object)"Expected root tablet metadata to be empty!");
                    RootTabletMetadata rtm = new RootTabletMetadata();
                    rtm.update(mutation);
                    String json = rtm.toJson();
                    log.info("Upgrading root tablet metadata, writing following to ZK : \n {}", (Object)json);
                    return json.getBytes(StandardCharsets.UTF_8);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

