/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.delete;

import java.util.EnumSet;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.delete.CleanUp;

public class DeleteTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private TableId tableId;
    private NamespaceId namespaceId;

    public DeleteTable(NamespaceId namespaceId, TableId tableId) {
        this.namespaceId = namespaceId;
        this.tableId = tableId;
    }

    @Override
    public long isReady(long tid, Manager env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, false, TableOperation.DELETE) + Utils.reserveTable(env, this.tableId, tid, true, true, TableOperation.DELETE);
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) {
        EnumSet<TableState> expectedCurrStates = EnumSet.of(TableState.ONLINE, TableState.OFFLINE);
        env.getTableManager().transitionTableState(this.tableId, TableState.DELETING, expectedCurrStates);
        env.getEventCoordinator().event("deleting table %s ", this.tableId);
        return new CleanUp(this.tableId, this.namespaceId);
    }

    @Override
    public void undo(long tid, Manager env) {
        Utils.unreserveTable(env, this.tableId, tid, true);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
    }
}

