/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.bulk.BulkSerialize;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.manager.tableOps.bulkVer2.LoadFiles;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkImportMove
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BulkImportMove.class);
    private final BulkInfo bulkInfo;

    public BulkImportMove(BulkInfo bulkInfo) {
        this.bulkInfo = bulkInfo;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Path bulkDir = new Path(this.bulkInfo.bulkDir);
        Path sourceDir = new Path(this.bulkInfo.sourceDir);
        String fmtTid = FateTxId.formatTid((long)tid);
        log.debug("{} sourceDir {}", (Object)fmtTid, (Object)sourceDir);
        VolumeManager fs = manager.getVolumeManager();
        if (this.bulkInfo.tableState == TableState.ONLINE) {
            TransactionWatcher.ZooArbitrator.start((ServerContext)manager.getContext(), (String)"bulkTx", (long)tid);
        }
        try {
            manager.updateBulkImportStatus(sourceDir.toString(), BulkImportState.MOVING);
            Map oldToNewNameMap = BulkSerialize.readRenameMap((String)bulkDir.toString(), arg_0 -> ((VolumeManager)fs).open(arg_0));
            this.moveFiles(tid, sourceDir, bulkDir, manager, fs, oldToNewNameMap);
            return new LoadFiles(this.bulkInfo);
        }
        catch (Exception ex) {
            throw new AcceptableThriftTableOperationException(this.bulkInfo.tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_INPUT_DIRECTORY, this.bulkInfo.sourceDir + ": " + ex);
        }
    }

    private void moveFiles(long tid, Path sourceDir, Path bulkDir, Manager manager, VolumeManager fs, Map<String, String> renames) throws Exception {
        manager.getContext().getAmple().addBulkLoadInProgressFlag("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName(), tid);
        AccumuloConfiguration aConf = manager.getConfiguration();
        int workerCount = aConf.getCount(aConf.resolve(Property.MANAGER_RENAME_THREADS, new Property[]{Property.MANAGER_BULK_RENAME_THREADS}));
        HashMap<Path, Path> oldToNewMap = new HashMap<Path, Path>();
        String fmtTid = FateTxId.formatTid((long)tid);
        for (Map.Entry<String, String> renameEntry : renames.entrySet()) {
            Path originalPath = new Path(sourceDir, renameEntry.getKey());
            Path newPath = new Path(bulkDir, renameEntry.getValue());
            oldToNewMap.put(originalPath, newPath);
        }
        try {
            fs.bulkRename(oldToNewMap, workerCount, ThreadPoolNames.BULK_IMPORT_DIR_MOVE_POOL.poolName, fmtTid);
        }
        catch (IOException ioe) {
            throw new AcceptableThriftTableOperationException(this.bulkInfo.tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.OTHER, ioe.getCause().getMessage());
        }
    }
}

