/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadCompactionDetector {
    private static final Logger log = LoggerFactory.getLogger(DeadCompactionDetector.class);
    private final ServerContext context;
    private final CompactionCoordinator coordinator;
    private final ScheduledThreadPoolExecutor schedExecutor;
    private final ConcurrentHashMap<ExternalCompactionId, Long> deadCompactions;

    public DeadCompactionDetector(ServerContext context, CompactionCoordinator coordinator, ScheduledThreadPoolExecutor stpe) {
        this.context = context;
        this.coordinator = coordinator;
        this.schedExecutor = stpe;
        this.deadCompactions = new ConcurrentHashMap();
    }

    private void detectDeadCompactions() {
        log.trace("Starting to look for dead compactions");
        HashMap<ExternalCompactionId, KeyExtent> tabletCompactions = new HashMap<ExternalCompactionId, KeyExtent>();
        this.context.getAmple().readTablets().forLevel(Ample.DataLevel.USER).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP, TabletMetadata.ColumnType.PREV_ROW}).build().forEach(tm -> tm.getExternalCompactions().keySet().forEach(ecid -> tabletCompactions.put((ExternalCompactionId)ecid, tm.getExtent())));
        if (tabletCompactions.isEmpty()) {
            log.trace("Clearing the dead compaction map, no tablets have compactions running");
            this.deadCompactions.clear();
            return;
        }
        if (log.isTraceEnabled()) {
            tabletCompactions.forEach((ecid, extent) -> log.trace("Saw {} for {}", ecid, extent));
        }
        ((ConcurrentHashMap.CollectionView)((Object)this.deadCompactions.keySet())).retainAll(tabletCompactions.keySet());
        Collection running = ExternalCompactionUtil.getCompactionIdsRunningOnCompactors((ClientContext)this.context);
        running.forEach(ecid -> {
            if (tabletCompactions.remove(ecid) != null) {
                log.trace("Removed compaction {} running on a compactor", ecid);
            }
            if (this.deadCompactions.remove(ecid) != null) {
                log.trace("Removed {} from the dead compaction map, it's running on a compactor", ecid);
            }
        });
        this.context.getAmple().getExternalCompactionFinalStates().map(ecfs -> ecfs.getExternalCompactionId()).forEach(ecid -> {
            if (tabletCompactions.remove(ecid) != null) {
                log.trace("Removed compaction {} that is committing", ecid);
            }
            if (this.deadCompactions.remove(ecid) != null) {
                log.trace("Removed {} from the dead compaction map, it's committing", ecid);
            }
        });
        tabletCompactions.forEach((ecid, extent) -> {
            Long count = this.deadCompactions.merge((ExternalCompactionId)ecid, 1L, Long::sum);
            if (count == 1L) {
                log.trace("Possible dead compaction detected {} {} {}", new Object[]{ecid, extent, count});
            } else {
                log.debug("Possible dead compaction detected {} {} {}", new Object[]{ecid, extent, count});
            }
        });
        Set toFail = this.deadCompactions.entrySet().stream().filter(e -> (Long)e.getValue() > 2L).map(e -> (ExternalCompactionId)e.getKey()).collect(Collectors.toCollection(TreeSet::new));
        tabletCompactions.keySet().retainAll(toFail);
        tabletCompactions.forEach((ecid, extent) -> log.warn("Compaction believed to be dead, failing it: id: {}, extent: {}", ecid, extent));
        this.coordinator.compactionFailed(tabletCompactions);
        ((ConcurrentHashMap.KeySetView)this.deadCompactions.keySet()).removeAll((Collection)toFail);
    }

    public void start() {
        long interval = this.context.getConfiguration().getTimeInMillis(Property.COMPACTION_COORDINATOR_DEAD_COMPACTOR_CHECK_INTERVAL);
        ThreadPools.watchCriticalScheduledTask(this.schedExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.detectDeadCompactions();
            }
            catch (RuntimeException e) {
                log.warn("Failed to look for dead compactions", (Throwable)e);
            }
        }, 0L, interval, TimeUnit.MILLISECONDS));
    }
}

