/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.tables;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.util.Validators;
import org.apache.accumulo.core.util.tables.TableMap;
import org.apache.accumulo.core.util.tables.TableNameUtil;

public class TableZooHelper
implements AutoCloseable {
    private final ClientContext context;
    private final Cache<TableZooHelper, TableMap> instanceToMapCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public TableZooHelper(ClientContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public TableId getTableId(String tableName) throws TableNotFoundException {
        if (MetadataTable.NAME.equals(tableName)) {
            return MetadataTable.ID;
        }
        if (RootTable.NAME.equals(tableName)) {
            return RootTable.ID;
        }
        try {
            return this._getTableIdDetectNamespaceNotFound(Validators.EXISTING_TABLE_NAME.validate(tableName));
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(tableName, e);
        }
    }

    public TableId _getTableIdDetectNamespaceNotFound(String tableName) throws NamespaceNotFoundException, TableNotFoundException {
        TableId tableId = this.getTableMap().getNameToIdMap().get(tableName);
        if (tableId == null) {
            this.clearTableListCache();
            tableId = this.getTableMap().getNameToIdMap().get(tableName);
            if (tableId == null) {
                String namespace = TableNameUtil.qualify(tableName).getFirst();
                if (Namespaces.getNameToIdMap(this.context).containsKey(namespace)) {
                    throw new TableNotFoundException(null, tableName, null);
                }
                throw new NamespaceNotFoundException(null, namespace, null);
            }
        }
        return tableId;
    }

    public String getTableName(TableId tableId) throws TableNotFoundException {
        if (MetadataTable.ID.equals(tableId)) {
            return MetadataTable.NAME;
        }
        if (RootTable.ID.equals(tableId)) {
            return RootTable.NAME;
        }
        String tableName = this.getTableMap().getIdtoNameMap().get(tableId);
        if (tableName == null) {
            throw new TableNotFoundException(tableId.canonical(), null, null);
        }
        return tableName;
    }

    public TableMap getTableMap() {
        ZooCache zc = this.context.getZooCache();
        TableMap map = this.getCachedTableMap();
        if (!map.isCurrent(zc)) {
            this.instanceToMapCache.invalidateAll();
            map = this.getCachedTableMap();
        }
        return map;
    }

    private TableMap getCachedTableMap() {
        try {
            return (TableMap)this.instanceToMapCache.get((Object)this, () -> new TableMap(this.context));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean tableNodeExists(TableId tableId) {
        ZooCache zc = this.context.getZooCache();
        List<String> tableIds = zc.getChildren(this.context.getZooKeeperRoot() + "/tables");
        return tableIds.contains(tableId.canonical());
    }

    public void clearTableListCache() {
        this.context.getZooCache().clear(this.context.getZooKeeperRoot() + "/tables");
        this.context.getZooCache().clear(this.context.getZooKeeperRoot() + "/namespaces");
        this.instanceToMapCache.invalidateAll();
    }

    public String getPrintableTableInfoFromId(TableId tableId) {
        try {
            return this._printableTableInfo(this.getTableName(tableId), tableId);
        }
        catch (TableNotFoundException e) {
            return this._printableTableInfo(null, tableId);
        }
    }

    public String getPrintableTableInfoFromName(String tableName) {
        try {
            return this._printableTableInfo(tableName, this.getTableId(tableName));
        }
        catch (TableNotFoundException e) {
            return this._printableTableInfo(tableName, null);
        }
    }

    private String _printableTableInfo(String tableName, TableId tableId) {
        return String.format("%s(ID:%s)", tableName == null ? "?" : tableName, tableId == null ? "?" : tableId.canonical());
    }

    public TableState getTableState(TableId tableId, boolean clearCachedState) {
        ZooCache zc;
        byte[] state;
        String statePath = this.context.getZooKeeperRoot() + "/tables/" + tableId.canonical() + "/state";
        if (clearCachedState) {
            this.context.getZooCache().clear(this.context.getZooKeeperRoot() + statePath);
            this.instanceToMapCache.invalidateAll();
        }
        if ((state = (zc = this.context.getZooCache()).get(statePath)) == null) {
            return TableState.UNKNOWN;
        }
        return TableState.valueOf(new String(state, StandardCharsets.UTF_8));
    }

    public NamespaceId getNamespaceId(TableId tableId) throws TableNotFoundException {
        Preconditions.checkArgument((this.context != null ? 1 : 0) != 0, (Object)"instance is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        if (MetadataTable.ID.equals(tableId) || RootTable.ID.equals(tableId)) {
            return Namespace.ACCUMULO.id();
        }
        ZooCache zc = this.context.getZooCache();
        byte[] n = zc.get(this.context.getZooKeeperRoot() + "/tables/" + tableId + "/namespace");
        if (n == null) {
            throw new TableNotFoundException(tableId.canonical(), null, null);
        }
        return NamespaceId.of(new String(n, StandardCharsets.UTF_8));
    }

    @Override
    public void close() {
        this.instanceToMapCache.invalidateAll();
    }
}

