/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningCompactionInfo {
    private static final Logger log = LoggerFactory.getLogger(RunningCompactionInfo.class);
    public final String server;
    public final String queueName;
    public final String ecid;
    public final String kind;
    public final String tableId;
    public final int numFiles;
    public final float progress;
    public final long duration;
    public final String status;
    public final long lastUpdate;

    public RunningCompactionInfo(TExternalCompaction ec) {
        Objects.requireNonNull(ec, "Thrift external compaction is null.");
        Map<Long, TCompactionStatusUpdate> updates = Objects.requireNonNull(ec.getUpdates(), "Missing Thrift external compaction updates");
        TExternalCompactionJob job = Objects.requireNonNull(ec.getJob(), "Thrift external compaction job is null");
        this.server = ec.getCompactor();
        this.queueName = ec.getQueueName();
        this.ecid = job.getExternalCompactionId();
        this.kind = job.getKind().name();
        this.tableId = KeyExtent.fromThrift(job.getExtent()).tableId().canonical();
        this.numFiles = job.getFiles().size();
        long nowMillis = System.currentTimeMillis();
        float percent = 0.0f;
        TreeMap<Long, TCompactionStatusUpdate> sorted = new TreeMap<Long, TCompactionStatusUpdate>(updates);
        Map.Entry<Long, TCompactionStatusUpdate> lastEntry = sorted.lastEntry();
        if (lastEntry == null) {
            log.debug("No updates found for {}", (Object)this.ecid);
            this.lastUpdate = 1L;
            this.progress = percent;
            this.status = "na";
            this.duration = 0L;
            return;
        }
        TCompactionStatusUpdate last = lastEntry.getValue();
        long updateMillis = lastEntry.getKey();
        this.duration = last.getCompactionAgeNanos();
        long durationMinutes = TimeUnit.NANOSECONDS.toMinutes(this.duration);
        if (durationMinutes > 15L) {
            log.warn("Compaction {} has been running for {} minutes", (Object)this.ecid, (Object)durationMinutes);
        }
        this.lastUpdate = nowMillis - updateMillis;
        long sinceLastUpdateSeconds = TimeUnit.MILLISECONDS.toSeconds(this.lastUpdate);
        log.debug("Time since Last update {} - {} = {} seconds", new Object[]{nowMillis, updateMillis, sinceLastUpdateSeconds});
        long total = last.getEntriesToBeCompacted();
        if (total > 0L) {
            percent = (float)last.getEntriesRead() / (float)total * 100.0f;
        }
        this.progress = percent;
        this.status = updates.isEmpty() ? "na" : last.state.name();
        log.debug("Parsed running compaction {} for {} with progress = {}%", new Object[]{this.status, this.ecid, Float.valueOf(this.progress)});
        if (sinceLastUpdateSeconds > 30L) {
            log.debug("Compaction hasn't progressed from {} in {} seconds.", (Object)Float.valueOf(this.progress), (Object)sinceLastUpdateSeconds);
        }
    }

    public String toString() {
        return this.ecid + ": " + this.status + " progress: " + this.progress;
    }
}

