/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Halt {
    private static final Logger log = LoggerFactory.getLogger(Halt.class);

    public static void halt(final String msg) {
        Halt.halt(0, new Runnable(){

            @Override
            public void run() {
                log.error("FATAL {}", (Object)msg);
            }
        });
    }

    public static void halt(final String msg, int status) {
        Halt.halt(status, new Runnable(){

            @Override
            public void run() {
                log.error("FATAL {}", (Object)msg);
            }
        });
    }

    public static void halt(int status, Runnable runnable) {
        try {
            Threads.createThread("Halt Thread", () -> {
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                Runtime.getRuntime().halt(status);
            }).start();
            if (runnable != null) {
                runnable.run();
            }
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(-1);
        }
    }
}

