/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.spi.scan.DefaultScanDispatch;
import org.apache.accumulo.core.spi.scan.ScanDispatch;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.core.spi.scan.ScanInfo;

public class SimpleScanDispatcher
implements ScanDispatcher {
    private final String EXECUTOR_PREFIX = "executor.";
    private final Set<String> VALID_OPTS = Set.of("executor", "multi_executor", "single_executor");
    private ScanDispatch singleDispatch;
    private ScanDispatch multiDispatch;
    private Map<String, Map<ScanInfo.Type, ScanDispatch>> hintDispatch;
    private static Pattern CACHE_PATTERN = Pattern.compile("cacheUsage[.](\\w+)([.](index|data))?");
    public static final String DEFAULT_SCAN_EXECUTOR_NAME = "default";

    @Override
    public void init(ScanDispatcher.InitParameters params) {
        Map<String, String> options = params.getOptions();
        HashMap indexCacheUsage = new HashMap();
        HashMap dataCacheUsage = new HashMap();
        HashMap scanExecutors = new HashMap();
        HashSet hintScanTypes = new HashSet();
        options.forEach((k, v) -> {
            Matcher cacheMatcher = CACHE_PATTERN.matcher((CharSequence)k);
            if (k.startsWith("executor.")) {
                String hintScanType = k.substring("executor.".length());
                scanExecutors.put(hintScanType, v);
                hintScanTypes.add(hintScanType);
            } else if (cacheMatcher.matches()) {
                String hintScanType = cacheMatcher.group(1);
                ScanDispatch.CacheUsage usage = ScanDispatch.CacheUsage.valueOf(v.toUpperCase());
                String cacheType = cacheMatcher.group(3);
                hintScanTypes.add(hintScanType);
                if ("index".equals(cacheType)) {
                    indexCacheUsage.put(hintScanType, usage);
                } else if ("data".equals(cacheType)) {
                    dataCacheUsage.put(hintScanType, usage);
                } else {
                    indexCacheUsage.put(hintScanType, usage);
                    dataCacheUsage.put(hintScanType, usage);
                }
            } else if (!this.VALID_OPTS.contains(k)) {
                throw new IllegalArgumentException("Invalid option " + k);
            }
        });
        ScanDispatch baseDispatch = Optional.ofNullable(options.get("executor")).map(name -> ScanDispatch.builder().setExecutorName((String)name).build()).orElse(DefaultScanDispatch.DEFAULT_SCAN_DISPATCH);
        this.singleDispatch = Optional.ofNullable(options.get("single_executor")).map(name -> ScanDispatch.builder().setExecutorName((String)name).build()).orElse(baseDispatch);
        this.multiDispatch = Optional.ofNullable(options.get("multi_executor")).map(name -> ScanDispatch.builder().setExecutorName((String)name).build()).orElse(baseDispatch);
        this.hintDispatch = hintScanTypes.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), hintScanType -> {
            EnumMap<ScanInfo.Type, ScanDispatch> precomupted = new EnumMap<ScanInfo.Type, ScanDispatch>(ScanInfo.Type.class);
            ScanDispatch.CacheUsage iCacheUsage = indexCacheUsage.getOrDefault(hintScanType, ScanDispatch.CacheUsage.TABLE);
            ScanDispatch.CacheUsage dCacheUsage = dataCacheUsage.getOrDefault(hintScanType, ScanDispatch.CacheUsage.TABLE);
            precomupted.put(ScanInfo.Type.SINGLE, ScanDispatch.builder().setExecutorName(scanExecutors.getOrDefault(hintScanType, this.singleDispatch.getExecutorName())).setIndexCacheUsage(iCacheUsage).setDataCacheUsage(dCacheUsage).build());
            precomupted.put(ScanInfo.Type.MULTI, ScanDispatch.builder().setExecutorName(scanExecutors.getOrDefault(hintScanType, this.multiDispatch.getExecutorName())).setIndexCacheUsage(iCacheUsage).setDataCacheUsage(dCacheUsage).build());
            return precomupted;
        }));
    }

    @Override
    public ScanDispatch dispatch(ScanDispatcher.DispatchParameters params) {
        Map<ScanInfo.Type, ScanDispatch> precomputedDispatch;
        String hintScanType;
        ScanInfo scanInfo = params.getScanInfo();
        if (!this.hintDispatch.isEmpty() && (hintScanType = scanInfo.getExecutionHints().get("scan_type")) != null && (precomputedDispatch = this.hintDispatch.get(hintScanType)) != null) {
            return precomputedDispatch.get((Object)scanInfo.getScanType());
        }
        switch (scanInfo.getScanType()) {
            case MULTI: {
                return this.multiDispatch;
            }
            case SINGLE: {
                return this.singleDispatch;
            }
        }
        throw new IllegalArgumentException("Unexpected scan type " + scanInfo.getScanType());
    }
}

