/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.securityImpl.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.securityImpl.thrift.TAuthenticationTokenIdentifier;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TDelegationToken
implements TBase<TDelegationToken, _Fields>,
Serializable,
Cloneable,
Comparable<TDelegationToken> {
    private static final TStruct STRUCT_DESC = new TStruct("TDelegationToken");
    private static final TField PASSWORD_FIELD_DESC = new TField("password", 11, 1);
    private static final TField IDENTIFIER_FIELD_DESC = new TField("identifier", 12, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TDelegationTokenStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TDelegationTokenTupleSchemeFactory();
    @Nullable
    public ByteBuffer password;
    @Nullable
    public TAuthenticationTokenIdentifier identifier;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TDelegationToken() {
    }

    public TDelegationToken(ByteBuffer password, TAuthenticationTokenIdentifier identifier) {
        this();
        this.password = TBaseHelper.copyBinary((ByteBuffer)password);
        this.identifier = identifier;
    }

    public TDelegationToken(TDelegationToken other) {
        if (other.isSetPassword()) {
            this.password = TBaseHelper.copyBinary((ByteBuffer)other.password);
        }
        if (other.isSetIdentifier()) {
            this.identifier = new TAuthenticationTokenIdentifier(other.identifier);
        }
    }

    public TDelegationToken deepCopy() {
        return new TDelegationToken(this);
    }

    public void clear() {
        this.password = null;
        this.identifier = null;
    }

    public byte[] getPassword() {
        this.setPassword(TBaseHelper.rightSize((ByteBuffer)this.password));
        return this.password == null ? null : this.password.array();
    }

    public ByteBuffer bufferForPassword() {
        return TBaseHelper.copyBinary((ByteBuffer)this.password);
    }

    public TDelegationToken setPassword(byte[] password) {
        this.password = password == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])password.clone());
        return this;
    }

    public TDelegationToken setPassword(@Nullable ByteBuffer password) {
        this.password = TBaseHelper.copyBinary((ByteBuffer)password);
        return this;
    }

    public void unsetPassword() {
        this.password = null;
    }

    public boolean isSetPassword() {
        return this.password != null;
    }

    public void setPasswordIsSet(boolean value) {
        if (!value) {
            this.password = null;
        }
    }

    @Nullable
    public TAuthenticationTokenIdentifier getIdentifier() {
        return this.identifier;
    }

    public TDelegationToken setIdentifier(@Nullable TAuthenticationTokenIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public void unsetIdentifier() {
        this.identifier = null;
    }

    public boolean isSetIdentifier() {
        return this.identifier != null;
    }

    public void setIdentifierIsSet(boolean value) {
        if (!value) {
            this.identifier = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PASSWORD: {
                if (value == null) {
                    this.unsetPassword();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setPassword((byte[])value);
                    break;
                }
                this.setPassword((ByteBuffer)value);
                break;
            }
            case IDENTIFIER: {
                if (value == null) {
                    this.unsetIdentifier();
                    break;
                }
                this.setIdentifier((TAuthenticationTokenIdentifier)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PASSWORD: {
                return this.getPassword();
            }
            case IDENTIFIER: {
                return this.getIdentifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PASSWORD: {
                return this.isSetPassword();
            }
            case IDENTIFIER: {
                return this.isSetIdentifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TDelegationToken) {
            return this.equals((TDelegationToken)that);
        }
        return false;
    }

    public boolean equals(TDelegationToken that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_password = this.isSetPassword();
        boolean that_present_password = that.isSetPassword();
        if (this_present_password || that_present_password) {
            if (!this_present_password || !that_present_password) {
                return false;
            }
            if (!this.password.equals(that.password)) {
                return false;
            }
        }
        boolean this_present_identifier = this.isSetIdentifier();
        boolean that_present_identifier = that.isSetIdentifier();
        if (this_present_identifier || that_present_identifier) {
            if (!this_present_identifier || !that_present_identifier) {
                return false;
            }
            if (!this.identifier.equals(that.identifier)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPassword() ? 131071 : 524287);
        if (this.isSetPassword()) {
            hashCode = hashCode * 8191 + this.password.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIdentifier() ? 131071 : 524287);
        if (this.isSetIdentifier()) {
            hashCode = hashCode * 8191 + this.identifier.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TDelegationToken other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPassword(), other.isSetPassword());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPassword() && (lastComparison = TBaseHelper.compareTo((Comparable)this.password, (Comparable)other.password)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIdentifier(), other.isSetIdentifier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIdentifier() && (lastComparison = TBaseHelper.compareTo((Comparable)this.identifier, (Comparable)other.identifier)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TDelegationToken.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TDelegationToken.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TDelegationToken(");
        boolean first = true;
        sb.append("password:");
        if (this.password == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.password, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("identifier:");
        if (this.identifier == null) {
            sb.append("null");
        } else {
            sb.append(this.identifier);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.identifier != null) {
            this.identifier.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    private static void unusedMethod() {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PASSWORD, new FieldMetaData("password", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.IDENTIFIER, new FieldMetaData("identifier", 3, (FieldValueMetaData)new StructMetaData(12, TAuthenticationTokenIdentifier.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TDelegationToken.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PASSWORD(1, "password"),
        IDENTIFIER(2, "identifier");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PASSWORD;
                }
                case 2: {
                    return IDENTIFIER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TDelegationTokenStandardSchemeFactory
    implements SchemeFactory {
        private TDelegationTokenStandardSchemeFactory() {
        }

        public TDelegationTokenStandardScheme getScheme() {
            return new TDelegationTokenStandardScheme();
        }
    }

    private static class TDelegationTokenTupleSchemeFactory
    implements SchemeFactory {
        private TDelegationTokenTupleSchemeFactory() {
        }

        public TDelegationTokenTupleScheme getScheme() {
            return new TDelegationTokenTupleScheme();
        }
    }

    private static class TDelegationTokenTupleScheme
    extends TupleScheme<TDelegationToken> {
        private TDelegationTokenTupleScheme() {
        }

        public void write(TProtocol prot, TDelegationToken struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetPassword()) {
                optionals.set(0);
            }
            if (struct.isSetIdentifier()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetPassword()) {
                oprot.writeBinary(struct.password);
            }
            if (struct.isSetIdentifier()) {
                struct.identifier.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, TDelegationToken struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.password = iprot.readBinary();
                struct.setPasswordIsSet(true);
            }
            if (incoming.get(1)) {
                struct.identifier = new TAuthenticationTokenIdentifier();
                struct.identifier.read((TProtocol)iprot);
                struct.setIdentifierIsSet(true);
            }
        }
    }

    private static class TDelegationTokenStandardScheme
    extends StandardScheme<TDelegationToken> {
        private TDelegationTokenStandardScheme() {
        }

        public void read(TProtocol iprot, TDelegationToken struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.password = iprot.readBinary();
                            struct.setPasswordIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.identifier = new TAuthenticationTokenIdentifier();
                            struct.identifier.read(iprot);
                            struct.setIdentifierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TDelegationToken struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.password != null) {
                oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
                oprot.writeBinary(struct.password);
                oprot.writeFieldEnd();
            }
            if (struct.identifier != null) {
                oprot.writeFieldBegin(IDENTIFIER_FIELD_DESC);
                struct.identifier.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

