/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc.clients;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.rpc.clients.ClientServiceThriftClient;
import org.apache.accumulo.core.rpc.clients.CompactionCoordinatorServiceThriftClient;
import org.apache.accumulo.core.rpc.clients.CompactorServiceThriftClient;
import org.apache.accumulo.core.rpc.clients.FateThriftClient;
import org.apache.accumulo.core.rpc.clients.GCMonitorServiceThriftClient;
import org.apache.accumulo.core.rpc.clients.ManagerThriftClient;
import org.apache.accumulo.core.rpc.clients.ReplicationCoordinatorThriftClient;
import org.apache.accumulo.core.rpc.clients.ReplicationServicerThriftClient;
import org.apache.accumulo.core.rpc.clients.TabletScanClientServiceThriftClient;
import org.apache.accumulo.core.rpc.clients.TabletServerThriftClient;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;

public abstract class ThriftClientTypes<C extends TServiceClient> {
    public static final ClientServiceThriftClient CLIENT = new ClientServiceThriftClient("client");
    public static final CompactorServiceThriftClient COMPACTOR = new CompactorServiceThriftClient("compactor");
    public static final CompactionCoordinatorServiceThriftClient COORDINATOR = new CompactionCoordinatorServiceThriftClient("coordinator");
    public static final FateThriftClient FATE = new FateThriftClient("fate");
    public static final GCMonitorServiceThriftClient GC = new GCMonitorServiceThriftClient("gc");
    public static final ManagerThriftClient MANAGER = new ManagerThriftClient("mgr");
    public static final ReplicationCoordinatorThriftClient REPLICATION_COORDINATOR = new ReplicationCoordinatorThriftClient("replCoord");
    public static final ReplicationServicerThriftClient REPLICATION_SERVICER = new ReplicationServicerThriftClient("replServ");
    public static final TabletServerThriftClient TABLET_SERVER = new TabletServerThriftClient("tablet");
    public static final TabletScanClientServiceThriftClient TABLET_SCAN = new TabletScanClientServiceThriftClient("scan");
    private final String serviceName;
    private final TServiceClientFactory<C> clientFactory;

    protected ThriftClientTypes(String serviceName, TServiceClientFactory<C> factory) {
        this.serviceName = serviceName;
        this.clientFactory = factory;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final TServiceClientFactory<C> getClientFactory() {
        return this.clientFactory;
    }

    public C getClient(TProtocol prot) {
        return (C)this.getClientFactory().getClient((TProtocol)new TMultiplexedProtocol(prot, this.getServiceName()));
    }

    public C getConnection(ClientContext context) {
        throw new UnsupportedOperationException("This method has not been implemented");
    }

    public C getConnectionWithRetry(ClientContext context) {
        C result;
        while ((result = this.getConnection(context)) == null) {
            UtilWaitThread.sleepUninterruptibly(250L, TimeUnit.MILLISECONDS);
        }
        return result;
    }

    public <R> R execute(ClientContext context, Exec<R, C> exec) throws AccumuloException, AccumuloSecurityException {
        throw new UnsupportedOperationException("This method has not been implemented");
    }

    public void executeVoid(ClientContext context, ExecVoid<C> exec) throws AccumuloException, AccumuloSecurityException {
        throw new UnsupportedOperationException("This method has not been implemented");
    }

    public String toString() {
        return this.serviceName;
    }

    public static interface ExecVoid<C> {
        public void execute(C var1) throws TException;
    }

    public static interface Exec<R, C> {
        public R execute(C var1) throws TException;
    }
}

