/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Arrays;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConnectionParams {
    private static final Logger log = LoggerFactory.getLogger(SslConnectionParams.class);
    private boolean useJsse = false;
    private boolean clientAuth = false;
    private boolean keyStoreSet;
    private String keyStorePath;
    private String keyStorePass;
    private String keyStoreType;
    private boolean trustStoreSet;
    private String trustStorePath;
    private String trustStorePass;
    private String trustStoreType;
    private String[] cipherSuites;
    private String[] serverProtocols;
    private String clientProtocol;

    private SslConnectionParams() {
    }

    public static SslConnectionParams forConfig(AccumuloConfiguration conf, boolean server) {
        if (!conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
            return null;
        }
        SslConnectionParams result = new SslConnectionParams();
        boolean requireClientAuth = conf.getBoolean(Property.INSTANCE_RPC_SSL_CLIENT_AUTH);
        if (server) {
            result.setClientAuth(requireClientAuth);
        }
        if (conf.getBoolean(Property.RPC_USE_JSSE)) {
            result.setUseJsse(true);
            return result;
        }
        try {
            if (!server || requireClientAuth) {
                result.setTrustStoreFromConf(conf);
            }
            if (server || requireClientAuth) {
                result.setKeyStoreFromConf(conf);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not load configured keystore file", e);
        }
        String ciphers = conf.get(Property.RPC_SSL_CIPHER_SUITES);
        if (ciphers != null && !ciphers.isEmpty()) {
            result.cipherSuites = ciphers.split(",");
        }
        String enabledProtocols = conf.get(Property.RPC_SSL_ENABLED_PROTOCOLS);
        result.serverProtocols = enabledProtocols.split(",");
        result.clientProtocol = conf.get(Property.RPC_SSL_CLIENT_PROTOCOL);
        return result;
    }

    private static String passwordFromConf(AccumuloConfiguration conf, String defaultPassword, Property passwordOverrideProperty) {
        String keystorePassword = conf.get(passwordOverrideProperty);
        if (keystorePassword.isEmpty()) {
            keystorePassword = defaultPassword;
        } else if (log.isTraceEnabled()) {
            log.trace("Using explicit SSL private key password from {}", (Object)passwordOverrideProperty.getKey());
        }
        return keystorePassword;
    }

    private static String storePathFromConf(AccumuloConfiguration conf, Property pathProperty) throws FileNotFoundException {
        return SslConnectionParams.findKeystore(conf.getPath(pathProperty));
    }

    public void setKeyStoreFromConf(AccumuloConfiguration conf) throws FileNotFoundException {
        this.keyStoreSet = true;
        this.keyStorePath = SslConnectionParams.storePathFromConf(conf, Property.RPC_SSL_KEYSTORE_PATH);
        this.keyStorePass = SslConnectionParams.passwordFromConf(conf, conf.get(Property.INSTANCE_SECRET), Property.RPC_SSL_KEYSTORE_PASSWORD);
        this.keyStoreType = conf.get(Property.RPC_SSL_KEYSTORE_TYPE);
    }

    public void setTrustStoreFromConf(AccumuloConfiguration conf) throws FileNotFoundException {
        this.trustStoreSet = true;
        this.trustStorePath = SslConnectionParams.storePathFromConf(conf, Property.RPC_SSL_TRUSTSTORE_PATH);
        this.trustStorePass = SslConnectionParams.passwordFromConf(conf, "", Property.RPC_SSL_TRUSTSTORE_PASSWORD);
        this.trustStoreType = conf.get(Property.RPC_SSL_TRUSTSTORE_TYPE);
    }

    public static SslConnectionParams forServer(AccumuloConfiguration configuration) {
        return SslConnectionParams.forConfig(configuration, true);
    }

    public static SslConnectionParams forClient(AccumuloConfiguration configuration) {
        return SslConnectionParams.forConfig(configuration, false);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who providing the keystore file")
    private static String findKeystore(String keystorePath) throws FileNotFoundException {
        try {
            URL url;
            File file = new File(keystorePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!file.isAbsolute() && (url = SslConnectionParams.class.getClassLoader().getResource(keystorePath)) != null && (file = new File(url.toURI())).exists()) {
                return file.getAbsolutePath();
            }
        }
        catch (Exception e) {
            log.warn("Exception finding keystore", (Throwable)e);
        }
        throw new FileNotFoundException("Failed to load SSL keystore from " + keystorePath);
    }

    public void setUseJsse(boolean useJsse) {
        this.useJsse = useJsse;
    }

    public boolean useJsse() {
        return this.useJsse;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isClientAuth() {
        return this.clientAuth;
    }

    public String[] getServerProtocols() {
        return this.serverProtocols;
    }

    public String getClientProtocol() {
        return this.clientProtocol;
    }

    public boolean isKeyStoreSet() {
        return this.keyStoreSet;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public boolean isTrustStoreSet() {
        return this.trustStoreSet;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public TSSLTransportFactory.TSSLTransportParameters getTSSLTransportParameters() {
        if (this.useJsse) {
            throw new IllegalStateException("Cannot get TSSLTransportParameters for JSSE configuration.");
        }
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(this.clientProtocol, this.cipherSuites);
        params.requireClientAuth(this.clientAuth);
        if (this.keyStoreSet) {
            params.setKeyStore(this.keyStorePath, this.keyStorePass, null, this.keyStoreType);
        }
        if (this.trustStoreSet) {
            params.setTrustStore(this.trustStorePath, this.trustStorePass, null, this.trustStoreType);
        }
        return params;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + (this.clientAuth ? 0 : 1);
        hash = 31 * hash + (this.useJsse ? 0 : 1);
        if (this.useJsse) {
            return hash;
        }
        hash = 31 * hash + (this.keyStoreSet ? 0 : 1);
        hash = 31 * hash + (this.trustStoreSet ? 0 : 1);
        if (this.keyStoreSet) {
            hash = 31 * hash + this.keyStorePath.hashCode();
        }
        if (this.trustStoreSet) {
            hash = 31 * hash + this.trustStorePath.hashCode();
        }
        hash = 31 * hash + this.clientProtocol.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.serverProtocols);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SslConnectionParams)) {
            return false;
        }
        SslConnectionParams other = (SslConnectionParams)obj;
        if (this.clientAuth != other.clientAuth) {
            return false;
        }
        if (this.useJsse) {
            return other.useJsse;
        }
        if (this.keyStoreSet) {
            if (!other.keyStoreSet) {
                return false;
            }
            if (!(this.keyStorePath.equals(other.keyStorePath) && this.keyStorePass.equals(other.keyStorePass) && this.keyStoreType.equals(other.keyStoreType))) {
                return false;
            }
        }
        if (this.trustStoreSet) {
            if (!other.trustStoreSet) {
                return false;
            }
            if (!(this.trustStorePath.equals(other.trustStorePath) && this.trustStorePass.equals(other.trustStorePass) && this.trustStoreType.equals(other.trustStoreType))) {
                return false;
            }
        }
        if (!Arrays.equals(this.serverProtocols, other.serverProtocols)) {
            return false;
        }
        return this.clientProtocol.equals(other.clientProtocol);
    }
}

