/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.SuspendingTServer;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;

public class TabletLocationState {
    public final KeyExtent extent;
    public final TabletMetadata.Location future;
    public final TabletMetadata.Location current;
    public final TabletMetadata.Location last;
    public final SuspendingTServer suspend;
    public final Collection<Collection<String>> walogs;
    public final boolean chopped;

    public TabletLocationState(KeyExtent extent, TabletMetadata.Location future, TabletMetadata.Location current, TabletMetadata.Location last, SuspendingTServer suspend, Collection<Collection<String>> walogs, boolean chopped) throws BadLocationStateException {
        this.extent = Objects.requireNonNull(extent);
        this.future = TabletLocationState.validateLocation(future, TabletMetadata.LocationType.FUTURE);
        this.current = TabletLocationState.validateLocation(current, TabletMetadata.LocationType.CURRENT);
        this.last = TabletLocationState.validateLocation(last, TabletMetadata.LocationType.LAST);
        this.suspend = suspend;
        if (walogs == null) {
            walogs = Collections.emptyList();
        }
        this.walogs = walogs;
        this.chopped = chopped;
        if (this.hasCurrent() && this.hasFuture()) {
            throw new BadLocationStateException(extent + " is both assigned and hosted, which should never happen: " + this, extent.toMetaRow());
        }
    }

    public TServerInstance getCurrentServer() {
        return TabletLocationState.serverInstance(this.current);
    }

    public TServerInstance getFutureServer() {
        return TabletLocationState.serverInstance(this.future);
    }

    public TServerInstance getLastServer() {
        return TabletLocationState.serverInstance(this.last);
    }

    public TServerInstance futureOrCurrentServer() {
        return TabletLocationState.serverInstance(this.futureOrCurrent());
    }

    public TabletMetadata.Location futureOrCurrent() {
        if (this.hasCurrent()) {
            return this.current;
        }
        return this.future;
    }

    public TServerInstance getServer() {
        return TabletLocationState.serverInstance(this.getLocation());
    }

    public TabletMetadata.Location getLocation() {
        TabletMetadata.Location result = null;
        result = this.hasCurrent() ? this.current : (this.hasFuture() ? this.future : this.last);
        return result;
    }

    public boolean hasCurrent() {
        return this.current != null;
    }

    public boolean hasFuture() {
        return this.future != null;
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public TabletState getState(Set<TServerInstance> liveServers) {
        if (this.hasFuture()) {
            return liveServers.contains(this.future.getServerInstance()) ? TabletState.ASSIGNED : TabletState.ASSIGNED_TO_DEAD_SERVER;
        }
        if (this.hasCurrent()) {
            return liveServers.contains(this.current.getServerInstance()) ? TabletState.HOSTED : TabletState.ASSIGNED_TO_DEAD_SERVER;
        }
        if (this.hasSuspend()) {
            return TabletState.SUSPENDED;
        }
        return TabletState.UNASSIGNED;
    }

    public String toString() {
        return this.extent + "@(" + this.future + "," + this.current + "," + this.last + ")" + (this.chopped ? " chopped" : "");
    }

    private static TabletMetadata.Location validateLocation(TabletMetadata.Location location, TabletMetadata.LocationType type) {
        if (location != null && !location.getType().equals((Object)type)) {
            throw new IllegalArgumentException("Location type is required to be of type " + type);
        }
        return location;
    }

    protected static TServerInstance serverInstance(TabletMetadata.Location location) {
        return location != null ? location.getServerInstance() : null;
    }

    public static class BadLocationStateException
    extends Exception {
        private static final long serialVersionUID = 2L;
        private final byte[] metadataTableEntry;

        public BadLocationStateException(String msg, Text row) {
            super(msg);
            this.metadataTableEntry = TextUtil.getBytes(Objects.requireNonNull(row));
        }

        public Text getEncodedEndRow() {
            return new Text(this.metadataTableEntry);
        }
    }
}

