/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.UuidUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class ScanServerRefTabletFile
extends TabletFile {
    private static final String OLD_PREFIX = MetadataSchema.OldScanServerFileReferenceSection.getRowPrefix();
    private final String prefix;
    private final Value NULL_VALUE = new Value(new byte[0]);
    private final Text serverAddress;
    private final Text uuid;

    public ScanServerRefTabletFile(UUID serverLockUUID, String serverAddress, String file) {
        super(new Path(URI.create(file)));
        this.prefix = MetadataSchema.ScanServerFileReferenceSection.getRowPrefix();
        this.serverAddress = new Text(serverAddress);
        this.uuid = new Text(serverLockUUID.toString());
    }

    public ScanServerRefTabletFile(Key k) {
        super(new Path(URI.create(ScanServerRefTabletFile.extractFile(k))));
        this.serverAddress = k.getColumnFamily();
        if (ScanServerRefTabletFile.isOldPrefix(k)) {
            this.prefix = OLD_PREFIX;
            this.uuid = new Text(k.getColumnQualifier().toString());
        } else {
            this.prefix = MetadataSchema.ScanServerFileReferenceSection.getRowPrefix();
            String row = k.getRow().toString();
            Preconditions.checkArgument((boolean)row.startsWith(this.prefix), (String)"Unexpected row prefix %s ", (Object)row);
            String uuidStr = row.substring(this.prefix.length());
            Preconditions.checkArgument((boolean)UuidUtil.isUUID(uuidStr, 0), (String)"Row suffix is not uuid %s", (Object)row);
            this.uuid = new Text(uuidStr);
        }
    }

    public Mutation putMutation() {
        Mutation mutation = new Mutation(this.prefix + this.uuid.toString());
        mutation.put(this.serverAddress, this.getFilePath(), this.getValue());
        return mutation;
    }

    public Mutation putDeleteMutation() {
        Mutation mutation;
        if (Objects.equals(this.prefix, OLD_PREFIX)) {
            mutation = new Mutation(this.prefix + this.getPath().toString());
            mutation.putDelete(this.serverAddress, this.uuid);
        } else {
            mutation = new Mutation(this.prefix + this.uuid.toString());
            mutation.putDelete(this.serverAddress, this.getFilePath());
        }
        return mutation;
    }

    private static String extractFile(Key k) {
        if (ScanServerRefTabletFile.isOldPrefix(k)) {
            return k.getRow().toString().substring(OLD_PREFIX.length());
        }
        return k.getColumnQualifier().toString();
    }

    public static Range getRange(UUID uuid) {
        Objects.requireNonNull(uuid);
        return new Range(MetadataSchema.ScanServerFileReferenceSection.getRowPrefix() + uuid);
    }

    private static boolean isOldPrefix(Key k) {
        return k.getRow().toString().startsWith(OLD_PREFIX);
    }

    public UUID getServerLockUUID() {
        return UUID.fromString(this.uuid.toString());
    }

    public Text getFilePath() {
        return new Text(this.getPath().toString());
    }

    public Value getValue() {
        return this.NULL_VALUE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScanServerRefTabletFile other = (ScanServerRefTabletFile)obj;
        return Objects.equals(this.serverAddress, other.serverAddress) && Objects.equals(this.uuid, other.uuid);
    }

    @Override
    public String toString() {
        return "ScanServerRefTabletFile [file=" + this.getPath().toString() + ", server address=" + this.serverAddress + ", server lock uuid=" + this.uuid + "]";
    }
}

