/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SeekingFilter
extends WrappingIterator {
    private static final Logger log = LoggerFactory.getLogger(SeekingFilter.class);
    protected static final String NEGATE = "negate";
    private Collection<ByteSequence> columnFamilies;
    private boolean inclusive;
    private Range seekRange;
    private boolean negate;
    private AdvanceResult advance;
    private boolean advancedPastSeek = false;

    public abstract FilterResult filter(Key var1, Value var2);

    public abstract Key getNextKeyHint(Key var1, Value var2);

    @Override
    public void next() throws IOException {
        this.advanceSource(this.getSource(), this.advance);
        this.findTop();
    }

    @Override
    public boolean hasTop() {
        return !this.advancedPastSeek && super.hasTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
        this.advance = null;
        this.columnFamilies = columnFamilies;
        this.inclusive = inclusive;
        this.seekRange = range;
        this.advancedPastSeek = false;
        this.findTop();
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.negate = Boolean.parseBoolean(options.get(NEGATE));
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        SeekingFilter newInstance;
        try {
            newInstance = (SeekingFilter)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.setSource(this.getSource().deepCopy(env));
        newInstance.negate = this.negate;
        return newInstance;
    }

    protected void findTop() throws IOException {
        SortedKeyValueIterator<Key, Value> src = this.getSource();
        this.advance = null;
        while (src.hasTop() && !this.advancedPastSeek) {
            if (src.getTopKey().isDeleted()) {
                this.advance = AdvanceResult.NEXT;
                return;
            }
            FilterResult f = this.filter(src.getTopKey(), src.getTopValue());
            if (log.isTraceEnabled()) {
                log.trace("Filtered: {} result == {} hint == {}", new Object[]{src.getTopKey(), f, f.advance == AdvanceResult.USE_HINT ? this.getNextKeyHint(src.getTopKey(), src.getTopValue()) : " (none)"});
            }
            if (f.accept == this.negate) {
                this.advanceSource(src, f.advance);
                continue;
            }
            this.advance = f.advance;
            break;
        }
    }

    private void advanceSource(SortedKeyValueIterator<Key, Value> src, AdvanceResult adv) throws IOException {
        Key topKey = src.getTopKey();
        Range advRange = null;
        switch (adv) {
            case NEXT: {
                src.next();
                return;
            }
            case NEXT_CQ: {
                advRange = new Range(topKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL), null);
                break;
            }
            case NEXT_CF: {
                advRange = new Range(topKey.followingKey(PartialKey.ROW_COLFAM), null);
                break;
            }
            case NEXT_ROW: {
                advRange = new Range(topKey.followingKey(PartialKey.ROW), null);
                break;
            }
            case USE_HINT: {
                Value topVal = src.getTopValue();
                Key hintKey = this.getNextKeyHint(topKey, topVal);
                if (hintKey != null && hintKey.compareTo(topKey) > 0) {
                    advRange = new Range(hintKey, null);
                    break;
                }
                String msg = "Filter returned USE_HINT for " + topKey + " but invalid hint: " + hintKey;
                throw new IOException(msg);
            }
        }
        if (advRange == null) {
            throw new IOException("Unable to determine range to advance to for AdvanceResult " + adv);
        }
        if ((advRange = advRange.clip(this.seekRange, true)) == null) {
            this.advancedPastSeek = true;
        } else {
            src.seek(advRange, this.columnFamilies, this.inclusive);
        }
    }

    public static enum AdvanceResult {
        NEXT,
        NEXT_CQ,
        NEXT_CF,
        NEXT_ROW,
        USE_HINT;

    }

    public static class FilterResult {
        private static final EnumMap<AdvanceResult, FilterResult> PASSES = new EnumMap(AdvanceResult.class);
        private static final EnumMap<AdvanceResult, FilterResult> FAILS = new EnumMap(AdvanceResult.class);
        final boolean accept;
        final AdvanceResult advance;

        public FilterResult(boolean accept, AdvanceResult advance) {
            this.accept = accept;
            this.advance = advance;
        }

        public static FilterResult of(boolean accept, AdvanceResult advance) {
            return accept ? PASSES.get((Object)advance) : FAILS.get((Object)advance);
        }

        public String toString() {
            return "Acc: " + this.accept + " Adv: " + this.advance;
        }

        static {
            for (AdvanceResult ar : AdvanceResult.values()) {
                PASSES.put(ar, new FilterResult(true, ar));
                FAILS.put(ar, new FilterResult(false, ar));
            }
        }
    }
}

