/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.gc;

import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.gc.Reference;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;

public class ReferenceFile
implements Reference,
Comparable<ReferenceFile> {
    public final TableId tableId;
    public final boolean isScan;
    public final boolean isDirectory;
    protected final String metadataEntry;

    protected ReferenceFile(TableId tableId, String metadataEntry, boolean isScan, boolean isDirectory) {
        this.tableId = Objects.requireNonNull(tableId);
        this.metadataEntry = Objects.requireNonNull(metadataEntry);
        this.isScan = isScan;
        this.isDirectory = isDirectory;
    }

    public static ReferenceFile forFile(TableId tableId, String metadataEntry) {
        return new ReferenceFile(tableId, metadataEntry, false, false);
    }

    public static ReferenceFile forScan(TableId tableId, String metadataEntry) {
        return new ReferenceFile(tableId, metadataEntry, true, false);
    }

    public static ReferenceFile forDirectory(TableId tableId, String dirName) {
        MetadataSchema.TabletsSection.ServerColumnFamily.validateDirCol(dirName);
        return new ReferenceFile(tableId, dirName, false, true);
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isScan() {
        return this.isScan;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getMetadataEntry() {
        return this.metadataEntry;
    }

    @Override
    public int compareTo(ReferenceFile that) {
        if (this.equals(that)) {
            return 0;
        }
        return this.metadataEntry.compareTo(that.metadataEntry);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceFile other = (ReferenceFile)obj;
        return this.metadataEntry.equals(other.metadataEntry);
    }

    public int hashCode() {
        return this.metadataEntry.hashCode();
    }

    public String toString() {
        return "Reference [id=" + this.tableId + ", ref=" + this.metadataEntry + "]";
    }
}

