/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.sample.Sampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.NoSuchMetaStoreException;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.blockfile.impl.CacheProvider;
import org.apache.accumulo.core.file.rfile.BlockIndex;
import org.apache.accumulo.core.file.rfile.KeyShortener;
import org.apache.accumulo.core.file.rfile.MetricsGatherer;
import org.apache.accumulo.core.file.rfile.MultiIndexIterator;
import org.apache.accumulo.core.file.rfile.MultiLevelIndex;
import org.apache.accumulo.core.file.rfile.RelativeKey;
import org.apache.accumulo.core.file.rfile.RollingStats;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockDoesNotExist;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.HeapIterator;
import org.apache.accumulo.core.iteratorsImpl.system.InterruptibleIterator;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.iteratorsImpl.system.LocalityGroupIterator;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.util.MutableByteSequence;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFile {
    public static final String EXTENSION = "rf";
    private static final Logger log = LoggerFactory.getLogger(RFile.class);
    private static final int RINDEX_MAGIC = 543388788;
    static final int RINDEX_VER_8 = 8;
    static final int RINDEX_VER_7 = 7;
    static final int RINDEX_VER_6 = 6;
    static final int RINDEX_VER_4 = 4;
    static final int RINDEX_VER_3 = 3;
    private static int sampleBufferSize = 10000000;

    private RFile() {
    }

    @VisibleForTesting
    public static void setSampleBufferSize(int bufferSize) {
        sampleBufferSize = bufferSize;
    }

    public static class Reader
    extends HeapIterator
    implements FileSKVIterator {
        private final CachableBlockFile.Reader reader;
        private final ArrayList<LocalityGroupMetadata> localityGroups = new ArrayList();
        private final ArrayList<LocalityGroupMetadata> sampleGroups = new ArrayList();
        private final LocalityGroupReader[] currentReaders;
        private final LocalityGroupReader[] readers;
        private final LocalityGroupReader[] sampleReaders;
        private final LocalityGroupIterator.LocalityGroupContext lgContext;
        private LocalityGroupIterator.LocalityGroupSeekCache lgCache;
        private List<Reader> deepCopies;
        private boolean deepCopy = false;
        private AtomicBoolean interruptFlag;
        private SamplerConfigurationImpl samplerConfig = null;
        private int rfileVersion;

        public Reader(CachableBlockFile.Reader rdr) throws IOException {
            this.reader = rdr;
            try (CachableBlockFile.CachedBlockRead mb = this.reader.getMetaBlock("RFile.index");){
                LocalityGroupMetadata lgm;
                int i;
                int ver;
                int magic = mb.readInt();
                this.rfileVersion = ver = mb.readInt();
                if (magic != 543388788) {
                    throw new IOException("Did not see expected magic number, saw " + magic);
                }
                if (ver != 8 && ver != 7 && ver != 6 && ver != 4 && ver != 3) {
                    throw new IOException("Did not see expected version, saw " + ver);
                }
                int size = mb.readInt();
                this.currentReaders = new LocalityGroupReader[size];
                this.deepCopies = new LinkedList<Reader>();
                for (i = 0; i < size; ++i) {
                    lgm = new LocalityGroupMetadata(ver, rdr);
                    lgm.readFields(mb);
                    this.localityGroups.add(lgm);
                    this.currentReaders[i] = new LocalityGroupReader(this.reader, lgm, ver);
                }
                this.readers = this.currentReaders;
                if (ver == 8 && mb.readBoolean()) {
                    this.sampleReaders = new LocalityGroupReader[size];
                    for (i = 0; i < size; ++i) {
                        lgm = new LocalityGroupMetadata(ver, rdr);
                        lgm.readFields(mb);
                        this.sampleGroups.add(lgm);
                        this.sampleReaders[i] = new LocalityGroupReader(this.reader, lgm, ver);
                    }
                    this.samplerConfig = new SamplerConfigurationImpl(mb);
                } else {
                    this.sampleReaders = null;
                    this.samplerConfig = null;
                }
            }
            this.lgContext = new LocalityGroupIterator.LocalityGroupContext(this.currentReaders);
            this.createHeap(this.currentReaders.length);
        }

        private Reader(Reader r, LocalityGroupReader[] sampleReaders) {
            super(sampleReaders.length);
            this.reader = r.reader;
            this.currentReaders = new LocalityGroupReader[sampleReaders.length];
            this.deepCopies = r.deepCopies;
            this.deepCopy = false;
            this.readers = r.readers;
            this.sampleReaders = r.sampleReaders;
            this.samplerConfig = r.samplerConfig;
            this.rfileVersion = r.rfileVersion;
            for (int i = 0; i < sampleReaders.length; ++i) {
                this.currentReaders[i] = sampleReaders[i];
                this.currentReaders[i].setInterruptFlag(r.interruptFlag);
            }
            this.lgContext = new LocalityGroupIterator.LocalityGroupContext(this.currentReaders);
        }

        private Reader(Reader r, boolean useSample) {
            super(r.currentReaders.length);
            this.reader = r.reader;
            this.currentReaders = new LocalityGroupReader[r.currentReaders.length];
            this.deepCopies = r.deepCopies;
            this.deepCopy = true;
            this.samplerConfig = r.samplerConfig;
            this.rfileVersion = r.rfileVersion;
            this.readers = r.readers;
            this.sampleReaders = r.sampleReaders;
            for (int i = 0; i < r.readers.length; ++i) {
                if (useSample) {
                    this.currentReaders[i] = new LocalityGroupReader(r.sampleReaders[i]);
                    this.currentReaders[i].setInterruptFlag(r.interruptFlag);
                    continue;
                }
                this.currentReaders[i] = new LocalityGroupReader(r.readers[i]);
                this.currentReaders[i].setInterruptFlag(r.interruptFlag);
            }
            this.lgContext = new LocalityGroupIterator.LocalityGroupContext(this.currentReaders);
        }

        public Reader(CachableBlockFile.CachableBuilder b) throws IOException {
            this(new CachableBlockFile.Reader(b));
        }

        private void closeLocalityGroupReaders() {
            for (LocalityGroupReader lgr : this.currentReaders) {
                try {
                    lgr.close();
                }
                catch (IOException e) {
                    log.warn("Errored out attempting to close LocalityGroupReader.", (Throwable)e);
                }
            }
        }

        @Override
        public void closeDeepCopies() {
            if (this.deepCopy) {
                throw new RuntimeException("Calling closeDeepCopies on a deep copy is not supported");
            }
            for (Reader deepCopy : this.deepCopies) {
                deepCopy.closeLocalityGroupReaders();
            }
            this.deepCopies.clear();
        }

        @Override
        public void close() throws IOException {
            if (this.deepCopy) {
                throw new RuntimeException("Calling close on a deep copy is not supported");
            }
            this.closeDeepCopies();
            this.closeLocalityGroupReaders();
            if (this.sampleReaders != null) {
                for (LocalityGroupReader lgr : this.sampleReaders) {
                    try {
                        lgr.close();
                    }
                    catch (IOException e) {
                        log.warn("Errored out attempting to close LocalityGroupReader.", (Throwable)e);
                    }
                }
            }
            this.reader.close();
        }

        @Override
        public Key getFirstKey() throws IOException {
            if (this.currentReaders.length == 0) {
                return null;
            }
            Key minKey = null;
            for (LocalityGroupReader currentReader : this.currentReaders) {
                if (minKey == null) {
                    minKey = currentReader.getFirstKey();
                    continue;
                }
                Key firstKey = currentReader.getFirstKey();
                if (firstKey == null || firstKey.compareTo(minKey) >= 0) continue;
                minKey = firstKey;
            }
            return minKey;
        }

        @Override
        public Key getLastKey() throws IOException {
            if (this.currentReaders.length == 0) {
                return null;
            }
            Key maxKey = null;
            for (LocalityGroupReader currentReader : this.currentReaders) {
                if (maxKey == null) {
                    maxKey = currentReader.getLastKey();
                    continue;
                }
                Key lastKey = currentReader.getLastKey();
                if (lastKey == null || lastKey.compareTo(maxKey) <= 0) continue;
                maxKey = lastKey;
            }
            return maxKey;
        }

        @Override
        public DataInputStream getMetaStore(String name) throws IOException, NoSuchMetaStoreException {
            try {
                return this.reader.getMetaBlock(name);
            }
            catch (MetaBlockDoesNotExist e) {
                throw new NoSuchMetaStoreException("name = " + name, e);
            }
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            if (env != null && env.isSamplingEnabled()) {
                SamplerConfiguration sc = env.getSamplerConfiguration();
                if (sc == null) {
                    throw new SampleNotPresentException();
                }
                if (this.samplerConfig != null && this.samplerConfig.equals(new SamplerConfigurationImpl(sc))) {
                    Reader copy = new Reader(this, true);
                    copy.setInterruptFlagInternal(this.interruptFlag);
                    this.deepCopies.add(copy);
                    return copy;
                }
                throw new SampleNotPresentException();
            }
            Reader copy = new Reader(this, false);
            copy.setInterruptFlagInternal(this.interruptFlag);
            this.deepCopies.add(copy);
            return copy;
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ArrayList<ByteSequence>> getLocalityGroupCF() {
            HashMap<String, ArrayList<ByteSequence>> cf = new HashMap<String, ArrayList<ByteSequence>>();
            for (LocalityGroupMetadata lcg : this.localityGroups) {
                ArrayList<ByteSequence> setCF;
                if (lcg.columnFamilies == null) {
                    Preconditions.checkState((boolean)lcg.isDefaultLG, (String)"Group %s has null families. Only expect default locality group to have null families.", (Object)lcg.name);
                    setCF = new ArrayList();
                } else {
                    setCF = new ArrayList<ByteSequence>(lcg.columnFamilies.keySet());
                }
                cf.put(lcg.name, setCF);
            }
            return cf;
        }

        public void registerMetrics(MetricsGatherer<?> vmg) {
            vmg.init(this.getLocalityGroupCF());
            for (LocalityGroupReader lgr : this.currentReaders) {
                lgr.registerMetrics(vmg);
            }
            if (this.sampleReaders != null) {
                for (LocalityGroupReader lgr : this.sampleReaders) {
                    lgr.registerMetrics(vmg);
                }
            }
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            this.lgCache = LocalityGroupIterator.seek(this, this.lgContext, range, columnFamilies, inclusive, this.lgCache);
        }

        int getNumLocalityGroupsSeeked() {
            return this.lgCache == null ? 0 : this.lgCache.getNumLGSeeked();
        }

        public FileSKVIterator getIndex() throws IOException {
            ArrayList<Iterator<MultiLevelIndex.IndexEntry>> indexes = new ArrayList<Iterator<MultiLevelIndex.IndexEntry>>();
            for (LocalityGroupReader lgr : this.currentReaders) {
                indexes.add(lgr.getIndex());
            }
            return new MultiIndexIterator(this, indexes);
        }

        @Override
        public FileSKVIterator getSample(SamplerConfigurationImpl sampleConfig) {
            Objects.requireNonNull(sampleConfig);
            if (this.samplerConfig != null && this.samplerConfig.equals(sampleConfig)) {
                Reader copy = new Reader(this, this.sampleReaders);
                copy.setInterruptFlagInternal(this.interruptFlag);
                return copy;
            }
            return null;
        }

        FileSKVIterator getSample() {
            if (this.samplerConfig == null) {
                return null;
            }
            return this.getSample(this.samplerConfig);
        }

        public void printInfo(boolean includeIndexDetails) throws IOException {
            System.out.printf("%-24s : %d\n", "RFile Version", this.rfileVersion);
            System.out.println();
            for (LocalityGroupMetadata lgm : this.localityGroups) {
                lgm.printInfo(false, includeIndexDetails);
            }
            if (!this.sampleGroups.isEmpty()) {
                System.out.println();
                System.out.printf("%-24s :\n", "Sample Configuration");
                System.out.printf("\t%-22s : %s\n", "Sampler class ", this.samplerConfig.getClassName());
                System.out.printf("\t%-22s : %s\n", "Sampler options ", this.samplerConfig.getOptions());
                System.out.println();
                for (LocalityGroupMetadata lgm : this.sampleGroups) {
                    lgm.printInfo(true, includeIndexDetails);
                }
            }
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            if (this.deepCopy) {
                throw new RuntimeException("Calling setInterruptFlag on a deep copy is not supported");
            }
            if (!this.deepCopies.isEmpty()) {
                throw new RuntimeException("Setting interrupt flag after calling deep copy not supported");
            }
            this.setInterruptFlagInternal(flag);
        }

        private void setInterruptFlagInternal(AtomicBoolean flag) {
            this.interruptFlag = flag;
            for (LocalityGroupReader lgr : this.currentReaders) {
                lgr.setInterruptFlag(this.interruptFlag);
            }
        }

        @Override
        public void setCacheProvider(CacheProvider cacheProvider) {
            this.reader.setCacheProvider(cacheProvider);
        }

        @Override
        public long estimateOverlappingEntries(KeyExtent extent) throws IOException {
            long totalEntries = 0L;
            Key startKey = extent.toDataRange().getStartKey();
            block0: for (LocalityGroupReader lgr : this.currentReaders) {
                MultiLevelIndex.Reader.IndexIterator indexIter;
                boolean prevEntryOverlapped = false;
                MultiLevelIndex.Reader.IndexIterator indexIterator = indexIter = startKey == null ? lgr.getIndex() : lgr.index.lookup(startKey);
                while (indexIter.hasNext()) {
                    MultiLevelIndex.IndexEntry indexEntry = (MultiLevelIndex.IndexEntry)indexIter.next();
                    if (extent.contains((BinaryComparable)indexEntry.getKey().getRow())) {
                        totalEntries += (long)indexEntry.getNumEntries();
                        prevEntryOverlapped = true;
                        continue;
                    }
                    if (!prevEntryOverlapped) continue;
                    totalEntries += (long)indexEntry.getNumEntries();
                    prevEntryOverlapped = false;
                    continue block0;
                }
            }
            return totalEntries;
        }
    }

    private static class LocalityGroupReader
    extends LocalityGroupIterator.LocalityGroup
    implements FileSKVIterator {
        private CachableBlockFile.Reader reader;
        private MultiLevelIndex.Reader index;
        private int blockCount;
        private Key firstKey;
        private int startBlock;
        private boolean closed = false;
        private int version;
        private boolean checkRange = true;
        private MultiLevelIndex.Reader.IndexIterator iiter;
        private int entriesLeft;
        private CachableBlockFile.CachedBlockRead currBlock;
        private RelativeKey rk;
        private Value val;
        private Key prevKey = null;
        private Range range = null;
        private boolean hasTop = false;
        private AtomicBoolean interruptFlag;
        private MetricsGatherer<?> metricsGatherer;

        private LocalityGroupReader(CachableBlockFile.Reader reader, LocalityGroupMetadata lgm, int version) {
            super(lgm.columnFamilies, lgm.isDefaultLG);
            this.firstKey = lgm.firstKey;
            this.index = lgm.indexReader;
            this.startBlock = lgm.startBlock;
            this.blockCount = this.index.size();
            this.version = version;
            this.reader = reader;
        }

        public LocalityGroupReader(LocalityGroupReader lgr) {
            super(lgr.columnFamilies, lgr.isDefaultLocalityGroup);
            this.firstKey = lgr.firstKey;
            this.index = lgr.index;
            this.startBlock = lgr.startBlock;
            this.blockCount = lgr.blockCount;
            this.reader = lgr.reader;
            this.version = lgr.version;
        }

        Iterator<MultiLevelIndex.IndexEntry> getIndex() throws IOException {
            return this.index.lookup(new Key());
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.hasTop = false;
            if (this.currBlock != null) {
                this.currBlock.close();
            }
        }

        @Override
        public Key getTopKey() {
            return this.rk.getKey();
        }

        @Override
        public Value getTopValue() {
            return this.val;
        }

        @Override
        public boolean hasTop() {
            return this.hasTop;
        }

        @Override
        public void next() throws IOException {
            try {
                this._next();
            }
            catch (IOException | RuntimeException ioe) {
                this.reset(true);
                throw ioe;
            }
        }

        private void _next() throws IOException {
            if (!this.hasTop) {
                throw new IllegalStateException();
            }
            if (this.entriesLeft == 0) {
                this.currBlock.close();
                if (this.metricsGatherer != null) {
                    this.metricsGatherer.startBlock();
                }
                if (this.iiter.hasNext()) {
                    MultiLevelIndex.IndexEntry indexEntry = this.iiter.next();
                    this.entriesLeft = indexEntry.getNumEntries();
                    this.currBlock = this.getDataBlock(indexEntry);
                    this.checkRange = this.range.afterEndKey(indexEntry.getKey());
                    if (!this.checkRange) {
                        this.hasTop = true;
                    }
                } else {
                    this.rk = null;
                    this.val = null;
                    this.hasTop = false;
                    return;
                }
            }
            this.prevKey = this.rk.getKey();
            this.rk.readFields(this.currBlock);
            this.val.readFields(this.currBlock);
            if (this.metricsGatherer != null) {
                this.metricsGatherer.addMetric(this.rk.getKey(), this.val);
            }
            --this.entriesLeft;
            if (this.checkRange) {
                this.hasTop = !this.range.afterEndKey(this.rk.getKey());
            }
        }

        private CachableBlockFile.CachedBlockRead getDataBlock(MultiLevelIndex.IndexEntry indexEntry) throws IOException {
            if (this.interruptFlag != null && this.interruptFlag.get()) {
                throw new IterationInterruptedException();
            }
            if (this.version == 3 || this.version == 4) {
                return this.reader.getDataBlock(this.startBlock + this.iiter.previousIndex());
            }
            return this.reader.getDataBlock(indexEntry.getOffset(), indexEntry.getCompressedSize(), indexEntry.getRawSize());
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Locality group reader closed");
            }
            if (!columnFamilies.isEmpty() || inclusive) {
                throw new IllegalArgumentException("I do not know how to filter column families");
            }
            if (this.interruptFlag != null && this.interruptFlag.get()) {
                throw new IterationInterruptedException();
            }
            try {
                this._seek(range);
            }
            catch (IOException | RuntimeException ioe) {
                this.reset(true);
                throw ioe;
            }
        }

        private void reset(boolean exceptionThrown) {
            this.rk = null;
            this.hasTop = false;
            if (this.currBlock != null) {
                try {
                    try {
                        this.currBlock.close();
                        if (exceptionThrown) {
                            this.reader.close();
                        }
                    }
                    catch (IOException e) {
                        log.warn("Failed to close block reader", (Throwable)e);
                    }
                }
                finally {
                    this.currBlock = null;
                }
            }
        }

        private void _seek(Range range) throws IOException {
            this.range = range;
            this.checkRange = true;
            if (this.blockCount == 0) {
                this.rk = null;
                return;
            }
            Key startKey = range.getStartKey();
            if (startKey == null) {
                startKey = new Key();
            }
            boolean reseek = true;
            if (range.afterEndKey(this.firstKey)) {
                this.reset(false);
                reseek = false;
            }
            if (this.rk != null) {
                if (range.beforeStartKey(this.prevKey) && range.afterEndKey(this.getTopKey())) {
                    reseek = false;
                }
                if (startKey.compareTo(this.getTopKey()) <= 0 && startKey.compareTo(this.prevKey) > 0) {
                    reseek = false;
                }
                if (this.entriesLeft > 0 && startKey.compareTo(this.getTopKey()) >= 0 && startKey.compareTo(this.iiter.peekPrevious().getKey()) <= 0) {
                    MutableByteSequence valbs = new MutableByteSequence(new byte[64], 0, 0);
                    RelativeKey.SkippR skippr = RelativeKey.fastSkip(this.currBlock, startKey, valbs, this.prevKey, this.getTopKey(), this.entriesLeft);
                    if (skippr.skipped > 0) {
                        this.entriesLeft -= skippr.skipped;
                        this.val = new Value(valbs.toArray());
                        this.prevKey = skippr.prevKey;
                        this.rk = skippr.rk;
                    }
                    reseek = false;
                }
                if (this.entriesLeft == 0 && startKey.compareTo(this.getTopKey()) > 0 && startKey.compareTo(this.iiter.peekPrevious().getKey()) <= 0) {
                    reseek = false;
                }
                if (this.iiter.previousIndex() == 0 && this.getTopKey().equals(this.firstKey) && startKey.compareTo(this.firstKey) <= 0) {
                    reseek = false;
                }
            }
            if (reseek) {
                this.iiter = this.index.lookup(startKey);
                this.reset(false);
                if (this.iiter.hasNext()) {
                    BlockIndex.BlockIndexEntry bie;
                    BlockIndex blockIndex;
                    while (this.iiter.hasPrevious() && this.iiter.peekPrevious().getKey().equals(this.iiter.peek().getKey())) {
                        this.iiter.previous();
                    }
                    this.prevKey = this.iiter.hasPrevious() ? new Key(this.iiter.peekPrevious().getKey()) : new Key();
                    MultiLevelIndex.IndexEntry indexEntry = this.iiter.next();
                    this.entriesLeft = indexEntry.getNumEntries();
                    this.currBlock = this.getDataBlock(indexEntry);
                    this.checkRange = range.afterEndKey(indexEntry.getKey());
                    if (!this.checkRange) {
                        this.hasTop = true;
                    }
                    MutableByteSequence valbs = new MutableByteSequence(new byte[64], 0, 0);
                    Key currKey = null;
                    if (this.currBlock.isIndexable() && (blockIndex = BlockIndex.getIndex(this.currBlock, indexEntry)) != null && (bie = blockIndex.seekBlock(startKey, this.currBlock)) != null) {
                        RelativeKey tmpRk = new RelativeKey();
                        tmpRk.setPrevKey(bie.getPrevKey());
                        tmpRk.readFields(this.currBlock);
                        this.val = new Value();
                        this.val.readFields(this.currBlock);
                        valbs = new MutableByteSequence(this.val.get(), 0, this.val.getSize());
                        this.entriesLeft = bie.getEntriesLeft() - 1;
                        this.prevKey = new Key(bie.getPrevKey());
                        currKey = tmpRk.getKey();
                    }
                    RelativeKey.SkippR skippr = RelativeKey.fastSkip(this.currBlock, startKey, valbs, this.prevKey, currKey, this.entriesLeft);
                    this.prevKey = skippr.prevKey;
                    this.entriesLeft -= skippr.skipped;
                    this.val = new Value(valbs.toArray());
                    this.rk = skippr.rk;
                }
            }
            boolean bl = this.hasTop = this.rk != null && !range.afterEndKey(this.rk.getKey());
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
            if (this.metricsGatherer != null) {
                this.metricsGatherer.startLocalityGroup(this.rk.getKey().getColumnFamily());
                this.metricsGatherer.addMetric(this.rk.getKey(), this.val);
            }
        }

        @Override
        public Key getFirstKey() {
            return this.firstKey;
        }

        @Override
        public Key getLastKey() {
            if (this.index.size() == 0) {
                return null;
            }
            return this.index.getLastKey();
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void closeDeepCopies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataInputStream getMetaStore(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setInterruptFlag(AtomicBoolean flag) {
            this.interruptFlag = flag;
        }

        @Override
        public InterruptibleIterator getIterator() {
            return this;
        }

        public void registerMetrics(MetricsGatherer<?> vmg) {
            this.metricsGatherer = vmg;
        }

        @Override
        public FileSKVIterator getSample(SamplerConfigurationImpl sampleConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCacheProvider(CacheProvider cacheProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long estimateOverlappingEntries(KeyExtent extent) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class Writer
    implements FileSKVWriter {
        public static final int MAX_CF_IN_DLG = 1000;
        private static final double MAX_BLOCK_MULTIPLIER = 1.1;
        private BCFile.Writer fileWriter;
        private final long blockSize;
        private final long maxBlockSize;
        private final int indexBlockSize;
        private ArrayList<LocalityGroupMetadata> localityGroups = new ArrayList();
        private ArrayList<LocalityGroupMetadata> sampleGroups = new ArrayList();
        private LocalityGroupMetadata currentLocalityGroup = null;
        private LocalityGroupMetadata sampleLocalityGroup = null;
        private boolean dataClosed = false;
        private boolean closed = false;
        private boolean startedDefaultLocalityGroup = false;
        private HashSet<ByteSequence> previousColumnFamilies;
        private long length = -1L;
        private LocalityGroupWriter lgWriter;
        private SamplerConfigurationImpl samplerConfig;
        private Sampler sampler;

        public Writer(BCFile.Writer bfw, int blockSize) throws IOException {
            this(bfw, blockSize, (int)DefaultConfiguration.getInstance().getAsBytes(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX), null, null);
        }

        public Writer(BCFile.Writer bfw, int blockSize, int indexBlockSize, SamplerConfigurationImpl samplerConfig, Sampler sampler) {
            this.blockSize = blockSize;
            this.maxBlockSize = (long)((double)blockSize * 1.1);
            this.indexBlockSize = indexBlockSize;
            this.fileWriter = bfw;
            this.previousColumnFamilies = new HashSet();
            this.samplerConfig = samplerConfig;
            this.sampler = sampler;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closeData();
            BCFile.Writer.BlockAppender mba = this.fileWriter.prepareMetaBlock("RFile.index");
            mba.writeInt(543388788);
            mba.writeInt(8);
            if (this.currentLocalityGroup != null) {
                this.localityGroups.add(this.currentLocalityGroup);
                this.sampleGroups.add(this.sampleLocalityGroup);
            }
            mba.writeInt(this.localityGroups.size());
            for (LocalityGroupMetadata lc : this.localityGroups) {
                lc.write(mba);
            }
            if (this.samplerConfig == null) {
                mba.writeBoolean(false);
            } else {
                mba.writeBoolean(true);
                for (LocalityGroupMetadata lc : this.sampleGroups) {
                    lc.write(mba);
                }
                this.samplerConfig.write(mba);
            }
            mba.close();
            this.fileWriter.close();
            this.length = this.fileWriter.getLength();
            this.closed = true;
        }

        private void closeData() throws IOException {
            if (this.dataClosed) {
                return;
            }
            this.dataClosed = true;
            if (this.lgWriter != null) {
                this.lgWriter.close();
            }
        }

        @Override
        public void append(Key key, Value value) throws IOException {
            if (this.dataClosed) {
                throw new IllegalStateException("Cannot append, data closed");
            }
            this.lgWriter.append(key, value);
        }

        @Override
        public DataOutputStream createMetaStore(String name) throws IOException {
            this.closeData();
            return this.fileWriter.prepareMetaBlock(name);
        }

        private void _startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
            if (this.dataClosed) {
                throw new IllegalStateException("data closed");
            }
            if (this.startedDefaultLocalityGroup) {
                throw new IllegalStateException("Can not start anymore new locality groups after default locality group started");
            }
            if (this.lgWriter != null) {
                this.lgWriter.close();
            }
            if (this.currentLocalityGroup != null) {
                this.localityGroups.add(this.currentLocalityGroup);
                this.sampleGroups.add(this.sampleLocalityGroup);
            }
            if (columnFamilies == null) {
                this.startedDefaultLocalityGroup = true;
                this.currentLocalityGroup = new LocalityGroupMetadata(this.previousColumnFamilies, this.indexBlockSize, this.fileWriter);
                this.sampleLocalityGroup = new LocalityGroupMetadata(this.previousColumnFamilies, this.indexBlockSize, this.fileWriter);
            } else {
                if (!Collections.disjoint(columnFamilies, this.previousColumnFamilies)) {
                    HashSet<ByteSequence> overlap = new HashSet<ByteSequence>(columnFamilies);
                    overlap.retainAll(this.previousColumnFamilies);
                    throw new IllegalArgumentException("Column families over lap with previous locality group : " + overlap);
                }
                this.currentLocalityGroup = new LocalityGroupMetadata(name, columnFamilies, this.indexBlockSize, this.fileWriter);
                this.sampleLocalityGroup = new LocalityGroupMetadata(name, columnFamilies, this.indexBlockSize, this.fileWriter);
                this.previousColumnFamilies.addAll(columnFamilies);
            }
            SampleLocalityGroupWriter sampleWriter = null;
            if (this.sampler != null) {
                sampleWriter = new SampleLocalityGroupWriter(new LocalityGroupWriter(this.fileWriter, this.blockSize, this.maxBlockSize, this.sampleLocalityGroup, null), this.sampler);
            }
            this.lgWriter = new LocalityGroupWriter(this.fileWriter, this.blockSize, this.maxBlockSize, this.currentLocalityGroup, sampleWriter);
        }

        @Override
        public void startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
            if (columnFamilies == null) {
                throw new NullPointerException();
            }
            this._startNewLocalityGroup(name, columnFamilies);
        }

        @Override
        public void startDefaultLocalityGroup() throws IOException {
            this._startNewLocalityGroup(null, null);
        }

        @Override
        public boolean supportsLocalityGroups() {
            return true;
        }

        @Override
        public long getLength() {
            if (!this.closed) {
                return this.fileWriter.getLength();
            }
            return this.length;
        }
    }

    private static class LocalityGroupWriter {
        private BCFile.Writer fileWriter;
        private BCFile.Writer.BlockAppender blockWriter;
        private final long blockSize;
        private final long maxBlockSize;
        private int entries = 0;
        private LocalityGroupMetadata currentLocalityGroup = null;
        private Key lastKeyInBlock = null;
        private Key prevKey = new Key();
        private SampleLocalityGroupWriter sample;
        private RollingStats keyLenStats = new RollingStats(2017);
        private double averageKeySize = 0.0;

        LocalityGroupWriter(BCFile.Writer fileWriter, long blockSize, long maxBlockSize, LocalityGroupMetadata currentLocalityGroup, SampleLocalityGroupWriter sample) {
            this.fileWriter = fileWriter;
            this.blockSize = blockSize;
            this.maxBlockSize = maxBlockSize;
            this.currentLocalityGroup = currentLocalityGroup;
            this.sample = sample;
        }

        private boolean isGiantKey(Key k) {
            double mean = this.keyLenStats.getMean();
            double stddev = this.keyLenStats.getStandardDeviation();
            return (double)k.getSize() > mean + Math.max(9.0 * mean, 4.0 * stddev);
        }

        public void append(Key key, Value value) throws IOException {
            if (key.compareTo(this.prevKey) < 0) {
                throw new IllegalArgumentException("Keys appended out-of-order.  New key " + key + ", previous key " + this.prevKey);
            }
            this.currentLocalityGroup.updateColumnCount(key);
            if (this.currentLocalityGroup.getFirstKey() == null) {
                this.currentLocalityGroup.setFirstKey(key);
            }
            if (this.sample != null) {
                this.sample.append(key, value);
            }
            if (this.blockWriter == null) {
                this.blockWriter = this.fileWriter.prepareDataBlock();
            } else if (this.blockWriter.getRawSize() > this.blockSize) {
                Key closeKey;
                if (this.averageKeySize == 0.0) {
                    this.averageKeySize = this.keyLenStats.getMean();
                }
                if (((double)(closeKey = KeyShortener.shorten(this.prevKey, key)).getSize() <= this.averageKeySize || this.blockWriter.getRawSize() > this.maxBlockSize) && !this.isGiantKey(closeKey)) {
                    this.closeBlock(closeKey, false);
                    this.blockWriter = this.fileWriter.prepareDataBlock();
                    this.averageKeySize = 0.0;
                } else if ((long)key.getSize() + (long)value.getSize() + this.blockWriter.getRawSize() + 128L >= Integer.MAX_VALUE) {
                    this.closeBlock(closeKey, false);
                    this.blockWriter = this.fileWriter.prepareDataBlock();
                    this.averageKeySize = 0.0;
                }
            }
            RelativeKey rk = new RelativeKey(this.lastKeyInBlock, key);
            rk.write(this.blockWriter);
            value.write(this.blockWriter);
            ++this.entries;
            this.keyLenStats.addValue(key.getSize());
            this.lastKeyInBlock = this.prevKey = new Key(key);
        }

        private void closeBlock(Key key, boolean lastBlock) throws IOException {
            this.blockWriter.close();
            if (lastBlock) {
                this.currentLocalityGroup.indexWriter.addLast(key, this.entries, this.blockWriter.getStartPos(), this.blockWriter.getCompressedSize(), this.blockWriter.getRawSize());
            } else {
                this.currentLocalityGroup.indexWriter.add(key, this.entries, this.blockWriter.getStartPos(), this.blockWriter.getCompressedSize(), this.blockWriter.getRawSize());
            }
            if (this.sample != null) {
                this.sample.flushIfNeeded();
            }
            this.blockWriter = null;
            this.lastKeyInBlock = null;
            this.entries = 0;
        }

        public void close() throws IOException {
            if (this.blockWriter != null) {
                this.closeBlock(this.lastKeyInBlock, true);
            }
            if (this.sample != null) {
                this.sample.close();
            }
        }
    }

    private static class SampleLocalityGroupWriter {
        private Sampler sampler;
        private List<SampleEntry> entries = new ArrayList<SampleEntry>();
        private long dataSize = 0L;
        private LocalityGroupWriter lgw;

        public SampleLocalityGroupWriter(LocalityGroupWriter lgw, Sampler sampler) {
            this.lgw = lgw;
            this.sampler = sampler;
        }

        public void append(Key key, Value value) {
            if (this.sampler.accept(key)) {
                this.entries.add(new SampleEntry(key, value));
                this.dataSize += (long)(key.getSize() + value.getSize());
            }
        }

        public void close() throws IOException {
            for (SampleEntry se : this.entries) {
                this.lgw.append(se.key, se.val);
            }
            this.lgw.close();
        }

        public void flushIfNeeded() throws IOException {
            List<SampleEntry> subList;
            if (this.dataSize > (long)sampleBufferSize && !(subList = this.entries.subList(0, this.entries.size() - 1)).isEmpty()) {
                for (SampleEntry se : subList) {
                    this.lgw.append(se.key, se.val);
                }
                this.lgw.closeBlock(subList.get((int)(subList.size() - 1)).key, false);
                subList.clear();
                this.dataSize = 0L;
            }
        }
    }

    private static class SampleEntry {
        Key key;
        Value val;

        SampleEntry(Key key, Value val) {
            this.key = new Key(key);
            this.val = new Value(val);
        }
    }

    private static class LocalityGroupMetadata
    implements Writable {
        private int startBlock = -1;
        private Key firstKey;
        private Map<ByteSequence, MutableLong> columnFamilies;
        private boolean isDefaultLG = false;
        private String name;
        private Set<ByteSequence> previousColumnFamilies;
        private MultiLevelIndex.BufferedWriter indexWriter;
        private MultiLevelIndex.Reader indexReader;
        private int version;

        public LocalityGroupMetadata(int version, CachableBlockFile.Reader br) {
            this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
            this.indexReader = new MultiLevelIndex.Reader(br, version);
            this.version = version;
        }

        public LocalityGroupMetadata(Set<ByteSequence> pcf, int indexBlockSize, BCFile.Writer bfw) {
            this.isDefaultLG = true;
            this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
            this.previousColumnFamilies = pcf;
            this.indexWriter = new MultiLevelIndex.BufferedWriter(new MultiLevelIndex.Writer(bfw, indexBlockSize));
        }

        public LocalityGroupMetadata(String name, Set<ByteSequence> cfset, int indexBlockSize, BCFile.Writer bfw) {
            this.name = name;
            this.isDefaultLG = false;
            this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
            for (ByteSequence cf : cfset) {
                this.columnFamilies.put(cf, new MutableLong(0L));
            }
            this.indexWriter = new MultiLevelIndex.BufferedWriter(new MultiLevelIndex.Writer(bfw, indexBlockSize));
        }

        private Key getFirstKey() {
            return this.firstKey;
        }

        private void setFirstKey(Key key) {
            if (this.firstKey != null) {
                throw new IllegalStateException();
            }
            this.firstKey = new Key(key);
        }

        public void updateColumnCount(Key key) {
            if (this.isDefaultLG && this.columnFamilies == null) {
                ByteSequence cf;
                if (!this.previousColumnFamilies.isEmpty() && this.previousColumnFamilies.contains(cf = key.getColumnFamilyData())) {
                    throw new IllegalArgumentException("Added column family \"" + cf + "\" to default locality group that was in previous locality group");
                }
                return;
            }
            ByteSequence cf = key.getColumnFamilyData();
            MutableLong count = this.columnFamilies.get(cf);
            if (count == null) {
                if (!this.isDefaultLG) {
                    throw new IllegalArgumentException("invalid column family : " + cf);
                }
                if (this.previousColumnFamilies.contains(cf)) {
                    throw new IllegalArgumentException("Added column family \"" + cf + "\" to default locality group that was in previous locality group");
                }
                if (this.columnFamilies.size() > 1000) {
                    this.columnFamilies = null;
                    return;
                }
                count = new MutableLong(0L);
                this.columnFamilies.put(new ArrayByteSequence(cf.getBackingArray(), cf.offset(), cf.length()), count);
            }
            count.increment();
        }

        public void readFields(DataInput in) throws IOException {
            int size;
            this.isDefaultLG = in.readBoolean();
            if (!this.isDefaultLG) {
                this.name = in.readUTF();
            }
            if (this.version == 3 || this.version == 4 || this.version == 6 || this.version == 7) {
                this.startBlock = in.readInt();
            }
            if ((size = in.readInt()) == -1) {
                if (!this.isDefaultLG) {
                    throw new IllegalStateException("Non default LG " + this.name + " does not have column families");
                }
                this.columnFamilies = null;
            } else {
                if (this.columnFamilies == null) {
                    this.columnFamilies = new HashMap<ByteSequence, MutableLong>();
                } else {
                    this.columnFamilies.clear();
                }
                for (int i = 0; i < size; ++i) {
                    int len = in.readInt();
                    byte[] cf = new byte[len];
                    in.readFully(cf);
                    long count = in.readLong();
                    this.columnFamilies.put(new ArrayByteSequence(cf), new MutableLong(count));
                }
            }
            if (in.readBoolean()) {
                this.firstKey = new Key();
                this.firstKey.readFields(in);
            } else {
                this.firstKey = null;
            }
            this.indexReader.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isDefaultLG);
            if (!this.isDefaultLG) {
                out.writeUTF(this.name);
            }
            if (this.isDefaultLG && this.columnFamilies == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.columnFamilies.size());
                for (Map.Entry<ByteSequence, MutableLong> entry : this.columnFamilies.entrySet()) {
                    out.writeInt(entry.getKey().length());
                    out.write(entry.getKey().getBackingArray(), entry.getKey().offset(), entry.getKey().length());
                    out.writeLong(entry.getValue().longValue());
                }
            }
            out.writeBoolean(this.firstKey != null);
            if (this.firstKey != null) {
                this.firstKey.write(out);
            }
            this.indexWriter.close(out);
        }

        public void printInfo(boolean isSample, boolean includeIndexDetails) throws IOException {
            PrintStream out = System.out;
            out.printf("%-24s : %s\n", (isSample ? "Sample " : "") + "Locality group ", this.isDefaultLG ? "<DEFAULT>" : this.name);
            if (this.version == 3 || this.version == 4 || this.version == 6 || this.version == 7) {
                out.printf("\t%-22s : %d\n", "Start block", this.startBlock);
            }
            out.printf("\t%-22s : %,d\n", "Num   blocks", this.indexReader.size());
            TreeMap<Integer, Long> sizesByLevel = new TreeMap<Integer, Long>();
            TreeMap<Integer, Long> countsByLevel = new TreeMap<Integer, Long>();
            this.indexReader.getIndexInfo(sizesByLevel, countsByLevel);
            for (Map.Entry entry : sizesByLevel.descendingMap().entrySet()) {
                out.printf("\t%-22s : %,d bytes  %,d blocks\n", "Index level " + entry.getKey(), entry.getValue(), countsByLevel.get(entry.getKey()));
            }
            out.printf("\t%-22s : %s\n", "First key", this.firstKey);
            Key lastKey = null;
            if (this.indexReader.size() > 0) {
                lastKey = this.indexReader.getLastKey();
            }
            out.printf("\t%-22s : %s\n", "Last key", lastKey);
            long numKeys = 0L;
            MultiLevelIndex.Reader.IndexIterator countIter = this.indexReader.lookup(new Key());
            while (countIter.hasNext()) {
                MultiLevelIndex.IndexEntry indexEntry = countIter.next();
                numKeys += (long)indexEntry.getNumEntries();
            }
            out.printf("\t%-22s : %,d\n", "Num entries", numKeys);
            out.printf("\t%-22s : %s\n", "Column families", this.isDefaultLG && this.columnFamilies == null ? "<UNKNOWN>" : this.columnFamilies.keySet());
            if (includeIndexDetails) {
                out.printf("\t%-22s :\nIndex Entries", lastKey);
                String prefix = "\t   ";
                this.indexReader.printIndex(prefix, out);
            }
        }
    }
}

