/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.lru;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheConfiguration;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheType;

public final class LruBlockCacheConfiguration {
    public static final String PROPERTY_PREFIX = "lru";
    public static final Float DEFAULT_LOAD_FACTOR = Float.valueOf(0.75f);
    public static final Integer DEFAULT_CONCURRENCY_LEVEL = 16;
    public static final Float DEFAULT_MIN_FACTOR = Float.valueOf(0.75f);
    public static final Float DEFAULT_ACCEPTABLE_FACTOR = Float.valueOf(0.85f);
    public static final Float DEFAULT_SINGLE_FACTOR = Float.valueOf(0.25f);
    public static final Float DEFAULT_MULTI_FACTOR = Float.valueOf(0.5f);
    public static final Float DEFAULT_MEMORY_FACTOR = Float.valueOf(0.25f);
    public static final String ACCEPTABLE_FACTOR_PROPERTY = "acceptable.factor";
    public static final String MIN_FACTOR_PROPERTY = "min.factor";
    public static final String SINGLE_FACTOR_PROPERTY = "single.factor";
    public static final String MULTI_FACTOR_PROPERTY = "multi.factor";
    public static final String MEMORY_FACTOR_PROPERTY = "memory.factor";
    public static final String MAP_LOAD_PROPERTY = "map.load";
    public static final String MAP_CONCURRENCY_PROPERTY = "map.concurrency";
    public static final String EVICTION_THREAD_PROPERTY = "eviction.thread";
    private final float acceptableFactor;
    private final float minFactor;
    private final float singleFactor;
    private final float multiFactor;
    private final float memoryFactor;
    private final float mapLoadFactor;
    private final int mapConcurrencyLevel;
    private final boolean useEvictionThread;
    private final BlockCacheManager.Configuration conf;
    private final Map<String, String> props;
    private final CacheType type;

    private Optional<String> get(String k) {
        return Optional.ofNullable(this.props.get(k));
    }

    public LruBlockCacheConfiguration(BlockCacheManager.Configuration conf, CacheType type) {
        this.type = type;
        this.conf = conf;
        this.props = conf.getProperties(PROPERTY_PREFIX, type);
        this.acceptableFactor = this.get(ACCEPTABLE_FACTOR_PROPERTY).map(Float::valueOf).filter(f -> f.floatValue() > 0.0f).orElse(DEFAULT_ACCEPTABLE_FACTOR).floatValue();
        this.minFactor = this.get(MIN_FACTOR_PROPERTY).map(Float::valueOf).filter(f -> f.floatValue() > 0.0f).orElse(DEFAULT_MIN_FACTOR).floatValue();
        this.singleFactor = this.get(SINGLE_FACTOR_PROPERTY).map(Float::valueOf).filter(f -> f.floatValue() > 0.0f).orElse(DEFAULT_SINGLE_FACTOR).floatValue();
        this.multiFactor = this.get(MULTI_FACTOR_PROPERTY).map(Float::valueOf).filter(f -> f.floatValue() > 0.0f).orElse(DEFAULT_MULTI_FACTOR).floatValue();
        this.memoryFactor = this.get(MEMORY_FACTOR_PROPERTY).map(Float::valueOf).filter(f -> f.floatValue() > 0.0f).orElse(DEFAULT_MEMORY_FACTOR).floatValue();
        this.mapLoadFactor = this.get(MAP_LOAD_PROPERTY).map(Float::valueOf).filter(f -> f.floatValue() > 0.0f).orElse(DEFAULT_LOAD_FACTOR).floatValue();
        this.mapConcurrencyLevel = this.get(MAP_CONCURRENCY_PROPERTY).map(Integer::valueOf).filter(i -> i > 0).orElse(DEFAULT_CONCURRENCY_LEVEL);
        this.useEvictionThread = this.get(EVICTION_THREAD_PROPERTY).map(Boolean::valueOf).orElse(true);
        if (this.getSingleFactor() + this.getMultiFactor() + this.getMemoryFactor() != 1.0f) {
            throw new IllegalArgumentException("Single, multi, and memory factors should total 1.0");
        }
        if (this.getMinFactor() >= this.getAcceptableFactor()) {
            throw new IllegalArgumentException("minFactor must be smaller than acceptableFactor");
        }
        if (this.getMinFactor() >= 1.0f || this.getAcceptableFactor() >= 1.0f) {
            throw new IllegalArgumentException("all factors must be < 1");
        }
    }

    public float getAcceptableFactor() {
        return this.acceptableFactor;
    }

    public float getMinFactor() {
        return this.minFactor;
    }

    public float getSingleFactor() {
        return this.singleFactor;
    }

    public float getMultiFactor() {
        return this.multiFactor;
    }

    public float getMemoryFactor() {
        return this.memoryFactor;
    }

    public float getMapLoadFactor() {
        return this.mapLoadFactor;
    }

    public int getMapConcurrencyLevel() {
        return this.mapConcurrencyLevel;
    }

    public boolean isUseEvictionThread() {
        return this.useEvictionThread;
    }

    public static Builder builder(Property serverPrefix, CacheType ct) {
        return new Builder(BlockCacheConfiguration.getFullyQualifiedPropertyPrefix(serverPrefix, PROPERTY_PREFIX, ct));
    }

    public String toString() {
        return super.toString() + ", acceptableFactor: " + this.getAcceptableFactor() + ", minFactor: " + this.getMinFactor() + ", singleFactor: " + this.getSingleFactor() + ", multiFactor: " + this.getMultiFactor() + ", memoryFactor: " + this.getMemoryFactor() + ", mapLoadFactor: " + this.getMapLoadFactor() + ", mapConcurrencyLevel: " + this.getMapConcurrencyLevel() + ", useEvictionThread: " + this.isUseEvictionThread();
    }

    public long getMaxSize() {
        return this.conf.getMaxSize(this.type);
    }

    public CacheType getCacheType() {
        return this.type;
    }

    public long getBlockSize() {
        return this.conf.getBlockSize();
    }

    public static class Builder {
        private Map<String, String> props = new HashMap<String, String>();
        private String prefix;

        private Builder(String prefix) {
            this.prefix = prefix;
        }

        private void set(String prop, float val) {
            this.props.put(this.prefix + prop, Float.toString(val));
        }

        public Builder acceptableFactor(float af) {
            Preconditions.checkArgument((af > 0.0f ? 1 : 0) != 0);
            this.set(LruBlockCacheConfiguration.ACCEPTABLE_FACTOR_PROPERTY, af);
            return this;
        }

        public Builder minFactor(float mf) {
            Preconditions.checkArgument((mf > 0.0f ? 1 : 0) != 0);
            this.set(LruBlockCacheConfiguration.MIN_FACTOR_PROPERTY, mf);
            return this;
        }

        public Builder singleFactor(float sf) {
            Preconditions.checkArgument((sf > 0.0f ? 1 : 0) != 0);
            this.set(LruBlockCacheConfiguration.SINGLE_FACTOR_PROPERTY, sf);
            return this;
        }

        public Builder multiFactor(float mf) {
            Preconditions.checkArgument((mf > 0.0f ? 1 : 0) != 0);
            this.set(LruBlockCacheConfiguration.MULTI_FACTOR_PROPERTY, mf);
            return this;
        }

        public Builder memoryFactor(float mf) {
            Preconditions.checkArgument((mf > 0.0f ? 1 : 0) != 0);
            this.set(LruBlockCacheConfiguration.MEMORY_FACTOR_PROPERTY, mf);
            return this;
        }

        public Builder mapLoadFactor(float mlf) {
            Preconditions.checkArgument((mlf > 0.0f ? 1 : 0) != 0);
            this.set(LruBlockCacheConfiguration.MAP_LOAD_PROPERTY, mlf);
            return this;
        }

        public Builder mapConcurrencyLevel(int mcl) {
            Preconditions.checkArgument((mcl > 0 ? 1 : 0) != 0);
            this.props.put(this.prefix + LruBlockCacheConfiguration.MAP_CONCURRENCY_PROPERTY, "" + mcl);
            return this;
        }

        public Builder useEvictionThread(boolean uet) {
            this.props.put(this.prefix + LruBlockCacheConfiguration.EVICTION_THREAD_PROPERTY, "" + uet);
            return this;
        }

        public Map<String, String> buildMap() {
            return Map.copyOf(this.props);
        }
    }
}

