/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.fate.AcceptableException;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.StackOverflowException;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.logging.FateLogger;
import org.apache.accumulo.core.util.ShutdownUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.thrift.TApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fate<T> {
    private static final Logger log = LoggerFactory.getLogger(Fate.class);
    private final Logger runnerLog = LoggerFactory.getLogger(TransactionRunner.class);
    private final TStore<T> store;
    private final T environment;
    private ScheduledThreadPoolExecutor fatePoolWatcher;
    private ExecutorService executor;
    private static final EnumSet<ReadOnlyTStore.TStatus> FINISHED_STATES = EnumSet.of(ReadOnlyTStore.TStatus.FAILED, ReadOnlyTStore.TStatus.SUCCESSFUL, ReadOnlyTStore.TStatus.UNKNOWN);
    private final AtomicBoolean keepRunning = new AtomicBoolean(true);

    protected long executeIsReady(Long tid, Repo<T> op) throws Exception {
        return op.isReady(tid, this.environment);
    }

    protected Repo<T> executeCall(Long tid, Repo<T> op) throws Exception {
        return op.call(tid, this.environment);
    }

    public Fate(T environment, TStore<T> store, Function<Repo<T>, String> toLogStrFunc) {
        this.store = FateLogger.wrap(store, toLogStrFunc);
        this.environment = environment;
    }

    public void startTransactionRunners(AccumuloConfiguration conf) {
        ThreadPoolExecutor pool = ThreadPools.getServerThreadPools().createExecutorService(conf, Property.MANAGER_FATE_THREADPOOL_SIZE, true);
        this.fatePoolWatcher = ThreadPools.getServerThreadPools().createGeneralScheduledExecutorService(conf);
        ThreadPools.watchCriticalScheduledTask(this.fatePoolWatcher.schedule(() -> {
            ThreadPools.resizePool(pool, conf, Property.MANAGER_FATE_THREADPOOL_SIZE);
            int needed = conf.getCount(Property.MANAGER_FATE_THREADPOOL_SIZE) - pool.getQueue().size();
            if (needed > 0) {
                for (int i = 0; i < needed; ++i) {
                    try {
                        pool.execute(new TransactionRunner());
                        continue;
                    }
                    catch (RejectedExecutionException e) {
                        if (pool.isShutdown()) {
                            log.trace("Error adding transaction runner to FaTE executor pool.", (Throwable)e);
                            break;
                        }
                        log.error("Error adding transaction runner to FaTE executor pool.", (Throwable)e);
                        break;
                    }
                }
            }
        }, 3L, TimeUnit.SECONDS));
        this.executor = pool;
    }

    public long startTransaction() {
        return this.store.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedTransaction(String txName, long tid, Repo<T> repo, boolean autoCleanUp, String goalMessage) {
        block7: {
            this.store.reserve(tid);
            try {
                if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.NEW) break block7;
                if (this.store.top(tid) == null) {
                    try {
                        log.info("Seeding {} {}", (Object)FateTxId.formatTid(tid), (Object)goalMessage);
                        this.store.push(tid, repo);
                    }
                    catch (StackOverflowException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (autoCleanUp) {
                    this.store.setTransactionInfo(tid, TxInfo.AUTO_CLEAN, Boolean.valueOf(autoCleanUp));
                }
                this.store.setTransactionInfo(tid, TxInfo.TX_NAME, (Serializable)((Object)txName));
                this.store.setStatus(tid, ReadOnlyTStore.TStatus.SUBMITTED);
            }
            finally {
                this.store.unreserve(tid, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public ReadOnlyTStore.TStatus waitForCompletion(long tid) {
        return this.store.waitForStatusChange(tid, FINISHED_STATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(long tid) {
        String tidStr = FateTxId.formatTid(tid);
        for (int retries = 0; retries < 5; ++retries) {
            if (this.store.tryReserve(tid)) {
                try {
                    ReadOnlyTStore.TStatus status = this.store.getStatus(tid);
                    log.info("status is: {}", (Object)status);
                    if (status == ReadOnlyTStore.TStatus.NEW || status == ReadOnlyTStore.TStatus.SUBMITTED) {
                        this.store.setTransactionInfo(tid, TxInfo.EXCEPTION, (Serializable)((Object)new TApplicationException(6, "Fate transaction cancelled by user")));
                        this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS);
                        log.info("Updated status for {} to FAILED_IN_PROGRESS because it was cancelled by user", (Object)tidStr);
                        boolean bl = true;
                        return bl;
                    }
                    log.info("{} cancelled by user but already in progress or finished state", (Object)tidStr);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.store.unreserve(tid, 0L, TimeUnit.MILLISECONDS);
                }
            }
            UtilWaitThread.sleep(500L);
        }
        log.info("Unable to reserve transaction {} to cancel it", (Object)tid);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(long tid) {
        this.store.reserve(tid);
        try {
            switch (this.store.getStatus(tid)) {
                case NEW: 
                case SUBMITTED: 
                case FAILED: 
                case SUCCESSFUL: {
                    this.store.delete(tid);
                    return;
                }
                case FAILED_IN_PROGRESS: 
                case IN_PROGRESS: {
                    throw new IllegalStateException("Can not delete in progress transaction " + FateTxId.formatTid(tid));
                }
            }
            return;
        }
        finally {
            this.store.unreserve(tid, 0L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReturn(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.SUCCESSFUL) {
                throw new IllegalStateException("Tried to get exception when transaction " + FateTxId.formatTid(tid) + " not in successful state");
            }
            String string = (String)((Object)this.store.getTransactionInfo(tid, TxInfo.RETURN_VALUE));
            return string;
        }
        finally {
            this.store.unreserve(tid, 0L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getException(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.FAILED) {
                throw new IllegalStateException("Tried to get exception when transaction " + FateTxId.formatTid(tid) + " not in failed state");
            }
            Exception exception = (Exception)this.store.getTransactionInfo(tid, TxInfo.EXCEPTION);
            return exception;
        }
        finally {
            this.store.unreserve(tid, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        this.keepRunning.set(false);
        this.fatePoolWatcher.shutdown();
        this.executor.shutdown();
    }

    private class TransactionRunner
    implements Runnable {
        private TransactionRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (Fate.this.keepRunning.get()) {
                long deferTime = 0L;
                Long tid = null;
                try {
                    tid = Fate.this.store.reserve();
                    ReadOnlyTStore.TStatus status = Fate.this.store.getStatus(tid);
                    Repo op = Fate.this.store.top(tid);
                    if (status == ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS) {
                        this.processFailed(tid, op);
                        continue;
                    }
                    Repo prevOp = null;
                    try {
                        deferTime = op.isReady(tid, Fate.this.environment);
                        if (deferTime != 0L) continue;
                        prevOp = op;
                        if (status == ReadOnlyTStore.TStatus.SUBMITTED) {
                            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.IN_PROGRESS);
                        }
                        op = op.call(tid, Fate.this.environment);
                    }
                    catch (Exception e) {
                        this.blockIfHadoopShutdown(tid, e);
                        this.transitionToFailed(tid, e);
                        continue;
                    }
                    if (op == null) {
                        String ret = prevOp.getReturn();
                        if (ret != null) {
                            Fate.this.store.setTransactionInfo(tid, TxInfo.RETURN_VALUE, (Serializable)((Object)ret));
                        }
                        Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.SUCCESSFUL);
                        this.doCleanUp(tid);
                        continue;
                    }
                    try {
                        Fate.this.store.push(tid, op);
                    }
                    catch (StackOverflowException e) {
                        this.transitionToFailed(tid, e);
                        if (tid == null) continue;
                        Fate.this.store.unreserve(tid, deferTime, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e) {
                    Fate.this.runnerLog.error("Uncaught exception in FATE runner thread.", (Throwable)e);
                }
                finally {
                    if (tid == null) continue;
                    Fate.this.store.unreserve(tid, deferTime, TimeUnit.MILLISECONDS);
                }
            }
        }

        private void blockIfHadoopShutdown(long tid, Exception e) {
            if (ShutdownUtil.isShutdownInProgress()) {
                String tidStr = FateTxId.formatTid(tid);
                if (e instanceof AcceptableException) {
                    log.debug("Ignoring exception possibly caused by Hadoop Shutdown hook. {} ", (Object)tidStr, (Object)e);
                } else if (ShutdownUtil.isIOException(e)) {
                    log.info("Ignoring exception likely caused by Hadoop Shutdown hook. {} ", (Object)tidStr, (Object)e);
                } else {
                    log.warn("Ignoring exception possibly caused by Hadoop Shutdown hook. {} ", (Object)tidStr, (Object)e);
                }
                while (true) {
                    UtilWaitThread.sleepUninterruptibly(1L, TimeUnit.MINUTES);
                }
            }
        }

        private void transitionToFailed(long tid, Exception e) {
            String tidStr = FateTxId.formatTid(tid);
            String msg = "Failed to execute Repo " + tidStr;
            if (e instanceof AcceptableException) {
                AcceptableThriftTableOperationException tableOpEx = (AcceptableThriftTableOperationException)((Object)e);
                log.debug(msg + " for {}({}) {}", new Object[]{tableOpEx.getTableName(), tableOpEx.getTableId(), tableOpEx.getDescription()});
            } else {
                log.warn(msg, (Throwable)e);
            }
            Fate.this.store.setTransactionInfo(tid, TxInfo.EXCEPTION, e);
            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS);
            log.info("Updated status for Repo with {} to FAILED_IN_PROGRESS", (Object)tidStr);
        }

        private void processFailed(long tid, Repo<T> op) {
            while (op != null) {
                this.undo(tid, (Repo)op);
                Fate.this.store.pop(tid);
                op = Fate.this.store.top(tid);
            }
            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED);
            this.doCleanUp(tid);
        }

        private void doCleanUp(long tid) {
            Boolean autoClean = (Boolean)Fate.this.store.getTransactionInfo(tid, TxInfo.AUTO_CLEAN);
            if (autoClean != null && autoClean.booleanValue()) {
                Fate.this.store.delete(tid);
            } else {
                while (Fate.this.store.top(tid) != null) {
                    Fate.this.store.pop(tid);
                }
            }
        }

        private void undo(long tid, Repo<T> op) {
            try {
                op.undo(tid, Fate.this.environment);
            }
            catch (Exception e) {
                log.warn("Failed to undo Repo, " + FateTxId.formatTid(tid), (Throwable)e);
            }
        }
    }

    public static enum TxInfo {
        TX_NAME,
        AUTO_CLEAN,
        EXCEPTION,
        RETURN_VALUE;

    }
}

