/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigCheckUtil;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.DeprecatedPropertyUtil;
import org.apache.accumulo.core.conf.HadoopCredentialProvider;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteConfiguration
extends AccumuloConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SiteConfiguration.class);
    private static final AccumuloConfiguration parent = DefaultConfiguration.getInstance();
    private final Map<String, String> config;

    public static OverridesOption fromEnv() {
        return new Builder().fromEnv();
    }

    public static OverridesOption fromFile(File propertiesFileLocation) {
        return new Builder().fromFile(propertiesFileLocation);
    }

    public static OverridesOption empty() {
        return new Builder().noFile();
    }

    public static SiteConfiguration auto() {
        return new Builder().fromEnv().build();
    }

    private SiteConfiguration(Map<String, String> config) {
        ConfigCheckUtil.validate(config.entrySet(), "site config");
        this.config = config;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="url is specified by an admin, not unchecked user input")
    private static AbstractConfiguration getPropsFileConfig(URL accumuloPropsLocation) {
        PropertiesConfiguration config = new PropertiesConfiguration();
        if (accumuloPropsLocation != null) {
            try (InputStreamReader reader = new InputStreamReader(accumuloPropsLocation.openStream(), StandardCharsets.UTF_8);){
                config.read((Reader)reader);
            }
            catch (IOException | ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return config;
    }

    private static void loadCredProviderProps(String provider, Map<String, String> props) {
        org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
        HadoopCredentialProvider.setPath(hadoopConf, provider);
        Stream.of(Property.values()).filter(Property::isSensitive).forEach(p -> {
            char[] value = HadoopCredentialProvider.getValue(hadoopConf, p.getKey());
            if (value != null) {
                props.put(p.getKey(), new String(value));
            }
        });
    }

    @Override
    public String get(Property property) {
        String value = this.config.get(property.getKey());
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error("Using default value for {} due to improperly formatted {}: {}", new Object[]{property.getKey(), property.getType(), value});
            }
            value = parent.get(property);
        }
        return value;
    }

    @Override
    public boolean isPropertySet(Property prop) {
        return this.config.containsKey(prop.getKey()) || parent.isPropertySet(prop);
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.getProperties(props, filter, true);
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter, boolean useDefaults) {
        if (useDefaults) {
            parent.getProperties(props, filter);
        }
        this.config.keySet().forEach(k -> {
            if (filter.test((String)k)) {
                props.put((String)k, this.config.get(k));
            }
        });
    }

    @Override
    public AccumuloConfiguration getParent() {
        return parent;
    }

    static class Builder
    implements OverridesOption,
    Buildable {
        private URL url = null;
        private Map<String, String> overrides = Collections.emptyMap();

        Builder() {
        }

        private OverridesOption noFile() {
            return this;
        }

        OverridesOption fromUrl(URL propertiesFileUrl) {
            this.url = Objects.requireNonNull(propertiesFileUrl);
            return this;
        }

        public OverridesOption fromEnv() {
            URL siteUrl = SiteConfiguration.class.getClassLoader().getResource("accumulo-site.xml");
            if (siteUrl != null) {
                throw new IllegalArgumentException("Found deprecated config file 'accumulo-site.xml' on classpath. Since 2.0.0, this file was replaced by 'accumulo.properties'. Run the following command to convert an old 'accumulo-site.xml' file to the new format: accumulo convert-config -x /old/accumulo-site.xml -p /new/accumulo.properties");
            }
            String configFile = System.getProperty("accumulo.properties", "accumulo.properties");
            if (configFile.startsWith("file://")) {
                File f;
                try {
                    f = new File(new URI(configFile));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Failed to load Accumulo configuration from " + configFile, e);
                }
                if (f.exists() && !f.isDirectory()) {
                    log.info("Found Accumulo configuration at {}", (Object)configFile);
                    return this.fromFile(f);
                }
                throw new IllegalArgumentException("Failed to load Accumulo configuration at " + configFile);
            }
            URL accumuloConfigUrl = SiteConfiguration.class.getClassLoader().getResource(configFile);
            if (accumuloConfigUrl == null) {
                throw new IllegalArgumentException("Failed to load Accumulo configuration '" + configFile + "' from classpath");
            }
            log.info("Found Accumulo configuration on classpath at {}", (Object)accumuloConfigUrl.getFile());
            this.url = accumuloConfigUrl;
            return this;
        }

        public OverridesOption fromFile(File propertiesFileLocation) {
            try {
                this.url = Objects.requireNonNull(propertiesFileLocation).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
            return this;
        }

        @Override
        public Buildable withOverrides(Map<String, String> overrides) {
            this.overrides = Objects.requireNonNull(overrides);
            return this;
        }

        @Override
        public SiteConfiguration build() {
            AbstractConfiguration propsFileConfig = SiteConfiguration.getPropsFileConfig(this.url);
            MapConfiguration overrideConfig = new MapConfiguration(this.overrides);
            HashMap<String, String> credProviderProps = new HashMap<String, String>();
            for (AbstractConfiguration c : new AbstractConfiguration[]{propsFileConfig, overrideConfig}) {
                String credProvider = c.getString(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey());
                if (credProvider == null || credProvider.isEmpty()) continue;
                SiteConfiguration.loadCredProviderProps(credProvider, credProviderProps);
                break;
            }
            MapConfiguration credProviderConfig = new MapConfiguration(credProviderProps);
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)credProviderConfig);
            config.addConfiguration((Configuration)overrideConfig);
            config.addConfiguration((Configuration)propsFileConfig);
            DeprecatedPropertyUtil.sanityCheckManagerProperties((AbstractConfiguration)config);
            HashMap result = new HashMap();
            config.getKeys().forEachRemaining(orig -> {
                String resolved = DeprecatedPropertyUtil.getReplacementName(orig, (log, replacement) -> log.warn("{} has been deprecated and will be removed in a future release; loading its replacement {} instead.", orig, replacement));
                result.put(resolved, config.getString(orig));
            });
            return new SiteConfiguration(Collections.unmodifiableMap(result));
        }
    }

    public static interface OverridesOption
    extends Buildable {
        public Buildable withOverrides(Map<String, String> var1);
    }

    public static interface Buildable {
        public SiteConfiguration build();
    }
}

