/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.CloneConfiguration;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.FindMax;
import org.apache.accumulo.core.client.admin.ImportConfiguration;
import org.apache.accumulo.core.client.admin.Locations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.SummaryRetriever;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.admin.compaction.CompactionConfigurer;
import org.apache.accumulo.core.client.admin.compaction.CompactionSelector;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.clientImpl.AccumuloBulkMergeException;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.CompactionStrategyConfigUtil;
import org.apache.accumulo.core.clientImpl.TableOperationsHelper;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;
import org.apache.accumulo.core.clientImpl.bulk.BulkImport;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.TDiskUsage;
import org.apache.accumulo.core.clientImpl.thrift.TVersionedProperties;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.TRowRange;
import org.apache.accumulo.core.dataImpl.thrift.TSummaries;
import org.apache.accumulo.core.dataImpl.thrift.TSummarizerConfiguration;
import org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.FateOperation;
import org.apache.accumulo.core.manager.thrift.FateService;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.metadata.MetadataServicer;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.summary.SummarizerConfigurationUtil;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.Validators;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOperationsImpl
extends TableOperationsHelper {
    private static final SecureRandom random = new SecureRandom();
    public static final String PROPERTY_EXCLUDE_PREFIX = "!";
    public static final String COMPACTION_CANCELED_MSG = "Compaction canceled";
    public static final String TABLE_DELETED_MSG = "Table is being deleted";
    private static final Logger log = LoggerFactory.getLogger(TableOperations.class);
    private final ClientContext context;

    public TableOperationsImpl(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
    }

    @Override
    public SortedSet<String> list() {
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Fetching list of tables...", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        TreeSet<String> tableNames = new TreeSet<String>(this.context.getTableNameToIdMap().keySet());
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Fetched {} table names in {}", new Object[]{Thread.currentThread().getId(), tableNames.size(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        return tableNames;
    }

    @Override
    public boolean exists(String tableName) {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        if (tableName.equals(MetadataTable.NAME) || tableName.equals(RootTable.NAME)) {
            return true;
        }
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Checking if table {} exists...", (Object)Thread.currentThread().getId(), (Object)tableName);
            timer = new OpTimer().start();
        }
        boolean exists = this.context.getTableNameToIdMap().containsKey(tableName);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Checked existence of {} in {}", new Object[]{Thread.currentThread().getId(), exists, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        return exists;
    }

    @Override
    public void create(String tableName) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, new NewTableConfiguration());
    }

    @Override
    public void create(String tableName, NewTableConfiguration ntc) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        Validators.NEW_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((ntc != null ? 1 : 0) != 0, (Object)"ntc is null");
        ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>();
        args.add(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)));
        args.add(ByteBuffer.wrap(ntc.getTimeType().name().getBytes(StandardCharsets.UTF_8)));
        args.add(ByteBuffer.wrap(ntc.getInitialTableState().name().getBytes(StandardCharsets.UTF_8)));
        int numSplits = ntc.getSplits().size();
        args.add(ByteBuffer.wrap(String.valueOf(numSplits).getBytes(StandardCharsets.UTF_8)));
        if (numSplits > 0) {
            for (Text t : ntc.getSplits()) {
                args.add(TextUtil.getByteBuffer(t));
            }
        }
        Map<String, String> opts = ntc.getProperties();
        try {
            this.doTableFateOperation(tableName, AccumuloException.class, FateOperation.TABLE_CREATE, args, opts);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long beginFateOperation() throws ThriftSecurityException, TException {
        while (true) {
            FateService.Client client = null;
            try {
                client = (FateService.Client)ThriftClientTypes.FATE.getConnectionWithRetry(this.context);
                long l = client.beginFateOperation(TraceUtil.traceInfo(), this.context.rpcCreds());
                return l;
            }
            catch (TTransportException tte) {
                log.debug("Failed to call beginFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftNotActiveServiceException e) {
                log.debug("Contacted a Manager which is no longer active, retrying");
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            finally {
                ThriftUtil.close(client, this.context);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFateOperation(long opid, FateOperation op, List<ByteBuffer> args, Map<String, String> opts, boolean autoCleanUp) throws ThriftSecurityException, TException, ThriftTableOperationException {
        while (true) {
            FateService.Client client = null;
            try {
                client = (FateService.Client)ThriftClientTypes.FATE.getConnectionWithRetry(this.context);
                client.executeFateOperation(TraceUtil.traceInfo(), this.context.rpcCreds(), opid, op, args, opts, autoCleanUp);
                return;
            }
            catch (TTransportException tte) {
                log.debug("Failed to call executeFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftNotActiveServiceException e) {
                log.debug("Contacted a Manager which is no longer active, retrying");
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            finally {
                ThriftUtil.close(client, this.context);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForFateOperation(long opid) throws ThriftSecurityException, TException, ThriftTableOperationException {
        while (true) {
            FateService.Client client = null;
            try {
                client = (FateService.Client)ThriftClientTypes.FATE.getConnectionWithRetry(this.context);
                String string = client.waitForFateOperation(TraceUtil.traceInfo(), this.context.rpcCreds(), opid);
                return string;
            }
            catch (TTransportException tte) {
                log.debug("Failed to call waitForFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftNotActiveServiceException e) {
                log.debug("Contacted a Manager which is no longer active, retrying");
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            finally {
                ThriftUtil.close(client, this.context);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishFateOperation(long opid) throws ThriftSecurityException, TException {
        while (true) {
            FateService.Client client = null;
            try {
                client = (FateService.Client)ThriftClientTypes.FATE.getConnectionWithRetry(this.context);
                client.finishFateOperation(TraceUtil.traceInfo(), this.context.rpcCreds(), opid);
            }
            catch (TTransportException tte) {
                log.debug("Failed to call finishFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftNotActiveServiceException e) {
                log.debug("Contacted a Manager which is no longer active, retrying");
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            finally {
                ThriftUtil.close(client, this.context);
                continue;
            }
            break;
        }
    }

    public String doBulkFateOperation(List<ByteBuffer> args, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        try {
            return this.doFateOperation(FateOperation.TABLE_BULK_IMPORT2, args, Collections.emptyMap(), tableName);
        }
        catch (NamespaceExistsException | TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (NamespaceNotFoundException ne) {
            throw new TableNotFoundException(null, tableName, "Namespace not found", ne);
        }
    }

    String doFateOperation(FateOperation op, List<ByteBuffer> args, Map<String, String> opts, String tableOrNamespaceName) throws AccumuloSecurityException, TableExistsException, TableNotFoundException, AccumuloException, NamespaceExistsException, NamespaceNotFoundException {
        return this.doFateOperation(op, args, opts, tableOrNamespaceName, true);
    }

    String doFateOperation(FateOperation op, List<ByteBuffer> args, Map<String, String> opts, String tableOrNamespaceName, boolean wait) throws AccumuloSecurityException, TableExistsException, TableNotFoundException, AccumuloException, NamespaceExistsException, NamespaceNotFoundException {
        Long opid = null;
        try {
            opid = this.beginFateOperation();
            this.executeFateOperation(opid, op, args, opts, !wait);
            if (!wait) {
                opid = null;
                String string = null;
                return string;
            }
            String string = this.waitForFateOperation(opid);
            return string;
        }
        catch (ThriftSecurityException e) {
            switch (e.getCode()) {
                case TABLE_DOESNT_EXIST: {
                    throw new TableNotFoundException(null, tableOrNamespaceName, "Target table does not exist");
                }
                case NAMESPACE_DOESNT_EXIST: {
                    throw new NamespaceNotFoundException(null, tableOrNamespaceName, "Target namespace does not exist");
                }
            }
            String tableInfo = this.context.getPrintableTableInfoFromName(tableOrNamespaceName);
            throw new AccumuloSecurityException(e.user, e.code, tableInfo, (Throwable)((Object)e));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case EXISTS: {
                    throw new TableExistsException(e);
                }
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
                case NAMESPACE_EXISTS: {
                    throw new NamespaceExistsException(e);
                }
                case NAMESPACE_NOTFOUND: {
                    throw new NamespaceNotFoundException(e);
                }
                case OFFLINE: {
                    throw new TableOfflineException(e.getTableId() == null ? null : TableId.of(e.getTableId()), tableOrNamespaceName);
                }
                case BULK_CONCURRENT_MERGE: {
                    throw new AccumuloBulkMergeException((Throwable)((Object)e));
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AccumuloException(e.getMessage(), e);
        }
        finally {
            this.context.clearTableListCache();
            if (opid != null) {
                try {
                    this.finishFateOperation(opid);
                }
                catch (Exception e) {
                    log.warn("Exception thrown while finishing fate table operation", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void addSplits(String tableName, SortedSet<Text> partitionKeys) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        TableId tableId = this.context.getTableId(tableName);
        ArrayList<Text> splits = new ArrayList<Text>(partitionKeys);
        Collections.sort(splits);
        CountDownLatch latch = new CountDownLatch(splits.size());
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        ThreadPoolExecutor executor = this.context.threadPools().getPoolBuilder(ThreadPoolNames.SPLIT_POOL).numCoreThreads(16).build();
        try {
            executor.execute(new SplitTask(new SplitEnv(tableName, tableId, executor, latch, exception), splits));
            while (!latch.await(100L, TimeUnit.MILLISECONDS)) {
                if (exception.get() == null) continue;
                executor.shutdownNow();
                Throwable excep = exception.get();
                if (excep instanceof TableNotFoundException) {
                    TableNotFoundException tnfe = (TableNotFoundException)excep;
                    throw new TableNotFoundException(tableId.canonical(), tableName, "Table not found by background thread", tnfe);
                }
                if (excep instanceof TableOfflineException) {
                    log.debug("TableOfflineException occurred in background thread. Throwing new exception", excep);
                    throw new TableOfflineException(tableId, tableName);
                }
                if (excep instanceof AccumuloSecurityException) {
                    AccumuloSecurityException base = (AccumuloSecurityException)excep;
                    throw new AccumuloSecurityException(base.getUser(), base.asThriftException().getCode(), base.getTableInfo(), excep);
                }
                if (excep instanceof AccumuloServerException) {
                    throw new AccumuloServerException((AccumuloServerException)excep);
                }
                if (excep instanceof Error) {
                    throw new Error(excep);
                }
                throw new AccumuloException(excep);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSplits(SplitEnv env, SortedSet<Text> partitionKeys) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, AccumuloServerException {
        TabletLocator tabLocator = TabletLocator.getLocator(this.context, env.tableId);
        for (Text split : partitionKeys) {
            boolean successful = false;
            int attempt = 0;
            long locationFailures = 0L;
            while (!successful) {
                block14: {
                    if (attempt > 0) {
                        UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    }
                    ++attempt;
                    TabletLocator.TabletLocation tl = tabLocator.locateTablet(this.context, split, false, false);
                    if (tl == null) {
                        this.context.requireTableExists(env.tableId, env.tableName);
                        this.context.requireNotOffline(env.tableId, env.tableName);
                        continue;
                    }
                    HostAndPort address = HostAndPort.fromString(tl.tablet_location);
                    try {
                        TabletClientService.Client client = ThriftUtil.getClient(ThriftClientTypes.TABLET_SERVER, address, this.context);
                        try {
                            OpTimer timer = null;
                            if (log.isTraceEnabled()) {
                                log.trace("tid={} Splitting tablet {} on {} at {}", new Object[]{Thread.currentThread().getId(), tl.tablet_extent, address, split});
                                timer = new OpTimer().start();
                            }
                            client.splitTablet(TraceUtil.traceInfo(), this.context.rpcCreds(), tl.tablet_extent.toThrift(), TextUtil.getByteBuffer(split));
                            tabLocator.invalidateCache(tl.tablet_extent);
                            if (timer == null) break block14;
                            timer.stop();
                            log.trace("Split tablet in {}", (Object)String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)));
                        }
                        finally {
                            ThriftUtil.returnClient(client, this.context);
                        }
                    }
                    catch (TApplicationException tae) {
                        throw new AccumuloServerException(address.toString(), tae);
                    }
                    catch (ThriftSecurityException e) {
                        this.context.clearTableListCache();
                        this.context.requireTableExists(env.tableId, env.tableName);
                        throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                    }
                    catch (NotServingTabletException e) {
                        if (++locationFailures == 5L || locationFailures % 50L == 0L) {
                            log.warn("Having difficulty locating hosting tabletserver for split {} on table {}. Seen {} failures.", new Object[]{split, env.tableName, locationFailures});
                        }
                        tabLocator.invalidateCache(tl.tablet_extent);
                        continue;
                    }
                    catch (TException e) {
                        tabLocator.invalidateCache(this.context, tl.tablet_location);
                        continue;
                    }
                }
                successful = true;
            }
        }
    }

    @Override
    public void merge(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_MERGE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void deleteRows(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_DELETE_RANGE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Collection<Text> listSplits(String tableName) throws TableNotFoundException, AccumuloSecurityException {
        return this._listSplits(tableName);
    }

    private List<Text> _listSplits(String tableName) throws TableNotFoundException, AccumuloSecurityException {
        TableId tableId = this.context.getTableId(tableName);
        TreeMap<KeyExtent, String> tabletLocations = new TreeMap<KeyExtent, String>();
        while (true) {
            try {
                tabletLocations.clear();
                MetadataServicer.forTableId(this.context, tableId).getTabletLocations(tabletLocations);
            }
            catch (AccumuloSecurityException ase) {
                throw ase;
            }
            catch (Exception e) {
                this.context.requireTableExists(tableId, tableName);
                if (e instanceof RuntimeException && e.getCause() instanceof AccumuloSecurityException) {
                    throw (AccumuloSecurityException)e.getCause();
                }
                log.info("{} ... retrying ...", (Object)e, (Object)e);
                UtilWaitThread.sleepUninterruptibly(3L, TimeUnit.SECONDS);
                continue;
            }
            break;
        }
        ArrayList<Text> endRows = new ArrayList<Text>(tabletLocations.size());
        for (KeyExtent ke : tabletLocations.keySet()) {
            if (ke.endRow() == null) continue;
            endRows.add(ke.endRow());
        }
        return endRows;
    }

    @Override
    public Collection<Text> listSplits(String tableName, int maxSplits) throws TableNotFoundException, AccumuloSecurityException {
        List<Text> existingSplits = this._listSplits(tableName);
        if (existingSplits.size() <= maxSplits) {
            return existingSplits;
        }
        ArrayList<Text> splitsSubset = new ArrayList<Text>(maxSplits);
        boolean SELECTION_THRESHOLD = true;
        double stepSize = (double)(maxSplits + 1) / (double)existingSplits.size();
        double selectionTrigger = 0.0;
        for (Text existingSplit : existingSplits) {
            if (splitsSubset.size() >= maxSplits) break;
            if (!((selectionTrigger += stepSize) > 1.0)) continue;
            splitsSubset.add(existingSplit);
            selectionTrigger -= 1.0;
        }
        return splitsSubset;
    }

    @Override
    public void delete(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_DELETE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void clone(String srcTableName, String newTableName, boolean flush2, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        this.clone(srcTableName, newTableName, CloneConfiguration.builder().setFlush(flush2).setPropertiesToSet(propertiesToSet).setPropertiesToExclude(propertiesToExclude).setKeepOffline(false).build());
    }

    @Override
    public void clone(String srcTableName, String newTableName, CloneConfiguration config) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        Validators.NEW_TABLE_NAME.validate(newTableName);
        Objects.requireNonNull(config, "CloneConfiguration required.");
        TableId srcTableId = this.context.getTableId(srcTableName);
        if (config.isFlush()) {
            this._flush(srcTableId, null, null, true);
        }
        HashMap<String, String> opts = new HashMap<String, String>();
        this.validatePropertiesToSet(opts, config.getPropertiesToSet());
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(srcTableId.canonical().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(newTableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(Boolean.toString(config.isKeepOffline()).getBytes(StandardCharsets.UTF_8)));
        this.prependPropertiesToExclude(opts, config.getPropertiesToExclude());
        this.doTableFateOperation(newTableName, AccumuloException.class, FateOperation.TABLE_CLONE, args, opts);
    }

    @Override
    public void rename(String oldTableName, String newTableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        Validators.EXISTING_TABLE_NAME.validate(oldTableName);
        Validators.NEW_TABLE_NAME.validate(newTableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(oldTableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(newTableName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        this.doTableFateOperation(oldTableName, TableNotFoundException.class, FateOperation.TABLE_RENAME, args, opts);
    }

    @Override
    public void flush(String tableName) throws AccumuloException, AccumuloSecurityException {
        try {
            this.flush(tableName, null, null, false);
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e.getMessage(), e);
        }
    }

    @Override
    public void flush(String tableName, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        this._flush(this.context.getTableId(tableName), start, end, wait);
    }

    @Override
    public void compact(String tableName, Text start, Text end, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        this.compact(tableName, start, end, new ArrayList<IteratorSetting>(), flush2, wait);
    }

    @Override
    public void compact(String tableName, Text start, Text end, List<IteratorSetting> iterators, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        this.compact(tableName, new CompactionConfig().setStartRow(start).setEndRow(end).setIterators(iterators).setFlush(flush2).setWait(wait));
    }

    @Override
    public void compact(String tableName, CompactionConfig config) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        String skviName = SortedKeyValueIterator.class.getName();
        for (IteratorSetting setting : config.getIterators()) {
            String iteratorClass = setting.getIteratorClass();
            if (this.testClassLoad(tableName, iteratorClass, skviName)) continue;
            throw new AccumuloException("TabletServer could not load iterator class " + iteratorClass);
        }
        this.ensureStrategyCanLoad(tableName, config);
        if (!UserCompactionUtils.isDefault(config.getConfigurer()) && !this.testClassLoad(tableName, config.getConfigurer().getClassName(), CompactionConfigurer.class.getName())) {
            throw new AccumuloException("TabletServer could not load " + CompactionConfigurer.class.getSimpleName() + " class " + config.getConfigurer().getClassName());
        }
        if (!UserCompactionUtils.isDefault(config.getSelector()) && !this.testClassLoad(tableName, config.getSelector().getClassName(), CompactionSelector.class.getName())) {
            throw new AccumuloException("TabletServer could not load " + CompactionSelector.class.getSimpleName() + " class " + config.getSelector().getClassName());
        }
        TableId tableId = this.context.getTableId(tableName);
        Text start = config.getStartRow();
        Text end = config.getEndRow();
        if (config.getFlush()) {
            this._flush(tableId, start, end, true);
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.canonical().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(UserCompactionUtils.encode(config)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doFateOperation(FateOperation.TABLE_COMPACT, args, opts, tableName, config.getWait());
        }
        catch (NamespaceExistsException | TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(null, tableName, "Namespace not found", e);
        }
    }

    private void ensureStrategyCanLoad(String tableName, CompactionConfig config) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        if (!CompactionStrategyConfigUtil.isDefault(config.getCompactionStrategy()) && !this.testClassLoad(tableName, config.getCompactionStrategy().getClassName(), "org.apache.accumulo.tserver.compaction.CompactionStrategy")) {
            throw new AccumuloException("TabletServer could not load CompactionStrategy class " + config.getCompactionStrategy().getClassName());
        }
    }

    @Override
    public void cancelCompaction(String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        TableId tableId = this.context.getTableId(tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.canonical().getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_CANCEL_COMPACT, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _flush(TableId tableId, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            long flushID;
            ManagerClientService.Client client;
            while (true) {
                client = null;
                try {
                    client = (ManagerClientService.Client)ThriftClientTypes.MANAGER.getConnectionWithRetry(this.context);
                    flushID = client.initiateFlush(TraceUtil.traceInfo(), this.context.rpcCreds(), tableId.canonical());
                }
                catch (TTransportException tte) {
                    log.debug("Failed to call initiateFlush, retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (ThriftNotActiveServiceException e) {
                    log.debug("Contacted a Manager which is no longer active, retrying");
                    UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    continue;
                }
                finally {
                    ThriftUtil.close(client, this.context);
                    continue;
                }
                break;
            }
            while (true) {
                client = null;
                try {
                    client = (ManagerClientService.Client)ThriftClientTypes.MANAGER.getConnectionWithRetry(this.context);
                    client.waitForFlush(TraceUtil.traceInfo(), this.context.rpcCreds(), tableId.canonical(), TextUtil.getByteBuffer(start), TextUtil.getByteBuffer(end), flushID, wait ? Long.MAX_VALUE : 1L);
                }
                catch (TTransportException tte) {
                    log.debug("Failed to call initiateFlush, retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (ThriftNotActiveServiceException e) {
                    log.debug("Contacted a Manager which is no longer active, retrying");
                    UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    continue;
                }
                finally {
                    ThriftUtil.close(client, this.context);
                    continue;
                }
                break;
            }
        }
        catch (ThriftSecurityException e) {
            switch (e.getCode()) {
                case TABLE_DOESNT_EXIST: {
                    throw new TableNotFoundException(tableId.canonical(), null, e.getMessage(), (Throwable)((Object)e));
                }
            }
            log.debug("flush security exception on table id {}", (Object)tableId);
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void setProperty(String tableName, String property, String value) throws AccumuloException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        try {
            this.setPropertyNoChecks(tableName, property, value);
            this.checkLocalityGroups(tableName, property);
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e);
        }
    }

    private Map<String, String> tryToModifyProperties(String tableName, Consumer<Map<String, String>> mapMutator) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException, ConcurrentModificationException {
        TVersionedProperties vProperties = ThriftClientTypes.CLIENT.execute(this.context, client -> client.getVersionedTableProperties(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName));
        mapMutator.accept(vProperties.getProperties());
        vProperties.setProperties(Map.copyOf(vProperties.getProperties()));
        try {
            ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.modifyTableProperties(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName, vProperties));
            for (String property : vProperties.getProperties().keySet()) {
                this.checkLocalityGroups(tableName, property);
            }
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e);
        }
        return vProperties.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> modifyProperties(String tableName, Consumer<Map<String, String>> mapMutator) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((mapMutator != null ? 1 : 0) != 0, (Object)"mapMutator is null");
        Retry retry = Retry.builder().infiniteRetries().retryAfter(25L, TimeUnit.MILLISECONDS).incrementBy(25L, TimeUnit.MILLISECONDS).maxWait(30L, TimeUnit.SECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createRetry();
        while (true) {
            try {
                Map<String, String> props = this.tryToModifyProperties(tableName, mapMutator);
                retry.logCompletion(log, "Modifying properties for table " + tableName);
                Map<String, String> map = props;
                return map;
            }
            catch (ConcurrentModificationException cme) {
                try {
                    retry.logRetry(log, "Unable to modify table properties for " + tableName + " because of concurrent modification");
                    retry.waitForNextAttempt(log, "modify table properties for " + tableName);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                retry.useRetry();
                continue;
            }
            break;
        }
    }

    private void setPropertyNoChecks(String tableName, String property, String value) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.setTableProperty(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName, property, value));
    }

    @Override
    public void removeProperty(String tableName, String property) throws AccumuloException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        try {
            this.removePropertyNoChecks(tableName, property);
            this.checkLocalityGroups(tableName, property);
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e);
        }
    }

    private void removePropertyNoChecks(String tableName, String property) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.removeTableProperty(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName, property));
    }

    void checkLocalityGroups(String tableName, String propChanged) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (LocalityGroupUtil.isLocalityGroupProperty(propChanged)) {
            Map<String, String> allProps = this.getConfiguration(tableName);
            try {
                LocalityGroupUtil.checkLocalityGroups(allProps);
            }
            catch (RuntimeException | LocalityGroupUtil.LocalityGroupConfigurationError e) {
                LoggerFactory.getLogger(this.getClass()).warn("Changing '" + propChanged + "' for table '" + tableName + "' resulted in bad locality group config.  This may be a transient situation since the config spreads over multiple properties.  Setting properties in a different order may help.  Even though this warning was displayed, the property was updated. Please check your config to ensure consistency.", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> getConfiguration(String tableName) throws AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        try {
            return ThriftClientTypes.CLIENT.execute(this.context, client -> client.getTableConfiguration(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName));
        }
        catch (AccumuloException e) {
            Throwable t = e.getCause();
            if (t instanceof ThriftTableOperationException) {
                ThriftTableOperationException ttoe = (ThriftTableOperationException)((Object)t);
                switch (ttoe.getType()) {
                    case NOTFOUND: {
                        throw new TableNotFoundException(ttoe);
                    }
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(tableName, new NamespaceNotFoundException(ttoe));
                    }
                }
                throw e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public Map<String, String> getTableProperties(String tableName) throws AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        try {
            return ThriftClientTypes.CLIENT.execute(this.context, client -> client.getTableProperties(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName));
        }
        catch (AccumuloException e) {
            Throwable t = e.getCause();
            if (t instanceof ThriftTableOperationException) {
                ThriftTableOperationException ttoe = (ThriftTableOperationException)((Object)t);
                switch (ttoe.getType()) {
                    case NOTFOUND: {
                        throw new TableNotFoundException(ttoe);
                    }
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(tableName, new NamespaceNotFoundException(ttoe));
                    }
                }
                throw e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void setLocalityGroups(String tableName, Map<String, Set<Text>> groups) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        LocalityGroupUtil.ensureNonOverlappingGroups(groups);
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            Set<Text> colFams = entry.getValue();
            String value = LocalityGroupUtil.encodeColumnFamilies(colFams);
            this.setPropertyNoChecks(tableName, Property.TABLE_LOCALITY_GROUP_PREFIX + entry.getKey(), value);
        }
        try {
            this.setPropertyNoChecks(tableName, Property.TABLE_LOCALITY_GROUPS.getKey(), Joiner.on((String)",").join(groups.keySet()));
        }
        catch (AccumuloException e) {
            if (e.getCause() instanceof TableNotFoundException) {
                throw (TableNotFoundException)e.getCause();
            }
            throw e;
        }
        String prefix = Property.TABLE_LOCALITY_GROUP_PREFIX.getKey();
        for (Map.Entry<String, String> entry : this.getProperties(tableName)) {
            String[] parts;
            String group;
            String property = entry.getKey();
            if (!property.startsWith(prefix) || groups.containsKey(group = (parts = property.split("\\."))[parts.length - 1])) continue;
            this.removePropertyNoChecks(tableName, property);
        }
    }

    @Override
    public Map<String, Set<Text>> getLocalityGroups(String tableName) throws AccumuloException, TableNotFoundException {
        ConfigurationCopy conf = new ConfigurationCopy(this.getProperties(tableName));
        Map<String, Set<ByteSequence>> groups = LocalityGroupUtil.getLocalityGroups(conf);
        HashMap<String, Set<Text>> groups2 = new HashMap<String, Set<Text>>();
        for (Map.Entry<String, Set<ByteSequence>> entry : groups.entrySet()) {
            HashSet<Text> colFams = new HashSet<Text>();
            for (ByteSequence bs : entry.getValue()) {
                colFams.add(new Text(bs.toArray()));
            }
            groups2.put(entry.getKey(), colFams);
        }
        return groups2;
    }

    @Override
    public Set<Range> splitRangeByTablets(String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"range is null");
        if (maxSplits < 1) {
            throw new IllegalArgumentException("maximum splits must be >= 1");
        }
        if (maxSplits == 1) {
            return Collections.singleton(range);
        }
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        TableId tableId = this.context.getTableId(tableName);
        TabletLocator tl = TabletLocator.getLocator(this.context, tableId);
        tl.invalidateCache();
        while (!tl.binRanges(this.context, Collections.singletonList(range), binnedRanges).isEmpty()) {
            this.context.requireNotDeleted(tableId);
            this.context.requireNotOffline(tableId, tableName);
            log.warn("Unable to locate bins for specified range. Retrying.");
            UtilWaitThread.sleepUninterruptibly(100 + random.nextInt(100), TimeUnit.MILLISECONDS);
            binnedRanges.clear();
            tl.invalidateCache();
        }
        LinkedList<Object> unmergedExtents = new LinkedList<Object>();
        ArrayList<Object> mergedExtents = new ArrayList<Object>();
        for (Map map : binnedRanges.values()) {
            unmergedExtents.addAll(map.keySet());
        }
        Collections.sort(unmergedExtents);
        while (unmergedExtents.size() + mergedExtents.size() > maxSplits) {
            if (unmergedExtents.size() >= 2) {
                KeyExtent first = (KeyExtent)unmergedExtents.removeFirst();
                KeyExtent second = (KeyExtent)unmergedExtents.removeFirst();
                KeyExtent keyExtent = new KeyExtent(first.tableId(), second.endRow(), first.prevEndRow());
                mergedExtents.add(keyExtent);
                continue;
            }
            mergedExtents.addAll(unmergedExtents);
            unmergedExtents.clear();
            unmergedExtents.addAll(mergedExtents);
            mergedExtents.clear();
        }
        mergedExtents.addAll(unmergedExtents);
        HashSet<Range> ranges = new HashSet<Range>();
        for (KeyExtent keyExtent : mergedExtents) {
            ranges.add(keyExtent.toDataRange().clip(range));
        }
        return ranges;
    }

    private Path checkPath(String dir, String kind, String type) throws IOException, AccumuloException, AccumuloSecurityException {
        FileStatus[] listStatus;
        FileSystem fs = VolumeConfiguration.fileSystemForPath(dir, this.context.getHadoopConf());
        Path ret = dir.contains(":") ? new Path(dir) : fs.makeQualified(new Path(dir));
        try {
            if (!fs.getFileStatus(ret).isDirectory()) {
                throw new AccumuloException(kind + " import " + type + " directory " + ret + " is not a directory!");
            }
        }
        catch (FileNotFoundException fnf) {
            throw new AccumuloException(kind + " import " + type + " directory " + ret + " does not exist!");
        }
        if (type.equals("failure") && (listStatus = fs.listStatus(ret)) != null && listStatus.length != 0) {
            throw new AccumuloException("Bulk import failure directory " + ret + " is not empty");
        }
        return ret;
    }

    @Override
    @Deprecated(since="2.0.0")
    public void importDirectory(String tableName, String dir, String failureDir, boolean setTime) throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((dir != null ? 1 : 0) != 0, (Object)"dir is null");
        Preconditions.checkArgument((failureDir != null ? 1 : 0) != 0, (Object)"failureDir is null");
        this.context.getTableId(tableName);
        Path dirPath = this.checkPath(dir, "Bulk", "");
        Path failPath = this.checkPath(failureDir, "Bulk", "failure");
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(dirPath.toString().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(failPath.toString().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(("" + setTime).getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_BULK_IMPORT, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void waitForTableStateTransition(TableId tableId, TableState expectedState) throws AccumuloException, TableNotFoundException {
        Text startRow = null;
        Text lastRow = null;
        while (true) {
            long waitTime;
            if (this.context.getTableState(tableId) != expectedState) {
                this.context.clearTableListCache();
                TableState currentState = this.context.getTableState(tableId);
                if (currentState != expectedState) {
                    this.context.requireNotDeleted(tableId);
                    if (currentState == TableState.DELETING) {
                        throw new TableNotFoundException(tableId.canonical(), "", TABLE_DELETED_MSG);
                    }
                    throw new AccumuloException("Unexpected table state " + tableId + " " + currentState + " != " + expectedState);
                }
            }
            Range range = startRow == null || lastRow == null ? new KeyExtent(tableId, null, null).toMetaRange() : new Range(startRow, lastRow);
            TabletsMetadata tablets = TabletsMetadata.builder(this.context).scanMetadataTable().overRange(range).fetch(TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW).build();
            KeyExtent lastExtent = null;
            int total = 0;
            int waitFor = 0;
            int holes = 0;
            Text continueRow = null;
            MapCounter<String> serverCounts = new MapCounter<String>();
            for (TabletMetadata tablet : tablets) {
                ++total;
                TabletMetadata.Location loc = tablet.getLocation();
                if (expectedState == TableState.ONLINE && (loc == null || loc.getType() == TabletMetadata.LocationType.FUTURE) || expectedState == TableState.OFFLINE && loc != null) {
                    if (continueRow == null) {
                        continueRow = tablet.getExtent().toMetaRow();
                    }
                    ++waitFor;
                    lastRow = tablet.getExtent().toMetaRow();
                    if (loc != null) {
                        serverCounts.increment(loc.getHostPortSession(), 1L);
                    }
                }
                if (!tablet.getExtent().tableId().equals(tableId)) {
                    throw new AccumuloException("Saw unexpected table Id " + tableId + " " + tablet.getExtent());
                }
                if (lastExtent != null && !tablet.getExtent().isPreviousExtent(lastExtent)) {
                    ++holes;
                }
                lastExtent = tablet.getExtent();
            }
            if (continueRow != null) {
                startRow = continueRow;
            }
            if (holes > 0 || total == 0) {
                startRow = null;
                lastRow = null;
            }
            if (waitFor <= 0 && holes <= 0 && total != 0) break;
            long maxPerServer = 0L;
            if (serverCounts.size() > 0) {
                maxPerServer = serverCounts.max();
                waitTime = maxPerServer * 10L;
            } else {
                waitTime = (long)waitFor * 10L;
            }
            waitTime = Math.max(100L, waitTime);
            waitTime = Math.min(5000L, waitTime);
            log.trace("Waiting for {}({}) tablets, startRow = {} lastRow = {}, holes={} sleeping:{}ms", new Object[]{waitFor, maxPerServer, startRow, lastRow, holes, waitTime});
            UtilWaitThread.sleepUninterruptibly(waitTime, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void offline(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.offline(tableName, false);
    }

    @Override
    public void offline(String tableName, boolean wait) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        TableId tableId = this.context.getTableId(tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.canonical().getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_OFFLINE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        if (wait) {
            this.waitForTableStateTransition(tableId, TableState.OFFLINE);
        }
    }

    @Override
    public boolean isOnline(String tableName) throws AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        TableId tableId = this.context.getTableId(tableName);
        TableState expectedState = this.context.getTableState(tableId, true);
        return expectedState == TableState.ONLINE;
    }

    @Override
    public void online(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.online(tableName, false);
    }

    @Override
    public void online(String tableName, boolean wait) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        TableId tableId = this.context.getTableId(tableName);
        if (this.isOnline(tableName)) {
            if (wait) {
                this.waitForTableStateTransition(tableId, TableState.ONLINE);
            }
            return;
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.canonical().getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_ONLINE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        if (wait) {
            this.waitForTableStateTransition(tableId, TableState.ONLINE);
        }
    }

    @Override
    public void clearLocatorCache(String tableName) throws TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        TabletLocator tabLocator = TabletLocator.getLocator(this.context, this.context.getTableId(tableName));
        tabLocator.invalidateCache();
    }

    @Override
    public Map<String, String> tableIdMap() {
        return this.context.getTableNameToIdMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TableId)e.getValue()).canonical(), (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, TreeMap::new));
    }

    @Override
    public Text getMaxRow(String tableName, Authorizations auths, Text startRow, boolean startInclusive, Text endRow, boolean endInclusive) throws TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Scanner scanner = this.context.createScanner(tableName, auths);
        return FindMax.findMax(scanner, startRow, startInclusive, endRow, endInclusive);
    }

    @Override
    public List<DiskUsage> getDiskUsage(Set<String> tableNames) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        List<TDiskUsage> diskUsages = null;
        while (diskUsages == null) {
            Pair<String, ClientService.Client> pair = null;
            try {
                pair = ThriftClientTypes.CLIENT.getTabletServerConnection(this.context, false);
                diskUsages = pair.getSecond().getDiskUsage(tableNames, this.context.rpcCreds());
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                }
                throw new AccumuloException(e.description, (Throwable)((Object)e));
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.getUser(), e.getCode());
            }
            catch (TTransportException e) {
                if (pair == null) {
                    log.debug("Disk usage request failed.  Pair is null.  Retrying request...", (Throwable)e);
                } else {
                    log.debug("Disk usage request failed {}, retrying ... ", (Object)pair.getFirst(), (Object)e);
                }
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
            }
            catch (TException e) {
                throw new AccumuloException(e);
            }
            finally {
                if (pair == null) continue;
                ThriftUtil.close(pair.getSecond(), this.context);
            }
        }
        ArrayList<DiskUsage> finalUsages = new ArrayList<DiskUsage>();
        for (TDiskUsage diskUsage : diskUsages) {
            finalUsages.add(new DiskUsage(new TreeSet<String>(diskUsage.getTables()), diskUsage.getUsage()));
        }
        return finalUsages;
    }

    public static Path findExportFile(ClientContext context, Set<String> importDirs) throws AccumuloException {
        LinkedHashSet<Path> exportFiles = new LinkedHashSet<Path>();
        for (String importDir : importDirs) {
            Path exportFilePath = null;
            try {
                FileSystem fs = new Path(importDir).getFileSystem(context.getHadoopConf());
                exportFilePath = new Path(importDir, "exportMetadata.zip");
                log.debug("Looking for export metadata in {}", (Object)exportFilePath);
                if (!fs.exists(exportFilePath)) continue;
                log.debug("Found export metadata in {}", (Object)exportFilePath);
                exportFiles.add(exportFilePath);
            }
            catch (IOException ioe) {
                log.warn("Non-Fatal IOException reading export file: {}", exportFilePath, (Object)ioe);
            }
        }
        if (exportFiles.size() > 1) {
            String fileList = Arrays.toString(exportFiles.toArray());
            log.warn("Found multiple export metadata files: " + fileList);
            throw new AccumuloException("Found multiple export metadata files: " + fileList);
        }
        if (exportFiles.isEmpty()) {
            log.warn("Unable to locate export metadata");
            throw new AccumuloException("Unable to locate export metadata");
        }
        return (Path)exportFiles.iterator().next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getExportedProps(FileSystem fs, Path path) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("table_config.txt")) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] sa = line.split("=", 2);
                        props.put(sa[0], sa[1]);
                    }
                    return props;
                }
                finally {
                    in.close();
                    return props;
                }
            }
        }
    }

    @Override
    public void importTable(String tableName, Set<String> importDirs, ImportConfiguration ic) throws TableExistsException, AccumuloException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((importDirs != null ? 1 : 0) != 0, (Object)"importDir is null");
        boolean keepOffline = ic.isKeepOffline();
        boolean keepMapping = ic.isKeepMappings();
        HashSet<String> checkedImportDirs = new HashSet<String>();
        try {
            for (String s2 : importDirs) {
                checkedImportDirs.add(this.checkPath(s2, "Table", "").toString());
            }
        }
        catch (IOException e) {
            throw new AccumuloException(e);
        }
        try {
            Path exportFilePath = TableOperationsImpl.findExportFile(this.context, checkedImportDirs);
            FileSystem fs = exportFilePath.getFileSystem(this.context.getHadoopConf());
            Map<String, String> props = TableOperationsImpl.getExportedProps(fs, exportFilePath);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                if (!Property.isClassProperty(entry.getKey()) || entry.getValue().contains("org.apache.accumulo.core")) continue;
                LoggerFactory.getLogger(this.getClass()).info("Imported table sets '{}' to '{}'.  Ensure this class is on Accumulo classpath.", (Object)this.sanitize(entry.getKey()), (Object)this.sanitize(entry.getValue()));
            }
        }
        catch (IOException ioe) {
            LoggerFactory.getLogger(this.getClass()).warn("Failed to check if imported table references external java classes : {}", (Object)ioe.getMessage());
        }
        ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>(3 + checkedImportDirs.size());
        args.add(0, ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)));
        args.add(1, ByteBuffer.wrap(Boolean.toString(keepOffline).getBytes(StandardCharsets.UTF_8)));
        args.add(2, ByteBuffer.wrap(Boolean.toString(keepMapping).getBytes(StandardCharsets.UTF_8)));
        checkedImportDirs.stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).map(ByteBuffer::wrap).forEach(args::add);
        try {
            this.doTableFateOperation(tableName, AccumuloException.class, FateOperation.TABLE_IMPORT, args, Collections.emptyMap());
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String sanitize(String msg) {
        return msg.replaceAll("[\r\n]", "");
    }

    @Override
    public void exportTable(String tableName, String exportDir) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((exportDir != null ? 1 : 0) != 0, (Object)"exportDir is null");
        if (this.isOnline(tableName)) {
            throw new IllegalStateException("The table " + tableName + " is online; exportTable requires a table to be offline before exporting.");
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(exportDir.getBytes(StandardCharsets.UTF_8)));
        Map<String, String> opts = Collections.emptyMap();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_EXPORT, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean testClassLoad(String tableName, String className, String asTypeName) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (Object)"className is null");
        Preconditions.checkArgument((asTypeName != null ? 1 : 0) != 0, (Object)"asTypeName is null");
        try {
            return ThriftClientTypes.CLIENT.execute(this.context, client -> client.checkTableClass(TraceUtil.traceInfo(), this.context.rpcCreds(), tableName, className, asTypeName));
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            Throwable t = e.getCause();
            if (t instanceof ThriftTableOperationException) {
                ThriftTableOperationException ttoe = (ThriftTableOperationException)((Object)t);
                switch (ttoe.getType()) {
                    case NOTFOUND: {
                        throw new TableNotFoundException(ttoe);
                    }
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(tableName, new NamespaceNotFoundException(ttoe));
                    }
                }
                throw e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void attachIterator(String tableName, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.testClassLoad(tableName, setting.getIteratorClass(), SortedKeyValueIterator.class.getName());
        super.attachIterator(tableName, setting, scopes);
    }

    @Override
    public int addConstraint(String tableName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        this.testClassLoad(tableName, constraintClassName, Constraint.class.getName());
        return super.addConstraint(tableName, constraintClassName);
    }

    private void doTableFateOperation(String tableOrNamespaceName, Class<? extends Exception> namespaceNotFoundExceptionClass, FateOperation op, List<ByteBuffer> args, Map<String, String> opts) throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try {
            this.doFateOperation(op, args, opts, tableOrNamespaceName);
        }
        catch (NamespaceExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (NamespaceNotFoundException e) {
            if (namespaceNotFoundExceptionClass == null) {
                throw new AssertionError((Object)e);
            }
            if (AccumuloException.class.isAssignableFrom(namespaceNotFoundExceptionClass)) {
                throw new AccumuloException("Cannot create table in non-existent namespace", e);
            }
            if (TableNotFoundException.class.isAssignableFrom(namespaceNotFoundExceptionClass)) {
                throw new TableNotFoundException(null, tableOrNamespaceName, "Namespace not found", e);
            }
            throw new AssertionError((Object)e);
        }
    }

    private void clearSamplerOptions(String tableName) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        String prefix = Property.TABLE_SAMPLER_OPTS.getKey();
        for (Map.Entry<String, String> entry : this.getProperties(tableName)) {
            String property = entry.getKey();
            if (!property.startsWith(prefix)) continue;
            this.removeProperty(tableName, property);
        }
    }

    @Override
    public void setSamplerConfiguration(String tableName, SamplerConfiguration samplerConfiguration) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        this.clearSamplerOptions(tableName);
        Map<String, String> props = new SamplerConfigurationImpl(samplerConfiguration).toTablePropertiesMap();
        this.modifyProperties(tableName, properties -> properties.putAll(props));
    }

    @Override
    public void clearSamplerConfiguration(String tableName) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        this.removeProperty(tableName, Property.TABLE_SAMPLER.getKey());
        this.clearSamplerOptions(tableName);
    }

    @Override
    public SamplerConfiguration getSamplerConfiguration(String tableName) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        ConfigurationCopy conf = new ConfigurationCopy(this.getProperties(tableName));
        SamplerConfigurationImpl sci = SamplerConfigurationImpl.newSamplerConfig(conf);
        if (sci == null) {
            return null;
        }
        return sci.toSamplerConfiguration();
    }

    @Override
    public Locations locate(String tableName, Collection<Range> ranges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Objects.requireNonNull(ranges, "ranges must be non null");
        TableId tableId = this.context.getTableId(tableName);
        TabletLocator locator = TabletLocator.getLocator(this.context, tableId);
        ArrayList<Range> rangeList = null;
        rangeList = ranges instanceof List ? (ArrayList<Range>)ranges : new ArrayList<Range>(ranges);
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        locator.invalidateCache();
        Retry retry = Retry.builder().infiniteRetries().retryAfter(100L, TimeUnit.MILLISECONDS).incrementBy(100L, TimeUnit.MILLISECONDS).maxWait(2L, TimeUnit.SECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createRetry();
        while (!locator.binRanges(this.context, rangeList, binnedRanges).isEmpty()) {
            this.context.requireTableExists(tableId, tableName);
            this.context.requireNotOffline(tableId, tableName);
            binnedRanges.clear();
            try {
                retry.waitForNextAttempt(log, String.format("locating tablets in table %s(%s) for %d ranges", tableName, tableId, rangeList.size()));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            locator.invalidateCache();
        }
        return new LocationsImpl(binnedRanges);
    }

    @Override
    public SummaryRetriever summaries(final String tableName) {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        return new SummaryRetriever(){
            private Text startRow = null;
            private Text endRow = null;
            private List<TSummarizerConfiguration> summariesToFetch = Collections.emptyList();
            private String summarizerClassRegex;
            private boolean flush = false;

            @Override
            public SummaryRetriever startRow(Text startRow) {
                Objects.requireNonNull(startRow);
                if (this.endRow != null) {
                    Preconditions.checkArgument((startRow.compareTo((BinaryComparable)this.endRow) < 0 ? 1 : 0) != 0, (String)"Start row must be less than end row : %s >= %s", (Object)startRow, (Object)this.endRow);
                }
                this.startRow = startRow;
                return this;
            }

            @Override
            public SummaryRetriever startRow(CharSequence startRow) {
                return this.startRow(new Text(startRow.toString()));
            }

            @Override
            public List<Summary> retrieve() throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
                TableId tableId = TableOperationsImpl.this.context.getTableId(tableName);
                TableOperationsImpl.this.context.requireNotOffline(tableId, tableName);
                TRowRange range = new TRowRange(TextUtil.getByteBuffer(this.startRow), TextUtil.getByteBuffer(this.endRow));
                TSummaryRequest request = new TSummaryRequest(tableId.canonical(), range, this.summariesToFetch, this.summarizerClassRegex);
                if (this.flush) {
                    TableOperationsImpl.this._flush(tableId, this.startRow, this.endRow, true);
                }
                TSummaries ret = ThriftClientTypes.TABLET_SERVER.execute(TableOperationsImpl.this.context, client -> {
                    TSummaries tsr = client.startGetSummaries(TraceUtil.traceInfo(), TableOperationsImpl.this.context.rpcCreds(), request);
                    while (!tsr.finished) {
                        tsr = client.contiuneGetSummaries(TraceUtil.traceInfo(), tsr.sessionId);
                    }
                    return tsr;
                });
                return new SummaryCollection(ret).getSummaries();
            }

            @Override
            public SummaryRetriever endRow(Text endRow) {
                Objects.requireNonNull(endRow);
                if (this.startRow != null) {
                    Preconditions.checkArgument((this.startRow.compareTo((BinaryComparable)endRow) < 0 ? 1 : 0) != 0, (String)"Start row must be less than end row : %s >= %s", (Object)this.startRow, (Object)endRow);
                }
                this.endRow = endRow;
                return this;
            }

            @Override
            public SummaryRetriever endRow(CharSequence endRow) {
                return this.endRow(new Text(endRow.toString()));
            }

            @Override
            public SummaryRetriever withConfiguration(Collection<SummarizerConfiguration> configs) {
                Objects.requireNonNull(configs);
                this.summariesToFetch = configs.stream().map(SummarizerConfigurationUtil::toThrift).collect(Collectors.toList());
                return this;
            }

            @Override
            public SummaryRetriever withConfiguration(SummarizerConfiguration ... config) {
                Objects.requireNonNull(config);
                return this.withConfiguration(Arrays.asList(config));
            }

            @Override
            public SummaryRetriever withMatchingConfiguration(String regex) {
                Objects.requireNonNull(regex);
                Pattern.compile(regex);
                this.summarizerClassRegex = regex;
                return this;
            }

            @Override
            public SummaryRetriever flush(boolean b) {
                this.flush = b;
                return this;
            }
        };
    }

    @Override
    public void addSummarizers(String tableName, SummarizerConfiguration ... newConfigs) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        HashSet<SummarizerConfiguration> currentConfigs = new HashSet<SummarizerConfiguration>(SummarizerConfiguration.fromTableProperties(this.getProperties(tableName)));
        HashSet<SummarizerConfiguration> newConfigSet = new HashSet<SummarizerConfiguration>(Arrays.asList(newConfigs));
        newConfigSet.removeIf(currentConfigs::contains);
        Set newIds = newConfigSet.stream().map(SummarizerConfiguration::getPropertyId).collect(Collectors.toSet());
        for (SummarizerConfiguration csc : currentConfigs) {
            if (!newIds.contains(csc.getPropertyId())) continue;
            throw new IllegalArgumentException("Summarizer property id is in use by " + csc);
        }
        Map<String, String> props = SummarizerConfiguration.toTableProperties(newConfigSet);
        this.modifyProperties(tableName, properties -> properties.putAll(props));
    }

    @Override
    public void removeSummarizers(String tableName, Predicate<SummarizerConfiguration> predicate) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        Collection<SummarizerConfiguration> summarizerConfigs = SummarizerConfiguration.fromTableProperties(this.getProperties(tableName));
        this.modifyProperties(tableName, properties -> summarizerConfigs.stream().filter(predicate).map(sc -> sc.toTableProperties().keySet()).forEach(keySet -> keySet.forEach(properties::remove)));
    }

    @Override
    public List<SummarizerConfiguration> listSummarizers(String tableName) throws AccumuloException, TableNotFoundException {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        return new ArrayList<SummarizerConfiguration>(SummarizerConfiguration.fromTableProperties(this.getProperties(tableName)));
    }

    @Override
    public TableOperations.ImportDestinationArguments importDirectory(String directory) {
        return new BulkImport(directory, this.context);
    }

    @Override
    public TimeType getTimeType(String tableName) throws TableNotFoundException {
        TableId tableId = this.context.getTableId(tableName);
        Optional<TabletMetadata> tabletMetadata = this.context.getAmple().readTablets().forTable(tableId).fetch(TabletMetadata.ColumnType.TIME).checkConsistency().build().stream().findFirst();
        TabletMetadata timeData = tabletMetadata.orElseThrow(() -> new IllegalStateException("Failed to retrieve TimeType"));
        return timeData.getTime().getType();
    }

    private void prependPropertiesToExclude(Map<String, String> opts, Set<String> propsToExclude) {
        if (propsToExclude == null) {
            return;
        }
        for (String prop : propsToExclude) {
            opts.put(PROPERTY_EXCLUDE_PREFIX + prop, "");
        }
    }

    private void validatePropertiesToSet(Map<String, String> opts, Map<String, String> propsToSet) {
        if (propsToSet == null) {
            return;
        }
        propsToSet.forEach((k, v) -> {
            if (k.startsWith(PROPERTY_EXCLUDE_PREFIX)) {
                throw new IllegalArgumentException("Property can not start with !");
            }
            opts.put((String)k, (String)v);
        });
    }

    private class SplitTask
    implements Runnable {
        private List<Text> splits;
        private SplitEnv env;

        SplitTask(SplitEnv env, List<Text> splits) {
            this.env = env;
            this.splits = splits;
        }

        @Override
        public void run() {
            try {
                if (this.env.exception.get() != null) {
                    return;
                }
                if (this.splits.size() <= 2) {
                    TableOperationsImpl.this.addSplits(this.env, new TreeSet<Text>(this.splits));
                    this.splits.forEach(s -> this.env.latch.countDown());
                    return;
                }
                int mid = this.splits.size() / 2;
                TableOperationsImpl.this.addSplits(this.env, new TreeSet<Text>(this.splits.subList(mid, mid + 1)));
                this.env.latch.countDown();
                this.env.executor.execute(new SplitTask(this.env, this.splits.subList(0, mid)));
                this.env.executor.execute(new SplitTask(this.env, this.splits.subList(mid + 1, this.splits.size())));
            }
            catch (Exception t) {
                this.env.exception.compareAndSet(null, t);
            }
        }
    }

    private static class SplitEnv {
        private final String tableName;
        private final TableId tableId;
        private final ExecutorService executor;
        private final CountDownLatch latch;
        private final AtomicReference<Exception> exception;

        SplitEnv(String tableName, TableId tableId, ExecutorService executor, CountDownLatch latch, AtomicReference<Exception> exception) {
            this.tableName = tableName;
            this.tableId = tableId;
            this.executor = executor;
            this.latch = latch;
            this.exception = exception;
        }
    }

    private static class LocationsImpl
    implements Locations {
        private Map<Range, List<TabletId>> groupedByRanges = null;
        private Map<TabletId, List<Range>> groupedByTablets = new HashMap<TabletId, List<Range>>();
        private Map<TabletId, String> tabletLocations = new HashMap<TabletId, String>();

        public LocationsImpl(Map<String, Map<KeyExtent, List<Range>>> binnedRanges) {
            for (Map.Entry<String, Map<KeyExtent, List<Range>>> entry : binnedRanges.entrySet()) {
                String location = entry.getKey();
                for (Map.Entry<KeyExtent, List<Range>> entry2 : entry.getValue().entrySet()) {
                    TabletIdImpl tabletId = new TabletIdImpl(entry2.getKey());
                    this.tabletLocations.put(tabletId, location);
                    List<Range> prev = this.groupedByTablets.put(tabletId, Collections.unmodifiableList(entry2.getValue()));
                    if (prev == null) continue;
                    throw new RuntimeException("Unexpected : tablet at multiple locations : " + location + " " + tabletId);
                }
            }
            this.groupedByTablets = Collections.unmodifiableMap(this.groupedByTablets);
        }

        @Override
        public String getTabletLocation(TabletId tabletId) {
            return this.tabletLocations.get(tabletId);
        }

        @Override
        public Map<Range, List<TabletId>> groupByRange() {
            if (this.groupedByRanges == null) {
                HashMap tmp = new HashMap();
                this.groupedByTablets.forEach((tabletId, rangeList) -> rangeList.forEach(range -> tmp.computeIfAbsent(range, k -> new ArrayList()).add(tabletId)));
                HashMap tmp2 = new HashMap();
                for (Map.Entry entry : tmp.entrySet()) {
                    tmp2.put((Range)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
                this.groupedByRanges = Collections.unmodifiableMap(tmp2);
            }
            return this.groupedByRanges;
        }

        @Override
        public Map<TabletId, List<Range>> groupByTablet() {
            return this.groupedByTablets;
        }
    }
}

