/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.TabletId;

public class MutationsRejectedException
extends AccumuloException {
    private static final long serialVersionUID = 1L;
    private final ArrayList<ConstraintViolationSummary> cvsl = new ArrayList();
    private final HashMap<TabletId, Set<SecurityErrorCode>> af = new HashMap();
    private final HashSet<String> es = new HashSet();
    private final int unknownErrors;

    @Deprecated(since="2.0.0")
    public MutationsRejectedException(Instance instance, List<ConstraintViolationSummary> cvsList, Map<TabletId, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("constraint violation codes : " + cvsList.stream().map(ConstraintViolationSummary::getViolationCode).collect(Collectors.toSet()) + "  security codes: " + hashMap.toString() + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl.addAll(cvsList);
        this.af.putAll(hashMap);
        this.es.addAll(serverSideErrors);
        this.unknownErrors = unknownErrors;
    }

    public MutationsRejectedException(AccumuloClient client, List<ConstraintViolationSummary> cvsList, Map<TabletId, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("constraint violation codes : " + cvsList.stream().map(ConstraintViolationSummary::getViolationCode).collect(Collectors.toSet()) + "  security codes: " + MutationsRejectedException.format(hashMap, (ClientContext)client) + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl.addAll(cvsList);
        this.af.putAll(hashMap);
        this.es.addAll(serverSideErrors);
        this.unknownErrors = unknownErrors;
    }

    private static String format(Map<TabletId, Set<SecurityErrorCode>> hashMap, ClientContext context) {
        HashMap result = new HashMap();
        for (Map.Entry<TabletId, Set<SecurityErrorCode>> entry : hashMap.entrySet()) {
            TabletId tabletId = entry.getKey();
            String tableInfo = context.getPrintableTableInfoFromId(tabletId.getTable());
            if (!result.containsKey(tableInfo)) {
                result.put(tableInfo, new HashSet());
            }
            ((Set)result.get(tableInfo)).addAll((Collection)hashMap.get(tabletId));
        }
        return ((Object)result).toString();
    }

    public List<ConstraintViolationSummary> getConstraintViolationSummaries() {
        return this.cvsl;
    }

    public Map<TabletId, Set<SecurityErrorCode>> getSecurityErrorCodes() {
        return this.af;
    }

    public Collection<String> getErrorServers() {
        return this.es;
    }

    public int getUnknownExceptions() {
        return this.unknownErrors;
    }
}

