/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.manager.thrift.TabletLoadState;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.ManagerMetadataUtil;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.OnlineTablets;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.managermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssignmentHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AssignmentHandler.class);
    private static final String METADATA_ISSUE = "Saw metadata issue when loading tablet : ";
    private final KeyExtent extent;
    private final int retryAttempt;
    private final TabletServer server;

    public AssignmentHandler(TabletServer server, KeyExtent extent) {
        this(server, extent, 0);
    }

    public AssignmentHandler(TabletServer server, KeyExtent extent, int retryAttempt) {
        this.server = server;
        this.extent = extent;
        this.retryAttempt = retryAttempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean canLoad;
        TabletMetadata tabletMetadata;
        Object locationToOpen;
        block46: {
            SortedSet<KeyExtent> openingOverlapping;
            SortedSet<KeyExtent> sortedSet = this.server.unopenedTablets;
            synchronized (sortedSet) {
                SortedSet<KeyExtent> sortedSet2 = this.server.openingTablets;
                synchronized (sortedSet2) {
                    OnlineTablets onlineTablets = this.server.onlineTablets;
                    synchronized (onlineTablets) {
                        Set unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, this.server.unopenedTablets);
                        openingOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, this.server.openingTablets);
                        Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, this.server.onlineTablets.snapshot());
                        if (openingOverlapping.contains(this.extent) || onlineOverlapping.contains(this.extent)) {
                            return;
                        }
                        if (!unopenedOverlapping.contains(this.extent)) {
                            log.info("assignment {} no longer in the unopened set", (Object)this.extent);
                            return;
                        }
                        if (unopenedOverlapping.size() != 1 || !openingOverlapping.isEmpty() || !onlineOverlapping.isEmpty()) {
                            throw new IllegalStateException("overlaps assigned " + this.extent + " " + !this.server.unopenedTablets.contains(this.extent) + " " + unopenedOverlapping + " " + openingOverlapping + " " + onlineOverlapping);
                        }
                    }
                    this.server.unopenedTablets.remove(this.extent);
                    this.server.openingTablets.add(this.extent);
                }
            }
            locationToOpen = null;
            tabletMetadata = null;
            canLoad = false;
            try {
                tabletMetadata = this.server.getContext().getAmple().readTablet(this.extent, new TabletMetadata.ColumnType[0]);
                canLoad = AssignmentHandler.checkTabletMetadata(this.extent, this.server.getTabletSession(), tabletMetadata);
                if (!canLoad || !tabletMetadata.sawOldPrevEndRow()) break block46;
                KeyExtent fixedExtent = ManagerMetadataUtil.fixSplit((ServerContext)this.server.getContext(), (TabletMetadata)tabletMetadata, (ServiceLock)this.server.getLock());
                openingOverlapping = this.server.openingTablets;
                synchronized (openingOverlapping) {
                    this.server.openingTablets.remove(this.extent);
                    this.server.openingTablets.notifyAll();
                    if (!KeyExtent.findOverlapping((KeyExtent)this.extent, new TreeSet<KeyExtent>(Arrays.asList(fixedExtent))).contains(fixedExtent)) {
                        throw new IllegalStateException("Fixed split does not overlap " + this.extent + " " + fixedExtent);
                    }
                    this.server.unopenedTablets.add(fixedExtent);
                }
                new AssignmentHandler(this.server, fixedExtent).run();
                return;
            }
            catch (Exception e) {
                openingOverlapping = this.server.openingTablets;
                synchronized (openingOverlapping) {
                    this.server.openingTablets.remove(this.extent);
                    this.server.openingTablets.notifyAll();
                }
                log.warn("Failed to verify tablet " + this.extent, (Throwable)e);
                this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                throw new RuntimeException(e);
            }
        }
        if (!canLoad) {
            log.debug("Reporting tablet {} assignment failure: unable to verify Tablet Information", (Object)this.extent);
            SortedSet<KeyExtent> e = this.server.openingTablets;
            synchronized (e) {
                this.server.openingTablets.remove(this.extent);
                this.server.openingTablets.notifyAll();
            }
            this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
            return;
        }
        Tablet tablet = null;
        boolean successful = false;
        try {
            this.server.acquireRecoveryMemory(this.extent);
            TabletServerResourceManager.TabletResourceManager trm = this.server.resourceManager.createTabletResourceManager(this.extent, (AccumuloConfiguration)this.server.getTableConfiguration(this.extent));
            TabletData data = new TabletData(tabletMetadata);
            tablet = new Tablet(this.server, this.extent, trm, data);
            if (tablet.getNumEntriesInMemory() > 0L && !tablet.minorCompactNow(MinorCompactionReason.RECOVERY)) {
                throw new RuntimeException("Minor compaction after recovery fails for " + this.extent);
            }
            Assignment assignment = new Assignment(this.extent, this.server.getTabletSession(), tabletMetadata.getLast());
            TabletStateStore.setLocation((ServerContext)this.server.getContext(), (Assignment)assignment);
            SortedSet<KeyExtent> sortedSet = this.server.openingTablets;
            synchronized (sortedSet) {
                OnlineTablets onlineTablets = this.server.onlineTablets;
                synchronized (onlineTablets) {
                    this.server.openingTablets.remove(this.extent);
                    this.server.onlineTablets.put(this.extent, tablet);
                    this.server.openingTablets.notifyAll();
                    this.server.recentlyUnloadedCache.remove(tablet.getExtent());
                }
            }
            tablet = null;
            successful = true;
        }
        catch (Exception e) {
            log.warn("exception trying to assign tablet {} {}", new Object[]{this.extent, locationToOpen, e});
            if (e.getMessage() != null) {
                log.warn("{}", (Object)e.getMessage());
            }
            TableId tableId = this.extent.tableId();
            ProblemReports.getInstance((ServerContext)this.server.getContext()).report(new ProblemReport(tableId, ProblemType.TABLET_LOAD, this.extent.getUUID().toString(), this.server.getClientAddressString(), (Throwable)e));
        }
        finally {
            this.server.releaseRecoveryMemory(this.extent);
        }
        if (successful) {
            this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.LOADED, this.extent));
        } else {
            SortedSet<KeyExtent> e = this.server.unopenedTablets;
            synchronized (e) {
                SortedSet<KeyExtent> sortedSet = this.server.openingTablets;
                synchronized (sortedSet) {
                    this.server.openingTablets.remove(this.extent);
                    this.server.unopenedTablets.add(this.extent);
                    this.server.openingTablets.notifyAll();
                }
            }
            log.warn("failed to open tablet {} reporting failure to manager", (Object)this.extent);
            this.server.enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
            long reschedule = Math.min((1L << Math.min(32, this.retryAttempt)) * 1000L, TimeUnit.MINUTES.toMillis(10L));
            log.warn(String.format("rescheduling tablet load in %.2f seconds", (double)reschedule / 1000.0));
            ThreadPools.watchCriticalScheduledTask(this.server.getContext().getScheduledExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    log.info("adding tablet {} back to the assignment pool (retry {})", (Object)AssignmentHandler.this.extent, (Object)AssignmentHandler.this.retryAttempt);
                    AssignmentHandler handler = new AssignmentHandler(AssignmentHandler.this.server, AssignmentHandler.this.extent, AssignmentHandler.this.retryAttempt + 1);
                    if (AssignmentHandler.this.extent.isMeta()) {
                        if (AssignmentHandler.this.extent.isRootTablet()) {
                            Threads.createThread((String)"Root tablet assignment retry", (Runnable)handler).start();
                        } else {
                            AssignmentHandler.this.server.resourceManager.addMetaDataAssignment(AssignmentHandler.this.extent, log, handler);
                        }
                    } else {
                        AssignmentHandler.this.server.resourceManager.addAssignment(AssignmentHandler.this.extent, log, handler);
                    }
                }
            }, reschedule, TimeUnit.MILLISECONDS));
        }
    }

    public static boolean checkTabletMetadata(KeyExtent extent, TServerInstance instance, TabletMetadata meta) throws AccumuloException {
        return AssignmentHandler.checkTabletMetadata(extent, instance, meta, false);
    }

    public static boolean checkTabletMetadata(KeyExtent extent, TServerInstance instance, TabletMetadata meta, boolean ignoreLocationCheck) throws AccumuloException {
        if (meta == null) {
            log.info("Saw metadata issue when loading tablet : {}, its metadata was not found.", (Object)extent);
            return false;
        }
        if (!meta.sawPrevEndRow()) {
            throw new AccumuloException("Saw metadata issue when loading tablet : metadata entry does not have prev row (" + meta.getTableId() + " " + meta.getEndRow() + ")");
        }
        if (!extent.equals((Object)meta.getExtent())) {
            log.info("Saw metadata issue when loading tablet : tablet extent mismatch {} {}", (Object)extent, (Object)meta.getExtent());
            return false;
        }
        if (meta.getDirName() == null) {
            throw new AccumuloException("Saw metadata issue when loading tablet : metadata entry does not have directory (" + meta.getExtent() + ")");
        }
        if (meta.getTime() == null && !extent.equals((Object)RootTable.EXTENT)) {
            throw new AccumuloException("Saw metadata issue when loading tablet : metadata entry does not have time (" + meta.getExtent() + ")");
        }
        TabletMetadata.Location loc = meta.getLocation();
        if (!(ignoreLocationCheck || loc != null && loc.getType() == TabletMetadata.LocationType.FUTURE && instance.equals((Object)loc.getServerInstance()))) {
            log.info("Saw metadata issue when loading tablet : Unexpected location {} {}", (Object)extent, (Object)loc);
            return false;
        }
        return true;
    }
}

