/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.manager.balancer.AssignmentParamsImpl;
import org.apache.accumulo.core.manager.balancer.BalanceParamsImpl;
import org.apache.accumulo.core.manager.balancer.TServerStatusImpl;
import org.apache.accumulo.core.manager.balancer.TableStatisticsImpl;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.TableLoadBalancer;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TableStatistics;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.spi.balancer.data.TabletStatistics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostRegexTableLoadBalancer
extends TableLoadBalancer {
    private static final SecureRandom random = new SecureRandom();
    private static final String PROP_PREFIX = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey();
    private static final Logger LOG = LoggerFactory.getLogger(HostRegexTableLoadBalancer.class);
    public static final String HOST_BALANCER_PREFIX = PROP_PREFIX + "balancer.host.regex.";
    public static final String HOST_BALANCER_OOB_CHECK_KEY = PROP_PREFIX + "balancer.host.regex.oob.period";
    private static final String HOST_BALANCER_OOB_DEFAULT = "5m";
    public static final String HOST_BALANCER_REGEX_USING_IPS_KEY = PROP_PREFIX + "balancer.host.regex.is.ip";
    public static final String HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY = PROP_PREFIX + "balancer.host.regex.concurrent.migrations";
    private static final int HOST_BALANCER_REGEX_MAX_MIGRATIONS_DEFAULT = 250;
    protected static final String DEFAULT_POOL = "HostTableLoadBalancer.ALL";
    private static final int DEFAULT_OUTSTANDING_MIGRATIONS = 0;
    public static final String HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY = PROP_PREFIX + "balancer.host.regex.max.outstanding.migrations";
    private static final Set<TabletId> EMPTY_MIGRATIONS = Collections.emptySet();
    private volatile long lastOOBCheck = System.currentTimeMillis();
    private Map<String, SortedMap<TabletServerId, TServerStatus>> pools = new HashMap<String, SortedMap<TabletServerId, TServerStatus>>();
    private final Map<TabletId, TabletMigration> migrationsFromLastPass = new HashMap<TabletId, TabletMigration>();
    private final Map<TableId, Long> tableToTimeSinceNoMigrations = new HashMap<TableId, Long>();
    private Supplier<HrtlbConf> hrtlbConf;
    private LoadingCache<TableId, Supplier<Map<String, String>>> tablesRegExCache;

    private static Map<String, String> getRegexes(PluginEnvironment.Configuration conf) {
        HashMap<String, String> regexes = new HashMap<String, String>();
        Map<String, String> customProps = conf.getWithPrefix(PROP_PREFIX);
        if (customProps != null && !customProps.isEmpty()) {
            for (Map.Entry<String, String> customProp : customProps.entrySet()) {
                if (!customProp.getKey().startsWith(HOST_BALANCER_PREFIX) || customProp.getKey().equals(HOST_BALANCER_OOB_CHECK_KEY) || customProp.getKey().equals(HOST_BALANCER_REGEX_USING_IPS_KEY) || customProp.getKey().equals(HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY) || customProp.getKey().equals(HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY)) continue;
                String tableName = customProp.getKey().substring(HOST_BALANCER_PREFIX.length());
                String regex = customProp.getValue();
                regexes.put(tableName, regex);
            }
        }
        return Map.copyOf(regexes);
    }

    protected synchronized Map<String, SortedMap<TabletServerId, TServerStatus>> splitCurrentByRegex(SortedMap<TabletServerId, TServerStatus> current) {
        LOG.debug("Performing pool recheck - regrouping tablet servers based on regular expressions");
        HashMap<String, SortedMap<TabletServerId, TServerStatus>> newPools = new HashMap<String, SortedMap<TabletServerId, TServerStatus>>();
        for (Map.Entry<TabletServerId, TServerStatus> entry : current.entrySet()) {
            List<String> poolNames = this.getPoolNamesForHost(entry.getKey());
            for (String pool : poolNames) {
                TreeMap<TabletServerId, TServerStatus> np = (TreeMap<TabletServerId, TServerStatus>)newPools.get(pool);
                if (np == null) {
                    np = new TreeMap<TabletServerId, TServerStatus>(current.comparator());
                    newPools.put(pool, np);
                }
                np.put(entry.getKey(), entry.getValue());
            }
        }
        if (newPools.get(DEFAULT_POOL) == null) {
            LOG.warn("Default pool is empty; assigning all tablet servers to the default pool");
            TreeMap<TabletServerId, TServerStatus> dp = new TreeMap<TabletServerId, TServerStatus>(current.comparator());
            dp.putAll(current);
            newPools.put(DEFAULT_POOL, dp);
        }
        this.pools = newPools;
        LOG.trace("Pool to TabletServer mapping:");
        if (LOG.isTraceEnabled()) {
            for (Map.Entry<Object, Object> entry : this.pools.entrySet()) {
                LOG.trace("\tpool: {} -> tservers: {}", entry.getKey(), ((SortedMap)entry.getValue()).keySet());
            }
        }
        return this.pools;
    }

    protected List<String> getPoolNamesForHost(TabletServerId tabletServerId) {
        String host;
        String test = host = tabletServerId.getHost();
        if (!this.hrtlbConf.get().isIpBasedRegex) {
            try {
                test = this.getNameFromIp(host);
            }
            catch (UnknownHostException e1) {
                LOG.error("Unable to determine host name for IP: " + host + ", setting to default pool", (Throwable)e1);
                return Collections.singletonList(DEFAULT_POOL);
            }
        }
        ArrayList<String> pools = new ArrayList<String>();
        for (Map.Entry<String, Pattern> e : this.hrtlbConf.get().poolNameToRegexPattern.entrySet()) {
            if (!e.getValue().matcher(test).matches()) continue;
            pools.add(e.getKey());
        }
        if (pools.isEmpty()) {
            pools.add(DEFAULT_POOL);
        }
        return pools;
    }

    protected String getNameFromIp(String hostIp) throws UnknownHostException {
        return InetAddress.getByName(hostIp).getHostName();
    }

    private void checkTableConfig(TableId tableId) {
        Map tableRegexes = (Map)((Supplier)this.tablesRegExCache.getUnchecked((Object)tableId)).get();
        if (!this.hrtlbConf.get().regexes.equals(tableRegexes)) {
            LoggerFactory.getLogger(HostRegexTableLoadBalancer.class).warn("Table id {} has different config than system.  The per table config is ignored.", (Object)tableId);
        }
    }

    protected String getPoolNameForTable(String tableName) {
        if (tableName == null) {
            return DEFAULT_POOL;
        }
        return this.hrtlbConf.get().poolNameToRegexPattern.containsKey(tableName) ? tableName : DEFAULT_POOL;
    }

    public String toString() {
        HrtlbConf myConf = this.hrtlbConf.get();
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        buf.append("\nTablet Out Of Bounds Check Interval", myConf.oobCheckMillis);
        buf.append("\nMax Tablet Server Migrations", myConf.maxTServerMigrations);
        buf.append("\nRegular Expressions use IPs", myConf.isIpBasedRegex);
        buf.append("\nPools", myConf.poolNameToRegexPattern);
        return buf.toString();
    }

    public Map<String, Pattern> getPoolNameToRegexPattern() {
        return this.hrtlbConf.get().poolNameToRegexPattern;
    }

    public int getMaxMigrations() {
        return this.hrtlbConf.get().maxTServerMigrations;
    }

    public int getMaxOutstandingMigrations() {
        return this.hrtlbConf.get().maxOutstandingMigrations;
    }

    public long getOobCheckMillis() {
        return this.hrtlbConf.get().oobCheckMillis;
    }

    public boolean isIpBasedRegex() {
        return this.hrtlbConf.get().isIpBasedRegex;
    }

    @Override
    public void init(final BalancerEnvironment balancerEnvironment) {
        super.init(balancerEnvironment);
        this.hrtlbConf = balancerEnvironment.getConfiguration().getDerived(HrtlbConf::new);
        this.tablesRegExCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<TableId, Supplier<Map<String, String>>>(){

            public Supplier<Map<String, String>> load(TableId key) {
                return balancerEnvironment.getConfiguration(key).getDerived(x$0 -> HostRegexTableLoadBalancer.getRegexes(x$0));
            }
        });
        LOG.info("{}", (Object)this);
    }

    @Override
    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        Map<String, SortedMap<TabletServerId, TServerStatus>> pools = this.splitCurrentByRegex(params.currentStatus());
        HashMap groupedUnassigned = new HashMap();
        params.unassignedTablets().forEach((ke, lastTserver) -> groupedUnassigned.computeIfAbsent(ke.getTable(), k -> new HashMap()).put(ke, lastTserver));
        Map<TableId, String> tableIdToTableName = this.environment.getTableIdMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (Map.Entry e : groupedUnassigned.entrySet()) {
            HashMap<TabletId, TabletServerId> newAssignments = new HashMap<TabletId, TabletServerId>();
            String tableName = tableIdToTableName.get(e.getKey());
            String poolName = this.getPoolNameForTable(tableName);
            SortedMap<TabletServerId, TServerStatus> currentView = pools.get(poolName);
            if (currentView == null || currentView.isEmpty()) {
                LOG.warn("No tablet servers online for table {}, assigning within default pool", (Object)tableName);
                currentView = pools.get(DEFAULT_POOL);
                if (currentView == null) {
                    LOG.error("No tablet servers exist in the default pool, unable to assign tablets for table {}", (Object)tableName);
                    continue;
                }
            }
            LOG.debug("Sending {} tablets to balancer for table {} for assignment within tservers {}", new Object[]{((Map)e.getValue()).size(), tableName, currentView.keySet()});
            this.getBalancerForTable((TableId)e.getKey()).getAssignments(new AssignmentParamsImpl(currentView, (Map)e.getValue(), newAssignments));
            newAssignments.forEach(params::addAssignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long balance(TabletBalancer.BalanceParameters params) {
        long minBalanceTime = 20000L;
        Map<String, TableId> tableIdMap = this.environment.getTableIdMap();
        Map<TableId, String> tableIdToTableName = tableIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        tableIdToTableName.keySet().forEach(this::checkTableConfig);
        long now = System.currentTimeMillis();
        HrtlbConf myConf = this.hrtlbConf.get();
        SortedMap<TabletServerId, TServerStatus> current = params.currentStatus();
        Set<TabletId> migrations = params.currentMigrations();
        List<TabletMigration> migrationsOut = params.migrationsOut();
        Map<String, SortedMap<TabletServerId, TServerStatus>> currentGrouped = this.splitCurrentByRegex(params.currentStatus());
        if (now - this.lastOOBCheck > myConf.oobCheckMillis) {
            try {
                for (String table : tableIdMap.keySet()) {
                    LOG.debug("Checking for out of bounds tablets for table {}", (Object)table);
                    String tablePoolName = this.getPoolNameForTable(table);
                    block6: for (Map.Entry<TabletServerId, TServerStatus> e : current.entrySet()) {
                        List<String> hostPools = this.getPoolNamesForHost(e.getKey());
                        if (hostPools.contains(tablePoolName)) continue;
                        TableId tid2 = tableIdMap.get(table);
                        if (tid2 == null) {
                            LOG.warn("Unable to check for out of bounds tablets for table {}, it may have been deleted or renamed.", (Object)table);
                            continue;
                        }
                        try {
                            List<TabletStatistics> outOfBoundsTablets = this.getOnlineTabletsForTable(e.getKey(), tid2);
                            if (outOfBoundsTablets == null) continue;
                            for (TabletStatistics ts : outOfBoundsTablets) {
                                if (migrations.contains(ts.getTabletId())) {
                                    LOG.debug("Migration for out of bounds tablet {} has already been requested", (Object)ts.getTabletId());
                                    continue;
                                }
                                String poolName = this.getPoolNameForTable(table);
                                SortedMap<TabletServerId, TServerStatus> currentView = currentGrouped.get(poolName);
                                if (currentView != null) {
                                    int skip = random.nextInt(currentView.size());
                                    Iterator<TabletServerId> iter = currentView.keySet().iterator();
                                    for (int i = 0; i < skip; ++i) {
                                        iter.next();
                                    }
                                    TabletServerId nextTS = iter.next();
                                    LOG.info("Tablet {} is currently outside the bounds of the regex, migrating from {} to {}", new Object[]{ts.getTabletId(), e.getKey(), nextTS});
                                    migrationsOut.add(new TabletMigration(ts.getTabletId(), e.getKey(), nextTS));
                                    if (migrationsOut.size() < myConf.maxTServerMigrations) continue;
                                    continue block6;
                                }
                                LOG.warn("No tablet servers online for pool {}, unable to migrate out of bounds tablets", (Object)poolName);
                            }
                        }
                        catch (AccumuloException | AccumuloSecurityException e1) {
                            LOG.error("Error in OOB check getting tablets for table {} from server {} {}", new Object[]{tid2, e.getKey().getHost(), e});
                        }
                    }
                }
            }
            finally {
                this.lastOOBCheck = System.currentTimeMillis();
            }
        }
        if (!migrationsOut.isEmpty()) {
            LOG.warn("Not balancing tables due to moving {} out of bounds tablets", (Object)migrationsOut.size());
            LOG.info("Migrating out of bounds tablets: {}", migrationsOut);
            return minBalanceTime;
        }
        if (migrations != null && !migrations.isEmpty()) {
            if (migrations.size() >= myConf.maxOutstandingMigrations) {
                LOG.warn("Not balancing tables due to {} outstanding migrations", (Object)migrations.size());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sample up to 10 outstanding migrations: {}", (Object)HostRegexTableLoadBalancer.limitTen(migrations));
                }
                return minBalanceTime;
            }
            LOG.debug("Current outstanding migrations of {} being applied", (Object)migrations.size());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sample up to 10 outstanding migrations: {}", (Object)HostRegexTableLoadBalancer.limitTen(migrations));
            }
            this.migrationsFromLastPass.keySet().retainAll(migrations);
            TreeMap<TabletServerId, TServerStatusImpl> currentCopy = new TreeMap<TabletServerId, TServerStatusImpl>();
            current.forEach((tid, status) -> currentCopy.put((TabletServerId)tid, (TServerStatusImpl)status));
            HashMultimap serverTableIdCopied = HashMultimap.create();
            for (TabletMigration migration : this.migrationsFromLastPass.values()) {
                TableStatisticsImpl toInfo;
                TableStatisticsImpl fromInfo = this.getTableInfo(currentCopy, (Multimap<TabletServerId, String>)serverTableIdCopied, migration.getTablet().getTable().canonical(), migration.getOldTabletServer());
                if (fromInfo != null) {
                    fromInfo.setOnlineTabletCount(fromInfo.getOnlineTabletCount() - 1);
                }
                if ((toInfo = this.getTableInfo(currentCopy, (Multimap<TabletServerId, String>)serverTableIdCopied, migration.getTablet().getTable().canonical(), migration.getNewTabletServer())) == null) continue;
                toInfo.setOnlineTabletCount(toInfo.getOnlineTabletCount() + 1);
            }
            migrations = EMPTY_MIGRATIONS;
        } else {
            this.migrationsFromLastPass.clear();
        }
        for (TableId tableId : tableIdMap.values()) {
            String tableName = tableIdToTableName.get(tableId);
            String regexTableName = this.getPoolNameForTable(tableName);
            SortedMap<TabletServerId, TServerStatus> currentView = currentGrouped.get(regexTableName);
            if (currentView == null) {
                LOG.warn("Skipping balance for table {} as no tablet servers are online.", (Object)tableName);
                continue;
            }
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            this.getBalancerForTable(tableId).balance(new BalanceParamsImpl(currentView, migrations, newMigrations));
            if (newMigrations.isEmpty()) {
                this.tableToTimeSinceNoMigrations.remove(tableId);
            } else if (this.tableToTimeSinceNoMigrations.containsKey(tableId)) {
                if (now - this.tableToTimeSinceNoMigrations.get(tableId) > TimeUnit.HOURS.toMillis(1L)) {
                    LOG.warn("We have been consistently producing migrations for {}: {}", (Object)tableName, (Object)HostRegexTableLoadBalancer.limitTen(newMigrations));
                }
            } else {
                this.tableToTimeSinceNoMigrations.put(tableId, now);
            }
            migrationsOut.addAll(newMigrations);
            if (migrationsOut.size() < myConf.maxTServerMigrations) continue;
            break;
        }
        for (TabletMigration migration : migrationsOut) {
            this.migrationsFromLastPass.put(migration.getTablet(), migration);
        }
        LOG.info("Migrating tablets for balance: {}", migrationsOut);
        return minBalanceTime;
    }

    protected List<TabletStatistics> getOnlineTabletsForTable(TabletServerId tabletServerId, TableId tableId) throws AccumuloSecurityException, AccumuloException {
        return this.environment.listOnlineTabletsForTable(tabletServerId, tableId);
    }

    private TableStatisticsImpl getTableInfo(SortedMap<TabletServerId, TServerStatusImpl> currentCopy, Multimap<TabletServerId, String> serverTableIdCopied, String tableId, TabletServerId server) {
        Map<String, TableStatistics> newTableMap;
        TableStatisticsImpl newInfo = null;
        if (currentCopy.containsKey(server) && (newTableMap = ((TServerStatusImpl)currentCopy.get(server)).getTableMap()) != null && (newInfo = (TableStatisticsImpl)newTableMap.get(tableId)) != null) {
            Collection tableIdCopied = serverTableIdCopied.get((Object)server);
            if (tableIdCopied.isEmpty()) {
                newTableMap = new HashMap<String, TableStatistics>(newTableMap);
                ((TServerStatusImpl)currentCopy.get(server)).setTableMap(newTableMap);
            }
            if (!tableIdCopied.contains(tableId)) {
                newInfo = new TableStatisticsImpl(newInfo);
                newTableMap.put(tableId, newInfo);
                tableIdCopied.add(tableId);
            }
        }
        return newInfo;
    }

    private static String limitTen(Collection<?> iterable) {
        return iterable.stream().limit(10L).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    static class HrtlbConf {
        protected long oobCheckMillis = ConfigurationTypeHelper.getTimeInMillis("5m");
        private int maxTServerMigrations = 250;
        private int maxOutstandingMigrations = 0;
        private boolean isIpBasedRegex = false;
        private final Map<String, String> regexes;
        private final Map<String, Pattern> poolNameToRegexPattern;

        HrtlbConf(PluginEnvironment.Configuration conf) {
            String outstanding;
            String migrations;
            String ipBased;
            System.out.println("building hrtlb conf");
            String oobProperty = conf.get(HOST_BALANCER_OOB_CHECK_KEY);
            if (oobProperty != null) {
                this.oobCheckMillis = ConfigurationTypeHelper.getTimeInMillis(oobProperty);
            }
            if ((ipBased = conf.get(HOST_BALANCER_REGEX_USING_IPS_KEY)) != null) {
                this.isIpBasedRegex = Boolean.parseBoolean(ipBased);
            }
            if ((migrations = conf.get(HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY)) != null) {
                this.maxTServerMigrations = Integer.parseInt(migrations);
            }
            if ((outstanding = conf.get(HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY)) != null) {
                this.maxOutstandingMigrations = Integer.parseInt(outstanding);
            }
            this.regexes = HostRegexTableLoadBalancer.getRegexes(conf);
            HashMap poolNameToRegexPatternBuilder = new HashMap();
            this.regexes.forEach((k, v) -> poolNameToRegexPatternBuilder.put(k, Pattern.compile(v)));
            this.poolNameToRegexPattern = Map.copyOf(poolNameToRegexPatternBuilder);
        }
    }
}

