/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;

public class ColumnVisibility {
    Node node = null;
    private byte[] expression;
    private static final Node EMPTY_NODE = new Node(NodeType.EMPTY, 0);

    public byte[] getExpression() {
        return this.expression;
    }

    public static Node normalize(Node root, byte[] expression) {
        return ColumnVisibility.normalize(root, expression, new NodeComparator(expression));
    }

    public static Node normalize(Node root, byte[] expression, NodeComparator comparator) {
        if (root.type != NodeType.TERM) {
            TreeSet<Node> rolledUp = new TreeSet<Node>(comparator);
            Iterator<Node> itr = root.children.iterator();
            while (itr.hasNext()) {
                Node c = ColumnVisibility.normalize(itr.next(), expression, comparator);
                if (c.type != root.type) continue;
                rolledUp.addAll(c.children);
                itr.remove();
            }
            rolledUp.addAll(root.children);
            root.children.clear();
            root.children.addAll(rolledUp);
            if (root.children.size() == 1) {
                return root.children.get(0);
            }
        }
        return root;
    }

    public static void stringify(Node root, byte[] expression, StringBuilder out) {
        if (root.type == NodeType.TERM) {
            out.append(new String(expression, root.start, root.end - root.start, StandardCharsets.UTF_8));
        } else {
            String sep = "";
            for (Node c : root.children) {
                boolean parens;
                out.append(sep);
                boolean bl = parens = c.type != NodeType.TERM && root.type != c.type;
                if (parens) {
                    out.append("(");
                }
                ColumnVisibility.stringify(c, expression, out);
                if (parens) {
                    out.append(")");
                }
                sep = root.type == NodeType.AND ? "&" : "|";
            }
        }
    }

    public byte[] flatten() {
        Node normRoot = ColumnVisibility.normalize(this.node, this.expression);
        StringBuilder builder = new StringBuilder(this.expression.length);
        ColumnVisibility.stringify(normRoot, this.expression, builder);
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void validate(byte[] expression) {
        if (expression != null && expression.length > 0) {
            ColumnVisibilityParser p = new ColumnVisibilityParser();
            this.node = p.parse(expression);
        } else {
            this.node = EMPTY_NODE;
        }
        this.expression = expression;
    }

    public ColumnVisibility() {
        this(new byte[0]);
    }

    public ColumnVisibility(String expression) {
        this(expression.getBytes(StandardCharsets.UTF_8));
    }

    public ColumnVisibility(Text expression) {
        this(TextUtil.getBytes(expression));
    }

    public ColumnVisibility(byte[] expression) {
        this.validate(expression);
    }

    public String toString() {
        return "[" + new String(this.expression, StandardCharsets.UTF_8) + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnVisibility) {
            return this.equals((ColumnVisibility)obj);
        }
        return false;
    }

    public boolean equals(ColumnVisibility otherLe) {
        return Arrays.equals(this.expression, otherLe.expression);
    }

    public int hashCode() {
        return Arrays.hashCode(this.expression);
    }

    public Node getParseTree() {
        return this.node;
    }

    public static String quote(String term) {
        return new String(ColumnVisibility.quote(term.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static byte[] quote(byte[] term) {
        boolean needsQuote = false;
        for (byte b : term) {
            if (Authorizations.isValidAuthChar(b)) continue;
            needsQuote = true;
            break;
        }
        if (!needsQuote) {
            return term;
        }
        return VisibilityEvaluator.escape(term, true);
    }

    private static class ColumnVisibilityParser {
        private int index = 0;
        private int parens = 0;

        Node parse(byte[] expression) {
            if (expression.length > 0) {
                Node node = this.parse_(expression);
                if (node == null) {
                    throw new BadArgumentException("operator or missing parens", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                if (this.parens != 0) {
                    throw new BadArgumentException("parenthesis mis-match", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                return node;
            }
            return null;
        }

        Node processTerm(int start, int end, Node expr, byte[] expression) {
            if (start != end) {
                if (expr != null) {
                    throw new BadArgumentException("expression needs | or &", new String(expression, StandardCharsets.UTF_8), start);
                }
                return new Node(start, end);
            }
            if (expr == null) {
                throw new BadArgumentException("empty term", new String(expression, StandardCharsets.UTF_8), start);
            }
            return expr;
        }

        Node parse_(byte[] expression) {
            Node result = null;
            Node expr = null;
            int wholeTermStart = this.index;
            int subtermStart = this.index;
            boolean subtermComplete = false;
            block7: while (this.index < expression.length) {
                switch (expression[this.index++]) {
                    case 38: {
                        expr = this.processTerm(subtermStart, this.index - 1, expr, expression);
                        if (result != null) {
                            if (!result.type.equals((Object)NodeType.AND)) {
                                throw new BadArgumentException("cannot mix & and |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                            }
                        } else {
                            result = new Node(NodeType.AND, wholeTermStart);
                        }
                        result.add(expr);
                        expr = null;
                        subtermStart = this.index;
                        subtermComplete = false;
                        continue block7;
                    }
                    case 124: {
                        expr = this.processTerm(subtermStart, this.index - 1, expr, expression);
                        if (result != null) {
                            if (!result.type.equals((Object)NodeType.OR)) {
                                throw new BadArgumentException("cannot mix | and &", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                            }
                        } else {
                            result = new Node(NodeType.OR, wholeTermStart);
                        }
                        result.add(expr);
                        expr = null;
                        subtermStart = this.index;
                        subtermComplete = false;
                        continue block7;
                    }
                    case 40: {
                        ++this.parens;
                        if (subtermStart != this.index - 1 || expr != null) {
                            throw new BadArgumentException("expression needs & or |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                        }
                        expr = this.parse_(expression);
                        subtermStart = this.index;
                        subtermComplete = false;
                        continue block7;
                    }
                    case 41: {
                        --this.parens;
                        Node child = this.processTerm(subtermStart, this.index - 1, expr, expression);
                        if (child == null && result == null) {
                            throw new BadArgumentException("empty expression not allowed", new String(expression, StandardCharsets.UTF_8), this.index);
                        }
                        if (result == null) {
                            return child;
                        }
                        if (result.type == child.type) {
                            for (Node c : child.children) {
                                result.add(c);
                            }
                        } else {
                            result.add(child);
                        }
                        result.end = this.index - 1;
                        return result;
                    }
                    case 34: {
                        if (subtermStart != this.index - 1) {
                            throw new BadArgumentException("expression needs & or |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                        }
                        while (this.index < expression.length && expression[this.index] != 34) {
                            if (expression[this.index] == 92) {
                                ++this.index;
                                if (this.index == expression.length || expression[this.index] != 92 && expression[this.index] != 34) {
                                    throw new BadArgumentException("invalid escaping within quotes", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                                }
                            }
                            ++this.index;
                        }
                        if (this.index == expression.length) {
                            throw new BadArgumentException("unclosed quote", new String(expression, StandardCharsets.UTF_8), subtermStart);
                        }
                        if (subtermStart + 1 == this.index) {
                            throw new BadArgumentException("empty term", new String(expression, StandardCharsets.UTF_8), subtermStart);
                        }
                        ++this.index;
                        subtermComplete = true;
                        continue block7;
                    }
                }
                if (subtermComplete) {
                    throw new BadArgumentException("expression needs & or |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                byte c = expression[this.index - 1];
                if (Authorizations.isValidAuthChar(c)) continue;
                throw new BadArgumentException("bad character (" + c + ")", new String(expression, StandardCharsets.UTF_8), this.index - 1);
            }
            Node child = this.processTerm(subtermStart, this.index, expr, expression);
            if (result != null) {
                result.add(child);
                result.end = this.index;
            } else {
                result = child;
            }
            if (result.type != NodeType.TERM && result.children.size() < 2) {
                throw new BadArgumentException("missing term", new String(expression, StandardCharsets.UTF_8), this.index);
            }
            return result;
        }
    }

    public static class NodeComparator
    implements Comparator<Node>,
    Serializable {
        private static final long serialVersionUID = 1L;
        byte[] text;

        public NodeComparator(byte[] text) {
            this.text = text;
        }

        @Override
        public int compare(Node a, Node b) {
            int diff = a.type.ordinal() - b.type.ordinal();
            if (diff != 0) {
                return diff;
            }
            switch (a.type) {
                case EMPTY: {
                    return 0;
                }
                case TERM: {
                    return WritableComparator.compareBytes((byte[])this.text, (int)a.start, (int)(a.end - a.start), (byte[])this.text, (int)b.start, (int)(b.end - b.start));
                }
                case OR: 
                case AND: {
                    diff = a.children.size() - b.children.size();
                    if (diff != 0) {
                        return diff;
                    }
                    for (int i = 0; i < a.children.size(); ++i) {
                        diff = this.compare(a.children.get(i), b.children.get(i));
                        if (diff == 0) continue;
                        return diff;
                    }
                    break;
                }
            }
            return 0;
        }
    }

    public static class Node {
        public static final List<Node> EMPTY = Collections.emptyList();
        NodeType type;
        int start;
        int end;
        List<Node> children = EMPTY;

        public Node(NodeType type, int start) {
            this.type = type;
            this.start = start;
            this.end = start + 1;
        }

        public Node(int start, int end) {
            this.type = NodeType.TERM;
            this.start = start;
            this.end = end;
        }

        public void add(Node child) {
            if (this.children == EMPTY) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(child);
        }

        public NodeType getType() {
            return this.type;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public int getTermStart() {
            return this.start;
        }

        public int getTermEnd() {
            return this.end;
        }

        public ByteSequence getTerm(byte[] expression) {
            if (this.type != NodeType.TERM) {
                throw new RuntimeException();
            }
            if (expression[this.start] == 34) {
                int qStart = this.start + 1;
                int qEnd = this.end - 1;
                return new ArrayByteSequence(expression, qStart, qEnd - qStart);
            }
            return new ArrayByteSequence(expression, this.start, this.end - this.start);
        }
    }

    public static enum NodeType {
        EMPTY,
        TERM,
        OR,
        AND;

    }
}

