/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.Value;

public class DataFileValue {
    private long size;
    private long numEntries;
    private long time = -1L;

    public DataFileValue(long size, long numEntries, long time) {
        this.size = size;
        this.numEntries = numEntries;
        this.time = time;
    }

    public DataFileValue(long size, long numEntries) {
        this.size = size;
        this.numEntries = numEntries;
        this.time = -1L;
    }

    public DataFileValue(String encodedDFV) {
        String[] ba = encodedDFV.split(",");
        this.size = Long.parseLong(ba[0]);
        this.numEntries = Long.parseLong(ba[1]);
        this.time = ba.length == 3 ? Long.parseLong(ba[2]) : -1L;
    }

    public DataFileValue(byte[] encodedDFV) {
        this(new String(encodedDFV, StandardCharsets.UTF_8));
    }

    public long getSize() {
        return this.size;
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public boolean isTimeSet() {
        return this.time >= 0L;
    }

    public long getTime() {
        return this.time;
    }

    public byte[] encode() {
        return this.encodeAsString().getBytes(StandardCharsets.UTF_8);
    }

    public String encodeAsString() {
        if (this.time >= 0L) {
            return this.size + "," + this.numEntries + "," + this.time;
        }
        return this.size + "," + this.numEntries;
    }

    public Value encodeAsValue() {
        return new Value(this.encode());
    }

    public boolean equals(Object o) {
        if (o instanceof DataFileValue) {
            DataFileValue odfv = (DataFileValue)o;
            return this.size == odfv.size && this.numEntries == odfv.numEntries;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.size + this.numEntries).hashCode();
    }

    public String toString() {
        return this.size + " " + this.numEntries;
    }

    public void setTime(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.time = time;
    }
}

