/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class Column
implements WritableComparable<Column> {
    private static final Comparator<byte[]> BYTE_COMPARATOR = Comparator.nullsFirst((a, b) -> WritableComparator.compareBytes((byte[])a, (int)0, (int)((byte[])a).length, (byte[])b, (int)0, (int)((byte[])b).length));
    private static final Comparator<Column> COMPARATOR = Comparator.comparing(Column::getColumnFamily, BYTE_COMPARATOR).thenComparing(Column::getColumnQualifier, BYTE_COMPARATOR).thenComparing(Column::getColumnVisibility, BYTE_COMPARATOR);
    public byte[] columnFamily;
    public byte[] columnQualifier;
    public byte[] columnVisibility;

    public int compareTo(Column that) {
        return COMPARATOR.compare(this, that);
    }

    public void readFields(DataInput in) throws IOException {
        int len;
        if (in.readBoolean()) {
            len = in.readInt();
            this.columnFamily = new byte[len];
            in.readFully(this.columnFamily);
        } else {
            this.columnFamily = null;
        }
        if (in.readBoolean()) {
            len = in.readInt();
            this.columnQualifier = new byte[len];
            in.readFully(this.columnQualifier);
        } else {
            this.columnQualifier = null;
        }
        if (in.readBoolean()) {
            len = in.readInt();
            this.columnVisibility = new byte[len];
            in.readFully(this.columnVisibility);
        } else {
            this.columnVisibility = null;
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.columnFamily == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.columnFamily.length);
            out.write(this.columnFamily);
        }
        if (this.columnQualifier == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.columnQualifier.length);
            out.write(this.columnQualifier);
        }
        if (this.columnVisibility == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.columnVisibility.length);
            out.write(this.columnVisibility);
        }
    }

    public Column() {
    }

    public Column(byte[] columnFamily, byte[] columnQualifier, byte[] columnVisibility) {
        this();
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnVisibility = columnVisibility;
    }

    public Column(TColumn tcol) {
        this(ByteBufferUtil.toBytes(tcol.columnFamily), ByteBufferUtil.toBytes(tcol.columnQualifier), ByteBufferUtil.toBytes(tcol.columnVisibility));
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Column) {
            return this.equals((Column)that);
        }
        return false;
    }

    public boolean equals(Column that) {
        return this.compareTo(that) == 0;
    }

    private static int hash(byte[] b) {
        if (b == null) {
            return 0;
        }
        return WritableComparator.hashBytes((byte[])b, (int)b.length);
    }

    public int hashCode() {
        return Column.hash(this.columnFamily) + Column.hash(this.columnQualifier) + Column.hash(this.columnVisibility);
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public byte[] getColumnQualifier() {
        return this.columnQualifier;
    }

    public byte[] getColumnVisibility() {
        return this.columnVisibility;
    }

    public String toString() {
        return new String(this.columnFamily == null ? new byte[]{} : this.columnFamily, StandardCharsets.UTF_8) + ":" + new String(this.columnQualifier == null ? new byte[]{} : this.columnQualifier, StandardCharsets.UTF_8) + ":" + new String(this.columnVisibility == null ? new byte[]{} : this.columnVisibility, StandardCharsets.UTF_8);
    }

    public TColumn toThrift() {
        return new TColumn(this.columnFamily == null ? null : ByteBuffer.wrap(this.columnFamily), this.columnQualifier == null ? null : ByteBuffer.wrap(this.columnQualifier), this.columnVisibility == null ? null : ByteBuffer.wrap(this.columnVisibility));
    }
}

