/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoFactoryLoader;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorBuilder;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SystemIteratorUtil;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

class OfflineIterator
implements Iterator<Map.Entry<Key, Value>> {
    private SortedKeyValueIterator<Key, Value> iter;
    private Range range;
    private KeyExtent currentExtent;
    private final TableId tableId;
    private final Authorizations authorizations;
    private final ClientContext context;
    private final ScannerOptions options;
    private final ArrayList<SortedKeyValueIterator<Key, Value>> readers;

    public OfflineIterator(ScannerOptions options, ClientContext context, Authorizations authorizations, Text table, Range range) {
        this.options = new ScannerOptions(options);
        this.context = context;
        this.range = range;
        if (!this.options.fetchedColumns.isEmpty()) {
            this.range = range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last());
        }
        this.tableId = TableId.of(table.toString());
        this.authorizations = authorizations;
        this.readers = new ArrayList();
        try {
            this.nextTablet();
            while (this.iter != null && !this.iter.hasTop()) {
                this.nextTablet();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasTop();
    }

    @Override
    public Map.Entry<Key, Value> next() {
        try {
            byte[] v = this.iter.getTopValue().get();
            KeyValue ret = new KeyValue(new Key(this.iter.getTopKey()), Arrays.copyOf(v, v.length));
            this.iter.next();
            while (this.iter != null && !this.iter.hasTop()) {
                this.nextTablet();
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void nextTablet() throws TableNotFoundException, AccumuloException, IOException, AccumuloSecurityException {
        Range nextRange;
        if (this.currentExtent == null) {
            Text startRow = this.range.getStartKey() != null ? this.range.getStartKey().getRow() : new Text();
            nextRange = new Range(MetadataSchema.TabletsSection.encodeRow(this.tableId, startRow), true, null, false);
        } else {
            if (this.currentExtent.endRow() == null || this.range.afterEndKey(new Key(this.currentExtent.endRow()).followingKey(PartialKey.ROW))) {
                this.iter = null;
                return;
            }
            nextRange = new Range(this.currentExtent.toMetaRow(), false, null, false);
        }
        TabletMetadata tablet = this.getTabletFiles(nextRange);
        while (tablet.getLocation() != null) {
            if (this.context.getTableState(this.tableId) != TableState.OFFLINE) {
                this.context.clearTableListCache();
                if (this.context.getTableState(this.tableId) != TableState.OFFLINE) {
                    throw new AccumuloException("Table is online " + this.tableId + " cannot scan tablet in offline mode " + tablet.getExtent());
                }
            }
            UtilWaitThread.sleepUninterruptibly(250L, TimeUnit.MILLISECONDS);
            tablet = this.getTabletFiles(nextRange);
        }
        if (!tablet.getExtent().tableId().equals(this.tableId)) {
            throw new AccumuloException(" did not find tablets for table " + this.tableId + " " + tablet.getExtent());
        }
        if (this.currentExtent != null && !tablet.getExtent().isPreviousExtent(this.currentExtent)) {
            throw new AccumuloException(" " + this.currentExtent + " is not previous extent " + tablet.getExtent());
        }
        this.iter = this.createIterator(tablet.getExtent(), tablet.getFiles());
        this.iter.seek(this.range, LocalityGroupUtil.families(this.options.fetchedColumns), !this.options.fetchedColumns.isEmpty());
        this.currentExtent = tablet.getExtent();
    }

    private TabletMetadata getTabletFiles(Range nextRange) {
        try (TabletsMetadata tablets = TabletsMetadata.builder(this.context).scanMetadataTable().overRange(nextRange).fetch(TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW).build();){
            TabletMetadata tabletMetadata = tablets.iterator().next();
            return tabletMetadata;
        }
    }

    private SortedKeyValueIterator<Key, Value> createIterator(KeyExtent extent, Collection<StoredTabletFile> absFiles) throws TableNotFoundException, AccumuloException, IOException, AccumuloSecurityException {
        String tableName = this.context.getTableName(this.tableId);
        Map<String, String> tableConf = this.context.tableOperations().getConfiguration(tableName);
        ConfigurationCopy tableCC = new ConfigurationCopy(tableConf);
        Map<String, String> systemConf = this.context.instanceOperations().getSystemConfiguration();
        Configuration conf = this.context.getHadoopConf();
        for (SortedKeyValueIterator<Key, Value> reader : this.readers) {
            ((FileSKVIterator)reader).close();
        }
        this.readers.clear();
        SamplerConfiguration scannerSamplerConfig = this.options.getSamplerConfiguration();
        SamplerConfigurationImpl scannerSamplerConfigImpl = scannerSamplerConfig == null ? null : new SamplerConfigurationImpl(scannerSamplerConfig);
        SamplerConfigurationImpl samplerConfImpl = SamplerConfigurationImpl.newSamplerConfig(tableCC);
        if (scannerSamplerConfigImpl != null && !scannerSamplerConfigImpl.equals(samplerConfImpl)) {
            throw new SampleNotPresentException();
        }
        for (TabletFile tabletFile : absFiles) {
            CryptoService cs = CryptoFactoryLoader.getServiceForClientWithTable(systemConf, tableConf, this.tableId);
            FileSystem fs = VolumeConfiguration.fileSystemForPath(tabletFile.getPathStr(), conf);
            FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(tabletFile.getPathStr(), fs, conf, cs).withTableConfiguration(tableCC).build();
            if (scannerSamplerConfigImpl != null && (reader = reader.getSample(scannerSamplerConfigImpl)) == null) {
                throw new SampleNotPresentException();
            }
            this.readers.add(reader);
        }
        MultiIterator multiIter = new MultiIterator(this.readers, extent);
        OfflineIteratorEnvironment offlineIteratorEnvironment = new OfflineIteratorEnvironment(this.authorizations, tableCC, false, samplerConfImpl == null ? null : samplerConfImpl.toSamplerConfiguration());
        ColumnVisibility cv = new ColumnVisibility(((AccumuloConfiguration)tableCC).get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY));
        byte[] defaultSecurityLabel = cv.getExpression();
        SortedKeyValueIterator<Key, Value> visFilter = SystemIteratorUtil.setupSystemScanIterators(multiIter, new HashSet<Column>(this.options.fetchedColumns), this.authorizations, defaultSecurityLabel, tableCC);
        IteratorBuilder.IteratorBuilderEnv iteratorBuilderEnv = IteratorConfigUtil.loadIterConf(IteratorUtil.IteratorScope.scan, this.options.serverSideIteratorList, this.options.serverSideIteratorOptions, tableCC);
        IteratorBuilder iteratorBuilder = iteratorBuilderEnv.env(offlineIteratorEnvironment).build();
        return offlineIteratorEnvironment.getTopLevelIterator(IteratorConfigUtil.loadIterators(visFilter, iteratorBuilder));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class OfflineIteratorEnvironment
    implements IteratorEnvironment {
        private final Authorizations authorizations;
        private final AccumuloConfiguration conf;
        private final boolean useSample;
        private final SamplerConfiguration sampleConf;
        private final ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators = new ArrayList();

        public OfflineIteratorEnvironment(Authorizations auths, AccumuloConfiguration acuTableConf, boolean useSample, SamplerConfiguration samplerConf) {
            this.authorizations = auths;
            this.conf = acuTableConf;
            this.useSample = useSample;
            this.sampleConf = samplerConf;
        }

        @Override
        @Deprecated(since="2.0.0")
        public AccumuloConfiguration getConfig() {
            return this.conf;
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public boolean isUserCompaction() {
            return false;
        }

        @Override
        @Deprecated(since="2.0.0")
        public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
            this.topLevelIterators.add(iter);
        }

        @Override
        public Authorizations getAuthorizations() {
            return this.authorizations;
        }

        SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
            if (this.topLevelIterators.isEmpty()) {
                return iter;
            }
            ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
            allIters.add(iter);
            return new MultiIterator(allIters, false);
        }

        @Override
        public boolean isSamplingEnabled() {
            return this.useSample;
        }

        @Override
        public SamplerConfiguration getSamplerConfiguration() {
            return this.sampleConf;
        }

        @Override
        public IteratorEnvironment cloneWithSamplingEnabled() {
            if (this.sampleConf == null) {
                throw new SampleNotPresentException();
            }
            return new OfflineIteratorEnvironment(this.authorizations, this.conf, true, this.sampleConf);
        }
    }
}

