/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.clientImpl.ActiveCompactionImpl;
import org.apache.accumulo.core.clientImpl.ActiveScanImpl;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ConfigurationType;
import org.apache.accumulo.core.clientImpl.thrift.TVersionedProperties;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.DeprecatedPropertyUtil;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceOperationsImpl
implements InstanceOperations {
    private final ClientContext context;

    public InstanceOperationsImpl(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
    }

    @Override
    public void setProperty(String property, String value) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException {
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        DeprecatedPropertyUtil.getReplacementName(property, (log, replacement) -> log.warn("{} was deprecated and will be removed in a future release; setting its replacement {} instead", (Object)property, replacement));
        ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.setSystemProperty(TraceUtil.traceInfo(), this.context.rpcCreds(), property, value));
        this.checkLocalityGroups(property);
    }

    private Map<String, String> tryToModifyProperties(Consumer<Map<String, String>> mapMutator) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException {
        Preconditions.checkArgument((mapMutator != null ? 1 : 0) != 0, (Object)"mapMutator is null");
        TVersionedProperties vProperties = ThriftClientTypes.CLIENT.execute(this.context, client -> client.getVersionedSystemProperties(TraceUtil.traceInfo(), this.context.rpcCreds()));
        mapMutator.accept(vProperties.getProperties());
        vProperties.setProperties(Map.copyOf(vProperties.getProperties()));
        for (Map.Entry<String, String> entry : vProperties.getProperties().entrySet()) {
            String property = Objects.requireNonNull(entry.getKey(), "property key is null");
            DeprecatedPropertyUtil.getReplacementName(property, (log, replacement) -> log.warn("{} was deprecated and will be removed in a future release; setting its replacement {} instead", (Object)property, replacement));
            this.checkLocalityGroups(property);
        }
        ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.modifySystemProperties(TraceUtil.traceInfo(), this.context.rpcCreds(), vProperties));
        return vProperties.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> modifyProperties(Consumer<Map<String, String>> mapMutator) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException {
        Logger log = LoggerFactory.getLogger(InstanceOperationsImpl.class);
        Retry retry = Retry.builder().infiniteRetries().retryAfter(25L, TimeUnit.MILLISECONDS).incrementBy(25L, TimeUnit.MILLISECONDS).maxWait(30L, TimeUnit.SECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createRetry();
        while (true) {
            try {
                Map<String, String> props = this.tryToModifyProperties(mapMutator);
                retry.logCompletion(log, "Modifying instance properties");
                Map<String, String> map = props;
                return map;
            }
            catch (ConcurrentModificationException cme) {
                try {
                    retry.logRetry(log, "Unable to modify instance properties for because of concurrent modification");
                    retry.waitForNextAttempt(log, "Modify instance properties");
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                retry.useRetry();
                continue;
            }
            break;
        }
    }

    @Override
    public void removeProperty(String property) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        DeprecatedPropertyUtil.getReplacementName(property, (log, replacement) -> log.warn("{} was deprecated and will be removed in a future release; assuming user meant its replacement {} and will remove that instead", (Object)property, replacement));
        ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.removeSystemProperty(TraceUtil.traceInfo(), this.context.rpcCreds(), property));
        this.checkLocalityGroups(property);
    }

    private void checkLocalityGroups(String propChanged) throws AccumuloSecurityException, AccumuloException {
        if (LocalityGroupUtil.isLocalityGroupProperty(propChanged)) {
            try {
                LocalityGroupUtil.checkLocalityGroups(this.getSystemConfiguration());
            }
            catch (RuntimeException | LocalityGroupUtil.LocalityGroupConfigurationError e) {
                LoggerFactory.getLogger(this.getClass()).warn("Changing '" + propChanged + "' resulted in bad locality group config. This may be a transient situation since the config spreads over multiple properties. Setting properties in a different order may help. Even though this warning was displayed, the property was updated. Please check your config to ensure consistency.", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> getSystemConfiguration() throws AccumuloException, AccumuloSecurityException {
        return ThriftClientTypes.CLIENT.execute(this.context, client -> client.getConfiguration(TraceUtil.traceInfo(), this.context.rpcCreds(), ConfigurationType.CURRENT));
    }

    @Override
    public Map<String, String> getSiteConfiguration() throws AccumuloException, AccumuloSecurityException {
        return ThriftClientTypes.CLIENT.execute(this.context, client -> client.getConfiguration(TraceUtil.traceInfo(), this.context.rpcCreds(), ConfigurationType.SITE));
    }

    @Override
    public List<String> getManagerLocations() {
        return this.context.getManagerLocations();
    }

    @Override
    public Set<String> getScanServers() {
        return Set.copyOf(this.context.getScanServers().keySet());
    }

    @Override
    public List<String> getTabletServers() {
        ZooCache cache = this.context.getZooCache();
        String path = this.context.getZooKeeperRoot() + "/tservers";
        ArrayList<String> results = new ArrayList<String>();
        for (String candidate : cache.getChildren(path)) {
            List<String> children = cache.getChildren(path + "/" + candidate);
            if (children == null || children.isEmpty()) continue;
            ArrayList<String> copy = new ArrayList<String>(children);
            Collections.sort(copy);
            byte[] data = cache.get(path + "/" + candidate + "/" + copy.get(0));
            if (data == null || "manager".equals(new String(data, StandardCharsets.UTF_8))) continue;
            results.add(candidate);
        }
        return results;
    }

    @Override
    public List<org.apache.accumulo.core.client.admin.ActiveScan> getActiveScans(String tserver) throws AccumuloException, AccumuloSecurityException {
        HostAndPort parsedTserver = HostAndPort.fromString(tserver);
        TabletScanClientService.Client client = null;
        try {
            client = ThriftUtil.getClient(ThriftClientTypes.TABLET_SCAN, parsedTserver, this.context);
            ArrayList<ActiveScanImpl> as = new ArrayList<ActiveScanImpl>();
            for (ActiveScan activeScan : client.getActiveScans(TraceUtil.traceInfo(), this.context.rpcCreds())) {
                try {
                    as.add(new ActiveScanImpl(this.context, activeScan));
                }
                catch (TableNotFoundException e) {
                    throw new AccumuloException(e);
                }
            }
            ArrayList<ActiveScanImpl> arrayList = as;
            return arrayList;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ThriftUtil.returnClient(client, this.context);
            }
        }
    }

    @Override
    public boolean testClassLoad(String className, String asTypeName) throws AccumuloException, AccumuloSecurityException {
        return ThriftClientTypes.CLIENT.execute(this.context, client -> client.checkClass(TraceUtil.traceInfo(), this.context.rpcCreds(), className, asTypeName));
    }

    @Override
    public List<org.apache.accumulo.core.client.admin.ActiveCompaction> getActiveCompactions(String tserver) throws AccumuloException, AccumuloSecurityException {
        HostAndPort parsedTserver = HostAndPort.fromString(tserver);
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getClient(ThriftClientTypes.TABLET_SERVER, parsedTserver, this.context);
            ArrayList<ActiveCompactionImpl> as = new ArrayList<ActiveCompactionImpl>();
            for (ActiveCompaction tac : client.getActiveCompactions(TraceUtil.traceInfo(), this.context.rpcCreds())) {
                as.add(new ActiveCompactionImpl(this.context, tac, parsedTserver, ActiveCompaction.CompactionHost.Type.TSERVER));
            }
            ArrayList<ActiveCompactionImpl> arrayList = as;
            return arrayList;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ThriftUtil.returnClient(client, this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<org.apache.accumulo.core.client.admin.ActiveCompaction> getActiveCompactions() throws AccumuloException, AccumuloSecurityException {
        Map<String, List<HostAndPort>> compactors = ExternalCompactionUtil.getCompactorAddrs(this.context);
        List<String> tservers = this.getTabletServers();
        int numThreads = Math.max(4, Math.min((tservers.size() + compactors.size()) / 10, 256));
        ThreadPoolExecutor executorService = this.context.threadPools().createFixedThreadPool(numThreads, "getactivecompactions", false);
        try {
            ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
            for (String tserver : tservers) {
                futures.add(executorService.submit(() -> this.getActiveCompactions(tserver)));
            }
            compactors.values().forEach(compactorList -> {
                for (HostAndPort compactorAddr : compactorList) {
                    Callable<List> task = () -> ExternalCompactionUtil.getActiveCompaction(compactorAddr, this.context).stream().map(tac -> new ActiveCompactionImpl(this.context, (ActiveCompaction)tac, compactorAddr, ActiveCompaction.CompactionHost.Type.COMPACTOR)).collect(Collectors.toList());
                    futures.add(executorService.submit(task));
                }
            });
            ArrayList ret = new ArrayList();
            for (Future future : futures) {
                try {
                    ret.addAll((Collection)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof ThriftSecurityException) {
                        ThriftSecurityException tse = (ThriftSecurityException)((Object)e.getCause());
                        throw new AccumuloSecurityException(tse.user, tse.code, e);
                    }
                    throw new AccumuloException(e);
                }
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            executorService.shutdown();
        }
    }

    @Override
    public void ping(String tserver) throws AccumuloException {
        try (TTransport transport = ThriftUtil.createTransport(AddressUtil.parseAddress(tserver, false), this.context);){
            TabletClientService.Client client = ThriftUtil.createClient(ThriftClientTypes.TABLET_SERVER, transport);
            client.getTabletServerStatus(TraceUtil.traceInfo(), this.context.rpcCreds());
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void waitForBalance() throws AccumuloException {
        try {
            ThriftClientTypes.MANAGER.executeVoid(this.context, client -> client.waitForBalance(TraceUtil.traceInfo()));
        }
        catch (AccumuloSecurityException ex) {
            throw new RuntimeException("Unexpected exception thrown", ex);
        }
    }

    public static String lookupInstanceName(ZooCache zooCache, InstanceId instanceId) {
        Preconditions.checkArgument((zooCache != null ? 1 : 0) != 0, (Object)"zooCache is null");
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"instanceId is null");
        for (String name : zooCache.getChildren("/accumulo/instances")) {
            byte[] bytes = zooCache.get("/accumulo/instances/" + name);
            InstanceId iid = InstanceId.of(new String(bytes, StandardCharsets.UTF_8));
            if (!iid.equals(instanceId)) continue;
            return name;
        }
        return null;
    }

    @Override
    @Deprecated(since="2.1.0")
    public String getInstanceID() {
        return this.getInstanceId().canonical();
    }

    @Override
    public InstanceId getInstanceId() {
        return this.context.getInstanceID();
    }
}

