/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.util.UnsynchronizedBuffer;

public class CompressedIterators {
    private Map<String, Integer> symbolMap;
    private List<String> symbolTable;

    public CompressedIterators() {
        this.symbolMap = new HashMap<String, Integer>();
        this.symbolTable = new ArrayList<String>();
    }

    public CompressedIterators(List<String> symbols) {
        this.symbolTable = symbols;
    }

    private int getSymbolID(String symbol) {
        Integer id = this.symbolMap.get(symbol);
        if (id == null) {
            id = this.symbolTable.size();
            this.symbolTable.add(symbol);
            this.symbolMap.put(symbol, id);
        }
        return id;
    }

    public ByteBuffer compress(IteratorSetting[] iterators) {
        UnsynchronizedBuffer.Writer out = new UnsynchronizedBuffer.Writer(iterators.length * 8);
        out.writeVInt(iterators.length);
        for (IteratorSetting is : iterators) {
            out.writeVInt(this.getSymbolID(is.getName()));
            out.writeVInt(this.getSymbolID(is.getIteratorClass()));
            out.writeVInt(is.getPriority());
            Map<String, String> opts = is.getOptions();
            out.writeVInt(opts.size());
            for (Map.Entry<String, String> entry : opts.entrySet()) {
                out.writeVInt(this.getSymbolID(entry.getKey()));
                out.writeVInt(this.getSymbolID(entry.getValue()));
            }
        }
        return out.toByteBuffer();
    }

    public IterConfig decompress(ByteBuffer iterators) {
        IterConfig config = new IterConfig();
        UnsynchronizedBuffer.Reader in = new UnsynchronizedBuffer.Reader(iterators);
        int num = in.readVInt();
        for (int i = 0; i < num; ++i) {
            String name = this.symbolTable.get(in.readVInt());
            String iterClass = this.symbolTable.get(in.readVInt());
            int prio = in.readVInt();
            config.ssiList.add(new IterInfo(prio, iterClass, name));
            int numOpts = in.readVInt();
            HashMap<String, String> opts = new HashMap<String, String>();
            for (int j = 0; j < numOpts; ++j) {
                String key = this.symbolTable.get(in.readVInt());
                String val = this.symbolTable.get(in.readVInt());
                opts.put(key, val);
            }
            config.ssio.put(name, opts);
        }
        return config;
    }

    public List<String> getSymbolTable() {
        return this.symbolTable;
    }

    public static class IterConfig {
        public List<IterInfo> ssiList = new ArrayList<IterInfo>();
        public Map<String, Map<String, String>> ssio = new HashMap<String, Map<String, String>>();
    }
}

