/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.rfile.RFileScannerBuilder;
import org.apache.accumulo.core.client.rfile.RFileSource;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoFactoryLoader;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheConfiguration;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheManagerFactory;
import org.apache.accumulo.core.file.blockfile.impl.BasicCacheProvider;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.iterators.IteratorAdapter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorBuilder;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SystemIteratorUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheEntry;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;

class RFileScanner
extends ScannerOptions
implements Scanner {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Range EMPTY_RANGE = new Range();
    private Range range;
    private BlockCacheManager blockCacheManager = null;
    private BlockCache dataCache = null;
    private BlockCache indexCache = null;
    private Opts opts;
    private int batchSize = 1000;
    private long readaheadThreshold = 3L;
    private AccumuloConfiguration tableConf;
    private CryptoService cryptoService;

    RFileScanner(Opts opts) {
        if (!opts.auths.equals(Authorizations.EMPTY) && !opts.useSystemIterators) {
            throw new IllegalArgumentException("Set authorizations and specified not to use system iterators");
        }
        this.opts = opts;
        if (opts.tableConfig != null && !opts.tableConfig.isEmpty()) {
            ConfigurationCopy tableCC = new ConfigurationCopy(DefaultConfiguration.getInstance());
            opts.tableConfig.forEach(tableCC::set);
            this.tableConf = tableCC;
        } else {
            this.tableConf = DefaultConfiguration.getInstance();
        }
        if (opts.indexCacheSize > 0L || opts.dataCacheSize > 0L) {
            ConfigurationCopy cc = this.tableConf instanceof ConfigurationCopy ? (ConfigurationCopy)this.tableConf : new ConfigurationCopy(this.tableConf);
            try {
                this.blockCacheManager = BlockCacheManagerFactory.getClientInstance(cc);
                if (opts.indexCacheSize > 0L) {
                    cc.set(Property.TSERV_INDEXCACHE_SIZE, Long.toString(opts.indexCacheSize));
                }
                if (opts.dataCacheSize > 0L) {
                    cc.set(Property.TSERV_DATACACHE_SIZE, Long.toString(opts.dataCacheSize));
                }
                this.blockCacheManager.start(BlockCacheConfiguration.forTabletServer(cc));
                this.indexCache = this.blockCacheManager.getBlockCache(CacheType.INDEX);
                this.dataCache = this.blockCacheManager.getBlockCache(CacheType.DATA);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.indexCache == null) {
            this.indexCache = new NoopCache();
        }
        if (this.dataCache == null) {
            this.dataCache = new NoopCache();
        }
        this.cryptoService = CryptoFactoryLoader.getServiceForClient(CryptoEnvironment.Scope.TABLE, opts.tableConfig);
    }

    @Override
    public synchronized void fetchColumnFamily(Text col) {
        Preconditions.checkArgument((boolean)this.opts.useSystemIterators, (Object)"Can only fetch columns when using system iterators");
        super.fetchColumnFamily(col);
    }

    @Override
    public synchronized void fetchColumn(Text colFam, Text colQual) {
        Preconditions.checkArgument((boolean)this.opts.useSystemIterators, (Object)"Can only fetch columns when using system iterators");
        super.fetchColumn(colFam, colQual);
    }

    @Override
    public void fetchColumn(IteratorSetting.Column column) {
        Preconditions.checkArgument((boolean)this.opts.useSystemIterators, (Object)"Can only fetch columns when using system iterators");
        super.fetchColumn(column);
    }

    @Override
    public void setClassLoaderContext(String classLoaderContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void enableIsolation() {
    }

    @Override
    public void disableIsolation() {
    }

    @Override
    public synchronized void setReadaheadThreshold(long batches) {
        Preconditions.checkArgument((batches > 0L ? 1 : 0) != 0);
        this.readaheadThreshold = batches;
    }

    @Override
    public synchronized long getReadaheadThreshold() {
        return this.readaheadThreshold;
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.opts.auths;
    }

    @Override
    public void addScanIterator(IteratorSetting cfg) {
        super.addScanIterator(cfg);
    }

    @Override
    public void removeScanIterator(String iteratorName) {
        super.removeScanIterator(iteratorName);
    }

    @Override
    public void updateScanIteratorOption(String iteratorName, String key, String value) {
        super.updateScanIteratorOption(iteratorName, key, value);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        try {
            int i;
            RFileSource[] sources = this.opts.in.getSources();
            ArrayList<SortedKeyValueIterator<Key, Value>> readers = new ArrayList<SortedKeyValueIterator<Key, Value>>(sources.length);
            BasicCacheProvider cacheProvider = new BasicCacheProvider(this.indexCache, this.dataCache);
            for (i = 0; i < sources.length; ++i) {
                FSDataInputStream inputStream = (FSDataInputStream)sources[i].getInputStream();
                CachableBlockFile.CachableBuilder cb = new CachableBlockFile.CachableBuilder().input((InputStream)inputStream, "source-" + i).length(sources[i].getLength()).conf(this.opts.in.getConf()).cacheProvider(cacheProvider).cryptoService(this.cryptoService);
                readers.add(new RFile.Reader(cb));
            }
            if (this.getSamplerConfiguration() != null) {
                for (i = 0; i < readers.size(); ++i) {
                    readers.set(i, ((RFile.Reader)readers.get(i)).getSample(new SamplerConfigurationImpl(this.getSamplerConfiguration())));
                }
            }
            SortedKeyValueIterator<Key, Value> iterator = this.opts.bounds != null ? new MultiIterator(readers, this.opts.bounds) : new MultiIterator(readers, false);
            Set<Object> families = Collections.emptySet();
            if (this.opts.useSystemIterators) {
                SortedSet<Column> cols = this.getFetchedColumns();
                families = LocalityGroupUtil.families(cols);
                iterator = SystemIteratorUtil.setupSystemScanIterators(iterator, cols, this.getAuthorizations(), EMPTY_BYTES, this.tableConf);
            }
            try {
                if (this.opts.tableConfig != null && !this.opts.tableConfig.isEmpty()) {
                    IteratorBuilder.IteratorBuilderEnv ibEnv = IteratorConfigUtil.loadIterConf(IteratorUtil.IteratorScope.scan, this.serverSideIteratorList, this.serverSideIteratorOptions, this.tableConf);
                    IteratorBuilder iteratorBuilder = ibEnv.env(new IterEnv()).build();
                    iterator = IteratorConfigUtil.loadIterators(iterator, iteratorBuilder);
                } else {
                    IteratorBuilder iteratorBuilder = IteratorBuilder.builder(this.serverSideIteratorList).opts(this.serverSideIteratorOptions).env(new IterEnv()).build();
                    iterator = IteratorConfigUtil.loadIterators(iterator, iteratorBuilder);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            iterator.seek(this.getRange() == null ? EMPTY_RANGE : this.getRange(), families, !families.isEmpty());
            return new IteratorAdapter(iterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            for (RFileSource source : this.opts.in.getSources()) {
                source.getInputStream().close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.blockCacheManager != null) {
                this.blockCacheManager.stop();
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private class IterEnv
    implements IteratorEnvironment {
        private IterEnv() {
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public Authorizations getAuthorizations() {
            return RFileScanner.this.opts.auths;
        }

        @Override
        public boolean isSamplingEnabled() {
            return RFileScanner.this.getSamplerConfiguration() != null;
        }

        @Override
        public SamplerConfiguration getSamplerConfiguration() {
            return RFileScanner.this.getSamplerConfiguration();
        }
    }

    private static class NoopCache
    implements BlockCache {
        private NoopCache() {
        }

        @Override
        public CacheEntry cacheBlock(String blockName, byte[] buf) {
            return null;
        }

        @Override
        public CacheEntry getBlock(String blockName) {
            return null;
        }

        @Override
        public long getMaxHeapSize() {
            return this.getMaxSize();
        }

        @Override
        public long getMaxSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public BlockCache.Stats getStats() {
            return new BlockCache.Stats(){

                @Override
                public long hitCount() {
                    return 0L;
                }

                @Override
                public long requestCount() {
                    return 0L;
                }
            };
        }

        @Override
        public CacheEntry getBlock(String blockName, BlockCache.Loader loader) {
            Map<String, byte[]> depData;
            Map<String, BlockCache.Loader> depLoaders = loader.getDependencies();
            switch (depLoaders.size()) {
                case 0: {
                    depData = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<String, BlockCache.Loader> entry = depLoaders.entrySet().iterator().next();
                    depData = Collections.singletonMap(entry.getKey(), this.getBlock(entry.getKey(), entry.getValue()).getBuffer());
                    break;
                }
                default: {
                    depData = new HashMap();
                    depLoaders.forEach((k, v) -> depData.put((String)k, this.getBlock((String)k, (BlockCache.Loader)v).getBuffer()));
                }
            }
            final byte[] data = loader.load(Integer.MAX_VALUE, depData);
            return new CacheEntry(){

                @Override
                public byte[] getBuffer() {
                    return data;
                }

                @Override
                public <T extends CacheEntry.Weighable> T getIndex(Supplier<T> supplier) {
                    return null;
                }

                @Override
                public void indexWeightChanged() {
                }
            };
        }
    }

    static class Opts {
        RFileScannerBuilder.InputArgs in;
        Authorizations auths = Authorizations.EMPTY;
        long dataCacheSize;
        long indexCacheSize;
        boolean useSystemIterators = true;
        public HashMap<String, String> tableConfig;
        Range bounds;

        Opts() {
        }
    }
}

