/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer2;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.bulk.Bulk;
import org.apache.accumulo.core.clientImpl.bulk.BulkImport;
import org.apache.accumulo.core.clientImpl.bulk.BulkSerialize;
import org.apache.accumulo.core.clientImpl.bulk.LoadMappingIterator;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.bulkVer2.BulkImportMove;
import org.apache.accumulo.manager.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepBulkImport
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PrepBulkImport.class);
    private final BulkInfo bulkInfo;

    public PrepBulkImport(TableId tableId, String sourceDir, boolean setTime) {
        BulkInfo info = new BulkInfo();
        info.tableId = tableId;
        info.sourceDir = sourceDir;
        info.setTime = setTime;
        this.bulkInfo = info;
    }

    @Override
    public long isReady(long tid, Manager manager) throws Exception {
        if (!Utils.getReadLock(manager, this.bulkInfo.tableId, tid).tryLock()) {
            return 100L;
        }
        if (manager.onlineTabletServers().isEmpty()) {
            return 500L;
        }
        manager.getContext().clearTableListCache();
        return Utils.reserveHdfsDirectory(manager, this.bulkInfo.sourceDir, tid);
    }

    private static boolean equals(Function<KeyExtent, Text> extractor, KeyExtent ke1, KeyExtent ke2) {
        return Objects.equals(extractor.apply(ke1), extractor.apply(ke2));
    }

    @VisibleForTesting
    static KeyExtent validateLoadMapping(String tableId, LoadMappingIterator lmi, TabletIterFactory tabletIterFactory, int maxNumTablets, long tid) throws Exception {
        Map.Entry currRange = lmi.next();
        Text startRow = ((KeyExtent)currRange.getKey()).prevEndRow();
        Iterator<KeyExtent> tabletIter = tabletIterFactory.newTabletIter(startRow);
        KeyExtent currTablet = tabletIter.next();
        HashMap fileCounts = new HashMap();
        KeyExtent firstTablet = (KeyExtent)currRange.getKey();
        KeyExtent lastTablet = (KeyExtent)currRange.getKey();
        if (!tabletIter.hasNext() && PrepBulkImport.equals(KeyExtent::prevEndRow, currTablet, (KeyExtent)currRange.getKey()) && PrepBulkImport.equals(KeyExtent::endRow, currTablet, (KeyExtent)currRange.getKey())) {
            currRange = null;
        }
        while (tabletIter.hasNext()) {
            int count;
            if (currRange == null) {
                if (!lmi.hasNext()) break;
                currRange = lmi.next();
                lastTablet = (KeyExtent)currRange.getKey();
            }
            while (!PrepBulkImport.equals(KeyExtent::prevEndRow, currTablet, (KeyExtent)currRange.getKey()) && tabletIter.hasNext()) {
                currTablet = tabletIter.next();
            }
            boolean matchedPrevRow = PrepBulkImport.equals(KeyExtent::prevEndRow, currTablet, (KeyExtent)currRange.getKey());
            if (matchedPrevRow && firstTablet == null) {
                firstTablet = currTablet;
            }
            int n = count = matchedPrevRow ? 1 : 0;
            while (!PrepBulkImport.equals(KeyExtent::endRow, currTablet, (KeyExtent)currRange.getKey()) && tabletIter.hasNext()) {
                currTablet = tabletIter.next();
                ++count;
            }
            if (!matchedPrevRow || !PrepBulkImport.equals(KeyExtent::endRow, currTablet, (KeyExtent)currRange.getKey())) break;
            if (maxNumTablets > 0) {
                int fc = count;
                ((Bulk.Files)currRange.getValue()).forEach(fileInfo -> fileCounts.merge(fileInfo.getFileName(), fc, Integer::sum));
            }
            currRange = null;
        }
        if (currRange != null || lmi.hasNext()) {
            throw new AcceptableThriftTableOperationException(tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_CONCURRENT_MERGE, "Concurrent merge happened");
        }
        if (maxNumTablets > 0) {
            fileCounts.values().removeIf(c -> c <= maxNumTablets);
            if (!fileCounts.isEmpty()) {
                throw new AcceptableThriftTableOperationException(tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.OTHER, "Files overlap the configured max (" + maxNumTablets + ") number of tablets: " + new TreeMap(fileCounts));
            }
        }
        return new KeyExtent(firstTablet.tableId(), lastTablet.endRow(), firstTablet.prevEndRow());
    }

    private KeyExtent checkForMerge(long tid, Manager manager) throws Exception {
        VolumeManager fs = manager.getVolumeManager();
        Path bulkDir = new Path(this.bulkInfo.sourceDir);
        int maxTablets = manager.getContext().getTableConfiguration(this.bulkInfo.tableId).getCount(Property.TABLE_BULK_MAX_TABLETS);
        try (LoadMappingIterator lmi = BulkSerialize.readLoadMapping((String)bulkDir.toString(), (TableId)this.bulkInfo.tableId, arg_0 -> ((VolumeManager)fs).open(arg_0));){
            TabletIterFactory tabletIterFactory = startRow -> TabletsMetadata.builder((AccumuloClient)manager.getContext()).forTable(this.bulkInfo.tableId).overlapping(startRow, null).checkConsistency().fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.PREV_ROW}).build().stream().map(TabletMetadata::getExtent).iterator();
            KeyExtent keyExtent = PrepBulkImport.validateLoadMapping(this.bulkInfo.tableId.canonical(), lmi, tabletIterFactory, maxTablets, tid);
            return keyExtent;
        }
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        KeyExtent tabletsRange = this.checkForMerge(tid, manager);
        this.bulkInfo.firstSplit = Optional.ofNullable(tabletsRange.prevEndRow()).map(Text::getBytes).orElse(null);
        this.bulkInfo.lastSplit = Optional.ofNullable(tabletsRange.endRow()).map(Text::getBytes).orElse(null);
        log.trace("{} first split:{} last split:{}", new Object[]{FateTxId.formatTid((long)tid), tabletsRange.prevEndRow(), tabletsRange.endRow()});
        this.bulkInfo.tableState = manager.getContext().getTableState(this.bulkInfo.tableId);
        VolumeManager fs = manager.getVolumeManager();
        UniqueNameAllocator namer = manager.getContext().getUniqueNameAllocator();
        Path sourceDir = new Path(this.bulkInfo.sourceDir);
        List files = BulkImport.filterInvalid((FileStatus[])fs.listStatus(sourceDir));
        Path bulkDir = this.createNewBulkDir(manager.getContext(), fs, this.bulkInfo.tableId);
        Path mappingFile = new Path(sourceDir, "loadmap.json");
        HashMap<String, String> oldToNewNameMap = new HashMap<String, String>();
        for (FileStatus file : files) {
            String newName = "I" + namer.getNextName() + "." + FilenameUtils.getExtension((String)file.getPath().getName());
            oldToNewNameMap.put(file.getPath().getName(), new Path(bulkDir, newName).getName());
        }
        oldToNewNameMap.put(mappingFile.getName(), new Path(bulkDir, mappingFile.getName()).getName());
        BulkSerialize.writeRenameMap(oldToNewNameMap, (String)bulkDir.toString(), arg_0 -> ((VolumeManager)fs).create(arg_0));
        this.bulkInfo.bulkDir = bulkDir.toString();
        return new BulkImportMove(this.bulkInfo);
    }

    private Path createNewBulkDir(ServerContext context, VolumeManager fs, TableId tableId) throws IOException {
        Path tableDir = fs.matchingFileSystem(new Path(this.bulkInfo.sourceDir), context.getTablesDirs());
        if (tableDir == null) {
            throw new IOException(this.bulkInfo.sourceDir + " is not in the same file system as any volume configured for Accumulo");
        }
        Path directory = new Path(tableDir, tableId.canonical());
        fs.mkdirs(directory);
        UniqueNameAllocator namer = context.getUniqueNameAllocator();
        Path newBulkDir;
        while (!fs.mkdirs(newBulkDir = new Path(directory, "b-" + namer.getNextName()))) {
            log.warn("Failed to create {} for unknown reason", (Object)newBulkDir);
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        }
        return newBulkDir;
    }

    @Override
    public void undo(long tid, Manager environment) throws Exception {
        Utils.unreserveHdfsDirectory(environment, this.bulkInfo.sourceDir, tid);
        Utils.getReadLock(environment, this.bulkInfo.tableId, tid).unlock();
        TransactionWatcher.ZooArbitrator.cleanup((ServerContext)environment.getContext(), (String)"bulkTx", (long)tid);
    }

    @VisibleForTesting
    static interface TabletIterFactory {
        public Iterator<KeyExtent> newTabletIter(Text var1);
    }
}

