/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.metrics;

import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.metrics.ReplicationMetrics;
import org.apache.accumulo.manager.metrics.fate.FateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerMetrics {
    private static final Logger log = LoggerFactory.getLogger(ManagerMetrics.class);

    public static void init(AccumuloConfiguration conf, Manager m) {
        Objects.requireNonNull(conf, "AccumuloConfiguration must not be null");
        ReplicationMetrics replMetrics = new ReplicationMetrics(m);
        MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{replMetrics});
        log.info("Registered replication metrics module");
        MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{new FateMetrics(m.getContext(), conf.getTimeInMillis(Property.MANAGER_FATE_METRICS_MIN_UPDATE_INTERVAL))});
        log.info("Registered FATE metrics module");
    }
}

