/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;

public class TraceCommand
extends Shell.Command {
    private static final String SPAN_FORMAT = "%s::%s";
    private Tracer tracer;
    private Pair<Span, Scope> traceInfo;

    public TraceCommand() {
        this.disable();
    }

    private synchronized void enable(Shell shellState) {
        if (this.tracer == null) {
            this.tracer = GlobalOpenTelemetry.get().getTracer(TraceCommand.class.getSimpleName());
        }
        if (this.traceInfo == null) {
            String spanName = String.format(SPAN_FORMAT, Shell.class.getSimpleName(), shellState.getAccumuloClient().whoami());
            Span span = this.tracer.spanBuilder(spanName).startSpan();
            Scope scope = span.makeCurrent();
            this.traceInfo = new Pair((Object)span, (Object)scope);
        }
    }

    private synchronized void disable() {
        if (this.traceInfo != null) {
            try {
                ((Scope)this.traceInfo.getSecond()).close();
            }
            finally {
                ((Span)this.traceInfo.getFirst()).end();
                this.traceInfo = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException {
        if (cl.getArgs().length == 1) {
            if (cl.getArgs()[0].equalsIgnoreCase("on")) {
                this.enable(shellState);
                return 0;
            } else {
                if (!cl.getArgs()[0].equalsIgnoreCase("off")) throw new BadArgumentException("Argument must be 'on' or 'off'", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
                this.disable();
            }
            return 0;
        } else if (cl.getArgs().length == 0) {
            shellState.getWriter().println(this.traceInfo == null ? "off" : "on");
            return 0;
        } else {
            shellState.printException(new IllegalArgumentException("Expected 0 or 1 argument. There were " + cl.getArgs().length + "."));
            this.printHelp(shellState);
            return 1;
        }
    }

    @Override
    public String description() {
        return "turns tracing on or off";
    }

    @Override
    public String usage() {
        return this.getName() + " [ on | off ]";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

