/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.commons.codec.digest.Crypt;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKSecurityTool {
    private static final Logger log = LoggerFactory.getLogger(ZKSecurityTool.class);
    private static final int SALT_LENGTH = 8;
    private static final SecureRandom random = new SecureRandom();
    private static final String PW_HASH_ALGORITHM_OUTDATED = "SHA-256";
    private static final Cache<Text, String> CRYPT_PASSWORD_CACHE = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterAccess(Duration.ofMinutes(1L)).initialCapacity(4).maximumSize(64L).build();

    ZKSecurityTool() {
    }

    private static byte[] generateSalt() {
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        return salt;
    }

    @Deprecated(since="2.1.0")
    static byte[] createOutdatedPass(byte[] password) throws AccumuloException {
        byte[] salt = ZKSecurityTool.generateSalt();
        try {
            return ZKSecurityTool.convertPass(password, salt);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Count not create hashed password", (Throwable)e);
            throw new AccumuloException("Count not create hashed password", (Throwable)e);
        }
    }

    private static byte[] hash(byte[] raw) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(PW_HASH_ALGORITHM_OUTDATED);
        md.update(raw);
        return md.digest();
    }

    @Deprecated(since="2.1.0")
    static boolean checkPass(byte[] password, byte[] zkData) {
        byte[] passwordToCheck;
        if (zkData == null) {
            return false;
        }
        byte[] salt = new byte[8];
        System.arraycopy(zkData, 0, salt, 0, 8);
        try {
            passwordToCheck = ZKSecurityTool.convertPass(password, salt);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Count not create hashed password", (Throwable)e);
            return false;
        }
        return MessageDigest.isEqual(passwordToCheck, zkData);
    }

    private static byte[] convertPass(byte[] password, byte[] salt) throws NoSuchAlgorithmException {
        byte[] plainSalt = new byte[password.length + 8];
        System.arraycopy(password, 0, plainSalt, 0, password.length);
        System.arraycopy(salt, 0, plainSalt, password.length, 8);
        byte[] hashed = ZKSecurityTool.hash(plainSalt);
        byte[] saltedHash = new byte[8 + hashed.length];
        System.arraycopy(salt, 0, saltedHash, 0, 8);
        System.arraycopy(hashed, 0, saltedHash, 8, hashed.length);
        return saltedHash;
    }

    public static byte[] createPass(byte[] password) throws AccumuloException {
        String cryptHash = Crypt.crypt((byte[])password);
        return cryptHash.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean checkCryptPass(byte[] password, byte[] cryptHashInZkToTest) {
        String cryptHashToCache;
        Text key = new Text(password);
        key.append(cryptHashInZkToTest, 0, cryptHashInZkToTest.length);
        String cachedCryptHash = (String)CRYPT_PASSWORD_CACHE.getIfPresent((Object)key);
        if (cachedCryptHash != null) {
            if (MessageDigest.isEqual(cryptHashInZkToTest, cachedCryptHash.getBytes(StandardCharsets.UTF_8))) {
                return true;
            }
            CRYPT_PASSWORD_CACHE.invalidate((Object)key);
        }
        try {
            cryptHashToCache = Crypt.crypt((byte[])password, (String)new String(cryptHashInZkToTest, StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            log.error("Unrecognized hash format", (Throwable)e);
            return false;
        }
        boolean matches = MessageDigest.isEqual(cryptHashInZkToTest, cryptHashToCache.getBytes(StandardCharsets.UTF_8));
        if (matches) {
            CRYPT_PASSWORD_CACHE.put((Object)key, (Object)cryptHashToCache);
        }
        return matches;
    }

    @VisibleForTesting
    static long getCryptPasswordCacheSize() {
        CRYPT_PASSWORD_CACHE.cleanUp();
        return CRYPT_PASSWORD_CACHE.estimatedSize();
    }

    @VisibleForTesting
    static void clearCryptPasswordCache() {
        CRYPT_PASSWORD_CACHE.invalidateAll();
    }

    public static Authorizations convertAuthorizations(byte[] authorizations) {
        return new Authorizations(authorizations);
    }

    public static byte[] convertAuthorizations(Authorizations authorizations) {
        return authorizations.getAuthorizationsArray();
    }

    public static byte[] convertSystemPermissions(Set<SystemPermission> systempermissions) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(systempermissions.size());
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            for (SystemPermission sp : systempermissions) {
                out.writeByte(sp.getId());
            }
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        return bytes.toByteArray();
    }

    public static Set<SystemPermission> convertSystemPermissions(byte[] systempermissions) {
        ByteArrayInputStream bytes = new ByteArrayInputStream(systempermissions);
        DataInputStream in = new DataInputStream(bytes);
        HashSet<SystemPermission> toReturn = new HashSet<SystemPermission>();
        try {
            while (in.available() > 0) {
                toReturn.add(SystemPermission.getPermissionById((byte)in.readByte()));
            }
        }
        catch (IOException e) {
            log.error("User database is corrupt; error converting system permissions", (Throwable)e);
            toReturn.clear();
        }
        return toReturn;
    }

    public static byte[] convertTablePermissions(Set<TablePermission> tablepermissions) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(tablepermissions.size());
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            for (TablePermission tp : tablepermissions) {
                out.writeByte(tp.getId());
            }
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        return bytes.toByteArray();
    }

    public static Set<TablePermission> convertTablePermissions(byte[] tablepermissions) {
        HashSet<TablePermission> toReturn = new HashSet<TablePermission>();
        for (byte b : tablepermissions) {
            toReturn.add(TablePermission.getPermissionById((byte)b));
        }
        return toReturn;
    }

    public static byte[] convertNamespacePermissions(Set<NamespacePermission> namespacepermissions) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(namespacepermissions.size());
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            for (NamespacePermission tnp : namespacepermissions) {
                out.writeByte(tnp.getId());
            }
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        return bytes.toByteArray();
    }

    public static Set<NamespacePermission> convertNamespacePermissions(byte[] namespacepermissions) {
        HashSet<NamespacePermission> toReturn = new HashSet<NamespacePermission>();
        for (byte b : namespacepermissions) {
            toReturn.add(NamespacePermission.getPermissionById((byte)b));
        }
        return toReturn;
    }

    public static String getInstancePath(InstanceId instanceId) {
        return "/accumulo/" + instanceId;
    }

    public static boolean isOutdatedPass(byte[] zkData) {
        return zkData.length == 40;
    }
}

