/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metadata;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.metadata.RootTabletMutatorImpl;
import org.apache.accumulo.server.metadata.TabletMutatorImpl;

public class TabletsMutatorImpl
implements Ample.TabletsMutator {
    private ServerContext context;
    private BatchWriter rootWriter;
    private BatchWriter metaWriter;

    public TabletsMutatorImpl(ServerContext context) {
        this.context = context;
    }

    private BatchWriter getWriter(TableId tableId) {
        Preconditions.checkArgument((!RootTable.ID.equals((Object)tableId) ? 1 : 0) != 0);
        try {
            if (MetadataTable.ID.equals((Object)tableId)) {
                if (this.rootWriter == null) {
                    this.rootWriter = this.context.createBatchWriter(RootTable.NAME);
                }
                return this.rootWriter;
            }
            if (this.metaWriter == null) {
                this.metaWriter = this.context.createBatchWriter(MetadataTable.NAME);
            }
            return this.metaWriter;
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Ample.TabletMutator mutateTablet(KeyExtent extent) {
        if (extent.isRootTablet()) {
            return new RootTabletMutatorImpl(this.context);
        }
        return new TabletMutatorImpl(this.context, extent, this.getWriter(extent.tableId()));
    }

    public void close() {
        try {
            if (this.rootWriter != null) {
                this.rootWriter.close();
            }
            if (this.metaWriter != null) {
                this.metaWriter.close();
            }
        }
        catch (MutationsRejectedException e) {
            throw new RuntimeException(e);
        }
    }
}

