/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileObject;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileProvider;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystemConfigBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog(HdfsFileSystem.class);
    private FileSystem fs;

    protected HdfsFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    @Override
    protected void addCapabilities(Collection<Capability> capabilities) {
        capabilities.addAll(HdfsFileProvider.CAPABILITIES);
    }

    @Override
    public void close() {
        try {
            if (null != this.fs) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing HDFS client", e);
        }
        super.close();
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return this.resolveFile(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject resolveFile(FileName name) throws FileSystemException {
        FileObject fileObject;
        HdfsFileSystem hdfsFileSystem = this;
        synchronized (hdfsFileSystem) {
            if (this.fs == null) {
                String hdfsUri = name.getRootURI();
                HdfsFileSystemConfigBuilder builder = HdfsFileSystemConfigBuilder.getInstance();
                FileSystemOptions options = this.getFileSystemOptions();
                String[] configNames = builder.getConfigNames(options);
                Path[] configPaths = builder.getConfigPaths(options);
                URL[] configURLs = builder.getConfigURLs(options);
                InputStream configStream = builder.getConfigInputStream(options);
                Configuration configConfiguration = builder.getConfigConfiguration(options);
                Configuration conf = new Configuration(true);
                conf.set("fs.defaultFS", hdfsUri);
                if (configNames != null) {
                    for (String configName : configNames) {
                        log.debug((Object)("Adding HDFS configuration resource: " + (String)configName));
                        conf.addResource(configName);
                    }
                }
                if (configPaths != null) {
                    for (Path path : configPaths) {
                        log.debug((Object)("Adding HDFS configuration path: " + path));
                        conf.addResource(path);
                    }
                }
                if (configURLs != null) {
                    for (URL url : configURLs) {
                        log.debug((Object)("Adding HDFS configuration URL: " + url));
                        conf.addResource(url);
                    }
                }
                if (configStream != null) {
                    log.debug((Object)"Adding HDFS configuration stream");
                    conf.addResource(configStream);
                }
                if (configConfiguration != null) {
                    log.debug((Object)"Adding HDFS configuration object");
                    conf.addResource(configConfiguration);
                }
                try {
                    this.fs = FileSystem.get((Configuration)conf);
                }
                catch (IOException e) {
                    log.error((Object)("Error connecting to filesystem " + hdfsUri), (Throwable)e);
                    throw new FileSystemException("Error connecting to filesystem " + hdfsUri, e);
                }
            }
        }
        boolean useCache = null != this.getFileSystemManager().getFilesCache();
        FileObject fileObject2 = fileObject = useCache ? this.getFileFromCache(name) : null;
        if (null == fileObject) {
            String path;
            try {
                path = URLDecoder.decode(name.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                path = name.getPath();
            }
            Path filePath = new Path(path);
            fileObject = new HdfsFileObject((AbstractFileName)name, this, this.fs, filePath);
            fileObject = this.decorateFileObject(fileObject);
            if (useCache) {
                this.putFileToCache(fileObject);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
            fileObject.refresh();
        }
        return fileObject;
    }
}

