/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AccumuloClassLoader {
    public static final String GENERAL_CLASSPATHS = "general.classpaths";
    private static URL accumuloConfigUrl;
    private static URLClassLoader classloader;
    private static final Logger log;

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="url is specified by an admin, not unchecked user input")
    public static String getAccumuloProperty(String propertyName, String defaultValue) {
        if (accumuloConfigUrl == null) {
            log.warn("Using default value '{}' for '{}' as there is no Accumulo configuration on classpath", (Object)defaultValue, (Object)propertyName);
            return defaultValue;
        }
        try {
            PropertiesConfiguration config = new PropertiesConfiguration();
            try (InputStreamReader reader = new InputStreamReader(accumuloConfigUrl.openStream(), StandardCharsets.UTF_8);){
                config.read((Reader)reader);
            }
            String value = config.getString(propertyName);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to look up property " + propertyName + " in " + accumuloConfigUrl.getFile(), e);
        }
    }

    public static String replaceEnvVars(String classpath, Map<String, String> env) {
        Pattern envPat = Pattern.compile("\\$[A-Za-z][a-zA-Z0-9_]*");
        Matcher envMatcher = envPat.matcher((CharSequence)classpath);
        while (envMatcher.find(0)) {
            String varName = envMatcher.group().substring(1);
            String varValue = env.get(varName);
            if (varValue == null) {
                varValue = "";
            }
            classpath = ((String)classpath).substring(0, envMatcher.start()) + varValue + ((String)classpath).substring(envMatcher.end());
            envMatcher.reset((CharSequence)classpath);
        }
        return classpath;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="class path configuration is controlled by admin, not unchecked user input")
    private static void addUrl(String classpath, ArrayList<URL> urls) throws MalformedURLException {
        if ((classpath = classpath.trim()).isEmpty()) {
            return;
        }
        classpath = AccumuloClassLoader.replaceEnvVars(classpath, System.getenv());
        URI uri = null;
        try {
            uri = new URI(classpath);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uri == null || !uri.isAbsolute() || uri.getScheme() != null && uri.getScheme().equals("file://")) {
            File extDir = new File(classpath);
            if (extDir.isDirectory()) {
                urls.add(extDir.toURI().toURL());
            } else if (extDir.getParentFile() != null) {
                Pattern pattern = Pattern.compile(extDir.getName());
                File[] extJars = extDir.getParentFile().listFiles((dir, name) -> pattern.matcher(name).matches());
                if (extJars != null && extJars.length > 0) {
                    for (File jar : extJars) {
                        urls.add(jar.toURI().toURL());
                    }
                } else {
                    log.debug("ignoring classpath entry {}", (Object)classpath);
                }
            } else {
                log.debug("ignoring classpath entry {}", (Object)classpath);
            }
        } else {
            urls.add(uri.toURL());
        }
    }

    private static ArrayList<URL> findAccumuloURLs() throws IOException {
        String cp = AccumuloClassLoader.getAccumuloProperty(GENERAL_CLASSPATHS, null);
        if (cp == null) {
            return new ArrayList<URL>();
        }
        log.warn("'{}' is deprecated but was set to '{}' ", (Object)GENERAL_CLASSPATHS, (Object)cp);
        String[] cps = AccumuloClassLoader.replaceEnvVars(cp, System.getenv()).split(",");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String classpath : cps) {
            if (classpath.startsWith("#")) continue;
            AccumuloClassLoader.addUrl(classpath, urls);
        }
        return urls;
    }

    public static synchronized ClassLoader getClassLoader() throws IOException {
        if (classloader == null) {
            ArrayList<URL> urls = AccumuloClassLoader.findAccumuloURLs();
            ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
            log.debug("Create 2nd tier ClassLoader using URLs: {}", urls);
            classloader = new URLClassLoader("AccumuloClassLoader (loads everything defined by general.classpaths)", urls.toArray(new URL[urls.size()]), parentClassLoader){

                @Override
                protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    Class<?> c;
                    if (name.startsWith("org.apache.accumulo.start.classloader.vfs") && (c = this.findLoadedClass(name)) == null) {
                        try {
                            this.findClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    return super.loadClass(name, resolve);
                }
            };
        }
        return classloader;
    }

    static {
        block7: {
            log = LoggerFactory.getLogger(AccumuloClassLoader.class);
            String configFile = System.getProperty("accumulo.properties", "accumulo.properties");
            if (configFile.startsWith("file://")) {
                try {
                    File f = new File(new URI(configFile));
                    if (f.exists() && !f.isDirectory()) {
                        accumuloConfigUrl = f.toURI().toURL();
                        break block7;
                    }
                    log.warn("Failed to load Accumulo configuration from " + configFile);
                }
                catch (MalformedURLException | URISyntaxException e) {
                    log.warn("Failed to load Accumulo configuration from " + configFile, (Throwable)e);
                }
            } else {
                accumuloConfigUrl = AccumuloClassLoader.class.getClassLoader().getResource(configFile);
                if (accumuloConfigUrl == null) {
                    log.warn("Failed to load Accumulo configuration '{}' from classpath", (Object)configFile);
                }
            }
        }
        if (accumuloConfigUrl != null) {
            log.debug("Using Accumulo configuration at {}", (Object)accumuloConfigUrl.getFile());
        }
    }
}

