/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.server.security;

import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.Assert;
import org.junit.Test;

public class SystemCredentialsIT
extends ConfigurableMacBase {
    private static final int SCAN_FAILED = 7;
    private static final int AUTHENICATION_FAILED = 8;

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testSystemCredentials() throws Exception {
        Assert.assertEquals((long)0L, (long)this.exec(SystemCredentialsIT.class, "good", this.getCluster().getZooKeepers()).waitFor());
        Assert.assertEquals((long)8L, (long)this.exec(SystemCredentialsIT.class, "bad", this.getCluster().getZooKeepers()).waitFor());
        Assert.assertEquals((long)8L, (long)this.exec(SystemCredentialsIT.class, "bad_password", this.getCluster().getZooKeepers()).waitFor());
    }

    public static void main(String[] args) throws AccumuloException, TableNotFoundException {
        SiteConfiguration siteConfig = new SiteConfiguration();
        try (ServerContext context = new ServerContext(siteConfig);){
            SystemCredentials creds;
            String badInstanceID = SystemCredentials.class.getName();
            if (args.length < 2) {
                throw new RuntimeException("Incorrect usage; expected to be run by test only");
            }
            switch (args[0]) {
                case "bad": {
                    creds = SystemCredentials.get((String)badInstanceID, (SiteConfiguration)siteConfig);
                    break;
                }
                case "good": {
                    creds = SystemCredentials.get((String)context.getInstanceID(), (SiteConfiguration)siteConfig);
                    break;
                }
                case "bad_password": {
                    creds = new SystemCredentials(badInstanceID, "!SYSTEM", (AuthenticationToken)new PasswordToken((CharSequence)"fake"));
                    break;
                }
                default: {
                    throw new RuntimeException("Incorrect usage; expected to be run by test only");
                }
            }
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(context.getProperties()).as((CharSequence)creds.getPrincipal(), creds.getToken()).build();){
                client.securityOperations().authenticateUser(creds.getPrincipal(), creds.getToken());
                try (Scanner scan = client.createScanner(RootTable.NAME, Authorizations.EMPTY);){
                    for (Map.Entry e : scan) {
                        e.hashCode();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace(System.err);
                    System.exit(7);
                }
            }
            catch (AccumuloSecurityException e) {
                e.printStackTrace(System.err);
                System.exit(8);
            }
        }
    }
}

