/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StatusCombinerMacIT
extends SharedMiniClusterBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testCombinerSetOnMetadata() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(StatusCombinerMacIT.getClientProps()).build();){
            TableOperations tops = client.tableOperations();
            Map iterators = tops.listIterators(MetadataTable.NAME);
            Assert.assertTrue((boolean)iterators.containsKey("replcombiner"));
            EnumSet scopes = (EnumSet)iterators.get("replcombiner");
            Assert.assertEquals((long)3L, (long)scopes.size());
            Assert.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.scan));
            Assert.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.minc));
            Assert.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.majc));
            Iterable propIter = tops.getProperties(MetadataTable.NAME);
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry entry : propIter) {
                properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            for (IteratorUtil.IteratorScope scope : scopes) {
                String key = Property.TABLE_ITERATOR_PREFIX.getKey() + scope.name() + "." + "replcombiner" + ".opt.columns";
                Assert.assertTrue((String)("Properties did not contain key : " + key), (boolean)properties.containsKey(key));
                Assert.assertEquals((Object)MetadataSchema.ReplicationSection.COLF.toString(), properties.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(StatusCombinerMacIT.getClientProps()).build();){
            Map.Entry entry;
            ClusterUser user = this.getAdminUser();
            ReplicationTable.setOnline((AccumuloClient)client);
            client.securityOperations().grantTablePermission(user.getPrincipal(), ReplicationTable.NAME, TablePermission.WRITE);
            long createTime = System.currentTimeMillis();
            try (BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)client);){
                Mutation m = new Mutation((CharSequence)"file:/accumulo/wal/HW10447.local+56808/93cdc17e-7521-44fa-87b5-37f45bcb92d3");
                ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"1"), (Value)StatusUtil.fileCreatedValue((long)createTime));
                bw.addMutation(m);
            }
            try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                Assert.assertEquals((Object)StatusUtil.fileCreatedValue((long)createTime), entry.getValue());
                bw = ReplicationTable.getBatchWriter((AccumuloClient)client);
                try {
                    Mutation m = new Mutation((CharSequence)"file:/accumulo/wal/HW10447.local+56808/93cdc17e-7521-44fa-87b5-37f45bcb92d3");
                    ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"1"), (Value)ProtobufUtil.toValue((GeneratedMessage)StatusUtil.replicated((long)Long.MAX_VALUE)));
                    bw.addMutation(m);
                }
                finally {
                    bw.close();
                }
            }
            s = ReplicationTable.getScanner((AccumuloClient)client);
            try {
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
                Replication.Status stat = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                Assert.assertEquals((long)Long.MAX_VALUE, (long)stat.getBegin());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }
}

