/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterators;
import com.google.protobuf.GeneratedMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.replication.SequentialWorkAssigner;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInstanceReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MultiInstanceReplicationIT.class);
    private ExecutorService executor;

    @Override
    public int defaultTimeoutSeconds() {
        return 600;
    }

    @Before
    public void createExecutor() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void stopExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "2M");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "5s");
        cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
        cfg.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL, "1s");
        cfg.setProperty(Property.REPLICATION_MAX_UNIT_SIZE, "8M");
        cfg.setProperty(Property.REPLICATION_NAME, "master");
        cfg.setProperty(Property.REPLICATION_WORK_ASSIGNER, SequentialWorkAssigner.class.getName());
        cfg.setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, "1M");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void updatePeerConfigFromPrimary(MiniAccumuloConfigImpl primaryCfg, MiniAccumuloConfigImpl peerCfg) {
        String credProvider;
        Map primarySiteConfig = primaryCfg.getSiteConfig();
        if ("true".equals(primarySiteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            String truststorePassword;
            HashMap<String, String> peerSiteConfig = new HashMap<String, String>();
            peerSiteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
            String keystorePath = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PATH.getKey());
            Assert.assertNotNull((String)"Keystore Path was null", (Object)keystorePath);
            peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), keystorePath);
            String truststorePath = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PATH.getKey());
            Assert.assertNotNull((String)"Truststore Path was null", (Object)truststorePath);
            peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), truststorePath);
            String keystorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey());
            if (keystorePassword != null) {
                peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), keystorePassword);
            }
            if ((truststorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey())) != null) {
                peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), truststorePassword);
            }
            System.out.println("Setting site configuration for peer " + peerSiteConfig);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
        if ((credProvider = (String)primarySiteConfig.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey())) != null) {
            Map peerSiteConfig = peerCfg.getSiteConfig();
            peerSiteConfig.put(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey(), credProvider);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void dataWasReplicatedToThePeer() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(MultiInstanceReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        MiniAccumuloClusterImpl peerCluster = new MiniAccumuloClusterImpl(peerCfg);
        peerCluster.start();
        try (AccumuloClient clientMaster = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
             AccumuloClient clientPeer = peerCluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            ReplicationTable.setOnline((AccumuloClient)clientMaster);
            String peerUserName = "peer";
            String peerPassword = "foo";
            String peerClusterName = "peer";
            clientPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peerCluster.getInstanceName(), (String)peerCluster.getZooKeepers())));
            String masterTable = "master";
            String peerTable = "peer";
            clientPeer.tableOperations().create("peer", new NewTableConfiguration());
            String peerTableId = (String)clientPeer.tableOperations().tableIdMap().get("peer");
            Assert.assertNotNull((Object)peerTableId);
            clientPeer.securityOperations().grantTablePermission(peerUserName, "peer", TablePermission.WRITE);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_REPLICATION.getKey(), "true");
            props.put(Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId);
            clientMaster.tableOperations().create("master", new NewTableConfiguration().setProperties(props));
            String masterTableId = (String)clientMaster.tableOperations().tableIdMap().get("master");
            Assert.assertNotNull((Object)masterTableId);
            try (BatchWriter bw = clientMaster.createBatchWriter("master");){
                for (int rows = 0; rows < 5000; ++rows) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(rows));
                    for (int cols = 0; cols < 100; ++cols) {
                        String value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                    }
                    bw.addMutation(m);
                }
            }
            log.info("Wrote all data to master cluster");
            Set filesNeedingReplication = clientMaster.replicationOperations().referencedFiles("master");
            log.info("Files to replicate: " + filesNeedingReplication);
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            log.info("TabletServer restarted");
            Iterators.size((Iterator)ReplicationTable.getScanner((AccumuloClient)clientMaster).iterator());
            log.info("TabletServer is online");
            while (!ReplicationTable.isOnline((AccumuloClient)clientMaster)) {
                log.info("Replication table still offline, waiting");
                Thread.sleep(5000L);
            }
            log.info("");
            log.info("Fetching metadata records:");
            for (Map.Entry kv : clientMaster.createScanner(MetadataTable.NAME, Authorizations.EMPTY)) {
                if (MetadataSchema.ReplicationSection.COLF.equals((Object)((Key)kv.getKey()).getColumnFamily())) {
                    log.info("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
                    continue;
                }
                log.info("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), kv.getValue());
            }
            log.info("");
            log.info("Fetching replication records:");
            for (Map.Entry kv : ReplicationTable.getScanner((AccumuloClient)clientMaster)) {
                log.info("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
            }
            Future<Boolean> future = this.executor.submit(() -> {
                long then = System.currentTimeMillis();
                clientMaster.replicationOperations().drain("master", filesNeedingReplication);
                long now = System.currentTimeMillis();
                log.info("Drain completed in " + (now - then) + "ms");
                return true;
            });
            try {
                future.get(60L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                Assert.fail((String)"Drain did not finish within 60 seconds");
            }
            finally {
                this.executor.shutdownNow();
            }
            log.info("drain completed");
            log.info("");
            log.info("Fetching metadata records:");
            for (Map.Entry kv : clientMaster.createScanner(MetadataTable.NAME, Authorizations.EMPTY)) {
                if (MetadataSchema.ReplicationSection.COLF.equals((Object)((Key)kv.getKey()).getColumnFamily())) {
                    log.info("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
                    continue;
                }
                log.info("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), kv.getValue());
            }
            log.info("");
            log.info("Fetching replication records:");
            for (Map.Entry kv : ReplicationTable.getScanner((AccumuloClient)clientMaster)) {
                log.info("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
            }
            try (Scanner master = clientMaster.createScanner("master", Authorizations.EMPTY);
                 Scanner peer = clientPeer.createScanner("peer", Authorizations.EMPTY);){
                Iterator masterIter = master.iterator();
                Iterator peerIter = peer.iterator();
                Map.Entry masterEntry = null;
                Map.Entry peerEntry = null;
                while (masterIter.hasNext() && peerIter.hasNext()) {
                    masterEntry = (Map.Entry)masterIter.next();
                    peerEntry = (Map.Entry)peerIter.next();
                    Assert.assertEquals((String)(masterEntry.getKey() + " was not equal to " + peerEntry.getKey()), (long)0L, (long)((Key)masterEntry.getKey()).compareTo((Key)peerEntry.getKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS));
                    Assert.assertEquals(masterEntry.getValue(), peerEntry.getValue());
                }
                log.info("Last master entry: {}", masterEntry);
                log.info("Last peer entry: {}", peerEntry);
                Assert.assertFalse((String)"Had more data to read from the master", (boolean)masterIter.hasNext());
                Assert.assertFalse((String)"Had more data to read from the peer", (boolean)peerIter.hasNext());
            }
        }
        finally {
            peerCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReplicatedToCorrectTable() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(MultiInstanceReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        MiniAccumuloClusterImpl peer1Cluster = new MiniAccumuloClusterImpl(peerCfg);
        peer1Cluster.start();
        try (AccumuloClient clientMaster = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
             AccumuloClient clientPeer = peer1Cluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            String peerClusterName = "peer";
            String peerUserName = "peer";
            String peerPassword = "foo";
            clientPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peer1Cluster.getInstanceName(), (String)peer1Cluster.getZooKeepers())));
            String masterTable1 = "master1";
            String peerTable1 = "peer1";
            String masterTable2 = "master2";
            String peerTable2 = "peer2";
            clientPeer.tableOperations().create(peerTable1, new NewTableConfiguration());
            String peerTableId1 = (String)clientPeer.tableOperations().tableIdMap().get(peerTable1);
            Assert.assertNotNull((Object)peerTableId1);
            clientPeer.tableOperations().create(peerTable2, new NewTableConfiguration());
            String peerTableId2 = (String)clientPeer.tableOperations().tableIdMap().get(peerTable2);
            Assert.assertNotNull((Object)peerTableId2);
            HashMap<String, String> props1 = new HashMap<String, String>();
            props1.put(Property.TABLE_REPLICATION.getKey(), "true");
            props1.put(Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId1);
            clientMaster.tableOperations().create(masterTable1, new NewTableConfiguration().setProperties(props1));
            String masterTableId1 = (String)clientMaster.tableOperations().tableIdMap().get(masterTable1);
            Assert.assertNotNull((Object)masterTableId1);
            HashMap<String, String> props2 = new HashMap<String, String>();
            props2.put(Property.TABLE_REPLICATION.getKey(), "true");
            props2.put(Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId2);
            clientMaster.tableOperations().create(masterTable2, new NewTableConfiguration().setProperties(props2));
            String masterTableId2 = (String)clientMaster.tableOperations().tableIdMap().get(masterTable2);
            Assert.assertNotNull((Object)masterTableId2);
            clientPeer.securityOperations().grantTablePermission(peerUserName, peerTable1, TablePermission.WRITE);
            clientPeer.securityOperations().grantTablePermission(peerUserName, peerTable2, TablePermission.WRITE);
            long masterTable1Records = 0L;
            try (BatchWriter bw = clientMaster.createBatchWriter(masterTable1);){
                for (int rows = 0; rows < 2500; ++rows) {
                    Mutation m = new Mutation((CharSequence)(masterTable1 + rows));
                    for (int cols = 0; cols < 100; ++cols) {
                        String value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                        ++masterTable1Records;
                    }
                    bw.addMutation(m);
                }
            }
            long masterTable2Records = 0L;
            try (BatchWriter bw = clientMaster.createBatchWriter(masterTable2);){
                for (int rows = 0; rows < 2500; ++rows) {
                    Mutation m = new Mutation((CharSequence)(masterTable2 + rows));
                    for (int cols = 0; cols < 100; ++cols) {
                        String value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                        ++masterTable2Records;
                    }
                    bw.addMutation(m);
                }
            }
            log.info("Wrote all data to master cluster");
            Set filesFor1 = clientMaster.replicationOperations().referencedFiles(masterTable1);
            Set filesFor2 = clientMaster.replicationOperations().referencedFiles(masterTable2);
            log.info("Files to replicate for table1: " + filesFor1);
            log.info("Files to replicate for table2: " + filesFor2);
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            log.info("Restarted the tserver");
            Iterators.size((Iterator)clientMaster.createScanner(masterTable1, Authorizations.EMPTY).iterator());
            while (!ReplicationTable.isOnline((AccumuloClient)clientMaster)) {
                log.info("Replication table still offline, waiting");
                Thread.sleep(5000L);
            }
            log.info("Waiting for {} for {}", (Object)filesFor1, (Object)masterTable1);
            clientMaster.replicationOperations().drain(masterTable1, filesFor1);
            log.info("Waiting for {} for {}", (Object)filesFor2, (Object)masterTable2);
            clientMaster.replicationOperations().drain(masterTable2, filesFor2);
            long countTable = 0L;
            for (Map.Entry entry : clientPeer.createScanner(peerTable1, Authorizations.EMPTY)) {
                ++countTable;
                Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable1));
            }
            log.info("Found {} records in {}", (Object)countTable, (Object)peerTable1);
            Assert.assertEquals((long)masterTable1Records, (long)countTable);
            countTable = 0L;
            for (Map.Entry entry : clientPeer.createScanner(peerTable2, Authorizations.EMPTY)) {
                ++countTable;
                Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable2));
            }
            log.info("Found {} records in {}", (Object)countTable, (Object)peerTable2);
            Assert.assertEquals((long)masterTable2Records, (long)countTable);
        }
        finally {
            peer1Cluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataWasReplicatedToThePeerWithoutDrain() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(MultiInstanceReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        MiniAccumuloClusterImpl peerCluster = new MiniAccumuloClusterImpl(peerCfg);
        peerCluster.start();
        try (AccumuloClient clientMaster = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
             AccumuloClient clientPeer = peerCluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            String peerUserName = "repl";
            String peerPassword = "passwd";
            clientPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            String peerClusterName = "peer";
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peerCluster.getInstanceName(), (String)peerCluster.getZooKeepers())));
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            String masterTable = "master";
            String peerTable = "peer";
            clientPeer.tableOperations().create(peerTable, new NewTableConfiguration());
            String peerTableId = (String)clientPeer.tableOperations().tableIdMap().get(peerTable);
            Assert.assertNotNull((Object)peerTableId);
            clientPeer.securityOperations().grantTablePermission(peerUserName, peerTable, TablePermission.WRITE);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_REPLICATION.getKey(), "true");
            props.put(Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId);
            clientMaster.tableOperations().create(masterTable, new NewTableConfiguration().setProperties(props));
            String masterTableId = (String)clientMaster.tableOperations().tableIdMap().get(masterTable);
            Assert.assertNotNull((Object)masterTableId);
            try (BatchWriter bw = clientMaster.createBatchWriter(masterTable);){
                for (int rows = 0; rows < 5000; ++rows) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(rows));
                    for (int cols = 0; cols < 100; ++cols) {
                        String value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                    }
                    bw.addMutation(m);
                }
            }
            log.info("Wrote all data to master cluster");
            Set files = clientMaster.replicationOperations().referencedFiles(masterTable);
            log.info("Files to replicate:" + files);
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            while (!ReplicationTable.isOnline((AccumuloClient)clientMaster)) {
                log.info("Replication table still offline, waiting");
                Thread.sleep(5000L);
            }
            Iterators.size((Iterator)clientMaster.createScanner(masterTable, Authorizations.EMPTY).iterator());
            for (Map.Entry kv : ReplicationTable.getScanner((AccumuloClient)clientMaster)) {
                log.debug("{} {}", (Object)((Key)kv.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
            }
            clientMaster.replicationOperations().drain(masterTable, files);
            try (Scanner master = clientMaster.createScanner(masterTable, Authorizations.EMPTY);
                 Scanner peer = clientPeer.createScanner(peerTable, Authorizations.EMPTY);){
                Iterator masterIter = master.iterator();
                Iterator peerIter = peer.iterator();
                while (masterIter.hasNext() && peerIter.hasNext()) {
                    Map.Entry masterEntry = (Map.Entry)masterIter.next();
                    Map.Entry peerEntry = (Map.Entry)peerIter.next();
                    Assert.assertEquals((String)(peerEntry.getKey() + " was not equal to " + peerEntry.getKey()), (long)0L, (long)((Key)masterEntry.getKey()).compareTo((Key)peerEntry.getKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS));
                    Assert.assertEquals(masterEntry.getValue(), peerEntry.getValue());
                }
                Assert.assertFalse((String)"Had more data to read from the master", (boolean)masterIter.hasNext());
                Assert.assertFalse((String)"Had more data to read from the peer", (boolean)peerIter.hasNext());
            }
        }
        finally {
            peerCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReplicatedToCorrectTableWithoutDrain() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(MultiInstanceReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        MiniAccumuloClusterImpl peer1Cluster = new MiniAccumuloClusterImpl(peerCfg);
        peer1Cluster.start();
        try (AccumuloClient clientMaster = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
             AccumuloClient clientPeer = peer1Cluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            int i;
            String value;
            int cols;
            Mutation m;
            int rows;
            String peerClusterName = "peer";
            String peerUserName = "repl";
            String peerPassword = "passwd";
            clientPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            clientMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peer1Cluster.getInstanceName(), (String)peer1Cluster.getZooKeepers())));
            String masterTable1 = "master1";
            String peerTable1 = "peer1";
            String masterTable2 = "master2";
            String peerTable2 = "peer2";
            clientPeer.tableOperations().create(peerTable1, new NewTableConfiguration());
            String peerTableId1 = (String)clientPeer.tableOperations().tableIdMap().get(peerTable1);
            Assert.assertNotNull((Object)peerTableId1);
            clientPeer.tableOperations().create(peerTable2, new NewTableConfiguration());
            String peerTableId2 = (String)clientPeer.tableOperations().tableIdMap().get(peerTable2);
            Assert.assertNotNull((Object)peerTableId2);
            HashMap<String, String> props1 = new HashMap<String, String>();
            props1.put(Property.TABLE_REPLICATION.getKey(), "true");
            props1.put(Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId2);
            clientMaster.tableOperations().create(masterTable1, new NewTableConfiguration().setProperties(props1));
            String masterTableId1 = (String)clientMaster.tableOperations().tableIdMap().get(masterTable1);
            Assert.assertNotNull((Object)masterTableId1);
            HashMap<String, String> props2 = new HashMap<String, String>();
            props2.put(Property.TABLE_REPLICATION.getKey(), "true");
            props2.put(Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId2);
            clientMaster.tableOperations().create(masterTable2, new NewTableConfiguration().setProperties(props2));
            String masterTableId2 = (String)clientMaster.tableOperations().tableIdMap().get(masterTable2);
            Assert.assertNotNull((Object)masterTableId2);
            clientPeer.securityOperations().grantTablePermission(peerUserName, peerTable1, TablePermission.WRITE);
            clientPeer.securityOperations().grantTablePermission(peerUserName, peerTable2, TablePermission.WRITE);
            clientMaster.tableOperations().setProperty(masterTable1, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId1);
            clientMaster.tableOperations().setProperty(masterTable2, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId2);
            try (Object bw = clientMaster.createBatchWriter(masterTable1);){
                for (rows = 0; rows < 2500; ++rows) {
                    m = new Mutation((CharSequence)(masterTable1 + rows));
                    for (cols = 0; cols < 100; ++cols) {
                        value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                    }
                    bw.addMutation(m);
                }
            }
            bw = clientMaster.createBatchWriter(masterTable2);
            try {
                for (rows = 0; rows < 2500; ++rows) {
                    m = new Mutation((CharSequence)(masterTable2 + rows));
                    for (cols = 0; cols < 100; ++cols) {
                        value = Integer.toString(cols);
                        m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                    }
                    bw.addMutation(m);
                }
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            log.info("Wrote all data to master cluster");
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            while (!ReplicationTable.isOnline((AccumuloClient)clientMaster)) {
                log.info("Replication table still offline, waiting");
                Thread.sleep(5000L);
            }
            boolean fullyReplicated = false;
            for (int i2 = 0; i2 < 10 && !fullyReplicated; ++i2) {
                UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                try (Scanner s = ReplicationTable.getScanner((AccumuloClient)clientMaster);){
                    ReplicationSchema.WorkSection.limit((ScannerBase)s);
                    for (Map.Entry entry : s) {
                        Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                        if (!StatusUtil.isFullyReplicated((Replication.Status)status)) continue;
                        fullyReplicated |= true;
                    }
                    continue;
                }
            }
            Assert.assertNotEquals((Object)0, (Object)fullyReplicated);
            long countTable = 0L;
            for (i = 0; i < 10; ++i) {
                for (Map.Entry entry : clientPeer.createScanner(peerTable1, Authorizations.EMPTY)) {
                    ++countTable;
                    Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable1));
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable1);
                if (countTable != 0L) break;
                Thread.sleep(5000L);
            }
            Assert.assertTrue((String)("Found no records in " + peerTable1 + " in the peer cluster"), (countTable > 0L ? 1 : 0) != 0);
            for (i = 0; i < 10; ++i) {
                countTable = 0L;
                for (Map.Entry entry : clientPeer.createScanner(peerTable2, Authorizations.EMPTY)) {
                    ++countTable;
                    Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable2));
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable2);
                if (countTable != 0L) break;
                Thread.sleep(5000L);
            }
            Assert.assertTrue((String)("Found no records in " + peerTable2 + " in the peer cluster"), (countTable > 0L ? 1 : 0) != 0);
        }
        finally {
            peer1Cluster.stop();
        }
    }
}

